/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.protocal.converters.basic;

import net.buffalo.protocal.ProtocolException;
import net.buffalo.protocal.converters.Converter;
import net.buffalo.protocal.converters.basic.AbstractBasicConverter;
import net.buffalo.protocal.io.MarshallingContext;
import net.buffalo.protocal.io.StreamWriter;

public class BooleanConverter
extends AbstractBasicConverter
implements Converter {
    @Override
    public boolean canConvert(Class type) {
        if (type == null) {
            return false;
        }
        return type.equals(Boolean.TYPE) || type.equals(Boolean.class);
    }

    @Override
    public Object fromString(String value) {
        if (value.equals("1")) {
            return Boolean.TRUE;
        }
        if (value.equals("0")) {
            return Boolean.FALSE;
        }
        throw new ProtocolException("<boolean> contains only 1 or 0: " + value);
    }

    @Override
    public void marshal(Object source, MarshallingContext context, StreamWriter streamWriter) {
        Boolean b = (Boolean)source;
        streamWriter.startNode("boolean");
        streamWriter.setValue(String.valueOf(b != false ? 1 : 0));
        streamWriter.endNode();
    }
}

