/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.util;

import com.kingdee.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivacyProtectUtil {
    private static final Logger logger = LoggerFactory.getLogger(PrivacyProtectUtil.class);

    public static String hideEmailInfo(String email) {
        if (StringUtils.isEmpty((String)email)) {
            return email;
        }
        int mid = email.lastIndexOf("@");
        int suffix = email.lastIndexOf(".");
        if (suffix < 0 || mid < 0 || suffix < mid) {
            return email;
        }
        char[] charArray = email.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (i == 0 || i == mid || i >= suffix) continue;
            charArray[i] = "*".charAt(0);
        }
        return new String(charArray);
    }

    public static String hidePhoneInfo(String newPhone) {
        if (newPhone == null || newPhone.length() == 0) {
            return "";
        }
        if (newPhone.contains("+")) {
            String[] split = newPhone.split("-", 2);
            String realPhone = split[1];
            int length = realPhone.length();
            if (length == 0) {
                return newPhone;
            }
            if (length < 3) {
                return split[0] + "-**";
            }
            return split[0] + "-" + PrivacyProtectUtil.calculateHide(realPhone);
        }
        if (newPhone.length() == 11) {
            String replaceCell = newPhone.replaceAll("(\\d{3})\\d{4}(\\w{4})", "$1****$2");
            return replaceCell;
        }
        return PrivacyProtectUtil.calculateHide(newPhone);
    }

    private static String calculateHide(String oldPhone) {
        int length = oldPhone.length();
        int hideLength = length % 2 == 0 ? length / 2 : length / 2 + 1;
        int start = (length - hideLength) / 2;
        int end = start + hideLength;
        String substring = oldPhone.substring(0, start);
        String substring2 = oldPhone.substring(end, length);
        StringBuilder hideChar = new StringBuilder(hideLength);
        for (int count = 0; count < hideLength; ++count) {
            hideChar.append("*");
        }
        return substring + hideChar.toString() + substring2;
    }
}

