/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.framework.session.PassiveCallbackHandler;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.cp.eip.sso.web.EASCredentials;
import com.kingdee.eas.cp.eip.sso.web.auth.EASCallbackHandler;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EASCallbackHandlerForCas3 {
    private Logger logger = Logger.getLogger((String)EASCallbackHandler.class.getName());
    private LoginContext loginContext = null;
    private Context userContext = null;

    public PassiveCallbackHandler createCallbackHandler(EASCredentials easCredentials) throws BOSLoginException {
        LoginContext loginCtx = null;
        Context userCtx = null;
        String easSessionId = easCredentials.getEasSessionId();
        if (easSessionId == null || "".equals(easSessionId)) {
            throw new BOSLoginException("[EAS Auth]Please assign required parameter.easSessionId=[" + easSessionId + "]");
        }
        loginCtx = this.createLoginContext(easCredentials);
        loginCtx.setContextID(easSessionId);
        userCtx = this.createUserContext(loginCtx);
        this.fillContext(loginCtx, userCtx);
        this.fillSessionId(easSessionId, userCtx);
        this.setLoginContext(loginCtx);
        this.setUserContext(userCtx);
        PassiveCallbackHandler cbh = new PassiveCallbackHandler(loginCtx, userCtx);
        return cbh;
    }

    private LoginContext createLoginContext(EASCredentials easCredentials) throws BOSLoginException {
        String slnName = easCredentials.getSolutionName();
        String dataCenter = easCredentials.getDataCenter();
        String localeStr = easCredentials.getLocale();
        String dbTypeStr = easCredentials.getDbType();
        String clientHostIP = easCredentials.getClientHostIP();
        String clientHostName = easCredentials.getClientHostName();
        if (!StringUtils.isEmpty((String)dataCenter) && dataCenter.indexOf("'") != -1) {
            throw new BOSLoginException("[EAS Auth]invalid dataCenter");
        }
        if (!StringUtils.isEmpty((String)localeStr) && localeStr.indexOf("'") != -1) {
            throw new BOSLoginException("[EAS Auth]invalid localeStr");
        }
        if (slnName == null || "".equals(slnName) || dataCenter == null || "".equals(dataCenter) || localeStr == null || "".equals(localeStr)) {
            throw new BOSLoginException("[EAS Auth]Please assign required parameter.solutionName=[" + slnName + "],dataCenter=[" + dataCenter + "],locale=[" + localeStr + "],dbType=[" + dbTypeStr + "]");
        }
        Locale locale = new Locale(localeStr);
        int dbType = 0;
        try {
            dbType = Integer.parseInt(dbTypeStr);
        }
        catch (NumberFormatException e) {
            this.logger.debug((Object)("dbType is not a number:" + dbTypeStr));
            throw new BOSLoginException("dbType is not a number:" + dbTypeStr);
        }
        String username = easCredentials.getUsername();
        String password = easCredentials.getPassword();
        String encodedPwd = this.encodePassword(username, password);
        LoginContext ctx = new LoginContext(username, encodedPwd, slnName, dataCenter, locale, clientHostIP, clientHostName);
        ctx.put("dbType", (Object)EASCallbackHandlerForCas3.getDbType(dbType));
        ctx.put("dbTypeCode", (Object)dbType);
        ctx.setLoginType(LoginType.PORTAL);
        String authPattern = easCredentials.getUserAuthPattern();
        if (authPattern != null && !authPattern.equals("")) {
            ctx.put("UserAuthPattern", (Object)authPattern);
        }
        String loginFlow = easCredentials.getLoginFlow();
        boolean isNewLoginFlow = false;
        isNewLoginFlow = "oncerpc".equalsIgnoreCase(loginFlow);
        ctx.put("SwitchToNewLoginFlow", (Object)Boolean.toString(isNewLoginFlow));
        this.fillLoginCtx(ctx, easCredentials.getContext());
        return ctx;
    }

    private void fillLoginCtx(LoginContext lctx, Map credentialsContext) {
        for (String key : credentialsContext.keySet()) {
            lctx.put(key, credentialsContext.get(key));
        }
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    public void setLoginContext(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    public Context getUserContext() {
        return this.userContext;
    }

    public void setUserContext(Context userContext) {
        this.userContext = userContext;
    }

    private void fillSessionId(String easSessionId, Context userCtx) {
        userCtx.put((Object)"SessionId", (Object)easSessionId);
    }

    private void fillContext(LoginContext loginCtx, Context userCtx) {
        Iterator it = loginCtx.items.entrySet().iterator();
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = it.next();
            userCtx.put(entry.getKey(), entry.getValue());
        }
    }

    private Context createUserContext(LoginContext loginCtx) {
        Context userContext = new Context(null, loginCtx.getSlnName(), loginCtx.getAis(), loginCtx.getLocale(), loginCtx.getContextID());
        return userContext;
    }

    private static String getDbType(int dbType) {
        return DbType.getName((int)dbType);
    }

    public String encodePassword(String userName, String password) {
        String encodedPassword = "";
        try {
            encodedPassword = CryptoTean.encrypt((String)userName, (String)password);
            this.logger.debug((Object)("[EAS Portal] password=" + password + ",encodePwd=" + encodedPassword));
        }
        catch (CryptException e) {
            this.logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)e));
        }
        return encodedPassword;
    }
}

