/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.file.LicenseValidateInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.eip.sso.web.auth.EASCallbackHandler;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class EASWebLicenceHelper {
    private static Logger logger = Logger.getLogger(EASWebLicenceHelper.class);
    public static final String LICENSE_USER = "licesnseId";
    public static final String PORTAL_PKG = "com.kingdee.eas.portal.web.action.PortalAction";
    public static final String DYNAMIC_PASSWORD_PKG = "com.kingdee.eas.cp.eip.sso.web.controller.DynPasswordController";
    public static final String SSO_PKG = "com.kingdee.eas.cp.eip.sso.client.LdapMapListUI";
    public static final String strResource = "com.kingdee.eas.framework.FrameWorkResource.";
    public static final String LICENSE_CHECK_KEY = "LICENSE_CHECK";
    public static final String LICENSE_CHECK_PASS = "Y";

    public static int checkWebLoginLicence(HttpServletRequest request, EASCallbackHandler easchb, String pkg) throws LicenseException, LoginException {
        Context ctx = easchb.getUserContext();
        LicenseUserInfo licenseUserInfo = EASWebLicenceHelper.createLicenseUserInfo(request, ctx);
        if (LICENSE_CHECK_PASS.equals((String)request.getSession().getAttribute(LICENSE_CHECK_KEY))) {
            return 1;
        }
        int result = LicenseSrvAgentFactory.getRemoteInstance().requestLicense(licenseUserInfo, pkg);
        if (result == 1) {
            request.getSession().setAttribute(LICENSE_USER, (Object)licenseUserInfo);
            request.getSession().setAttribute(LICENSE_CHECK_KEY, (Object)LICENSE_CHECK_PASS);
            return 1;
        }
        Locale local = null;
        if (ctx != null) {
            local = ctx.getLocale();
        }
        if (result == 4) {
            throw new LoginException(ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid", (Locale)local) + EASWebLicenceHelper.constructLicenseMessage(pkg, local));
        }
        if (result == 2) {
            throw new LoginException(ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS", (Locale)local) + EASWebLicenceHelper.constructLicenseMessage(pkg, local));
        }
        return result;
    }

    public static int checkWebLoginLicence(HttpServletRequest request, Context ctx, String pkg) throws LicenseException, LoginException {
        if (SSO_PKG.equals(pkg) && request.getParameter("EASAUTO") != null && request.getParameter("dataCenter") != null && request.getParameter("locale") != null) {
            return 1;
        }
        LicenseUserInfo licenseUserInfo = EASWebLicenceHelper.createLicenseUserInfo(request, ctx);
        if (LICENSE_CHECK_PASS.equals((String)request.getSession().getAttribute(LICENSE_CHECK_KEY))) {
            return 1;
        }
        int result = LicenseSrvAgentFactory.getRemoteInstance().requestLicenseOnInvalid(licenseUserInfo, pkg);
        if (result == 1) {
            request.getSession().setAttribute(LICENSE_USER, (Object)licenseUserInfo);
            request.getSession().setAttribute(LICENSE_CHECK_KEY, (Object)LICENSE_CHECK_PASS);
            return 1;
        }
        return result;
    }

    private static String constructLicenseMessage(String packageName, Locale local) throws LicenseException {
        if (packageName == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        buffer.append(ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ModuleName", (Locale)local));
        String moduleName = LicenseSrvAgentFactory.getRemoteInstance().getModuleByPackage(packageName);
        buffer.append(moduleName);
        return buffer.toString();
    }

    public static void releaseLicense(Context ctx, String pkg) throws LicenseException {
        UserInfo userinfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userinfo.getId() != null) {
            LicenseSrvAgentFactory.getRemoteInstance().releaseLicenseByUserIDAndModuleName(userinfo.getId().toString(), pkg);
        }
    }

    public static void releaseLicense(String sessionId, String pkg) throws LicenseException {
        LicenseSrvAgentFactory.getRemoteInstance().releaseLicense(sessionId, pkg);
    }

    public static LicenseUserInfo createLicenseUserInfo(HttpServletRequest request, Context ctx) {
        return EASWebLicenceHelper.createLicenseUserInfo(request.getRemoteAddr(), ctx);
    }

    public static LicenseUserInfo createLicenseUserInfo(String clientIP, Context ctx) {
        UserInfo userinfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        LicenseUserInfo user = null;
        try {
            Date loginTime = new Date(System.currentTimeMillis());
            user = new LicenseUserInfo();
            if (ctx != null) {
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                if (userInfo != null && userInfo.getId() != null) {
                    user.setUserID(userInfo.getId().toString());
                }
                if (userinfo.getId() != null) {
                    user.setUserID(userinfo.getId().toString());
                }
                user.setUserName(ctx.getUserName());
                user.setSessionID(ctx.getContextID());
                if (ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                    user.setUserCompany(ContextUtil.getCurrentCtrlUnit((Context)ctx).getName());
                }
                user.setUserLoginAis(ctx.getAIS());
            }
            user.setUserIP(clientIP);
            user.setUserLoginTime(loginTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            user = null;
        }
        return user;
    }

    public static long getValidDays(LicenseValidateInfo licenseValidateInfo) {
        String source = licenseValidateInfo.getExpireDate();
        String destin = licenseValidateInfo.getCurrentDate();
        if (StringUtils.isEmpty((String)source) && StringUtils.isEmpty((String)destin)) {
            return 0L;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            if (!StringUtils.isEmpty((String)source)) {
                c1.setTime(formatter.parse(source));
            }
            if (!StringUtils.isEmpty((String)destin)) {
                c2.setTime(formatter.parse(destin));
            }
            long validDays = (c1.getTimeInMillis() - c2.getTimeInMillis()) / 86400000L;
            if (new Date(c1.getTimeInMillis()).compareTo(new Date(c2.getTimeInMillis())) == 0) {
                validDays = 1L;
            }
            return validDays;
        }
        catch (ParseException e) {
            logger.error((Object)"parse license date error:", (Throwable)e);
            return 0L;
        }
    }

    public static long getSubscriptionValidDays(LicenseValidateInfo licenseValidateInfo) {
        String source = licenseValidateInfo.getSubscriptionDate();
        if (StringUtils.isEmpty((String)source) || "1970-01-01 00:00:01".equalsIgnoreCase(source)) {
            return 9999L;
        }
        String destin = licenseValidateInfo.getCurrentDate();
        if (StringUtils.isEmpty((String)source) && StringUtils.isEmpty((String)destin)) {
            return 0L;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            if (!StringUtils.isEmpty((String)source)) {
                c1.setTime(formatter.parse(source));
            }
            if (!StringUtils.isEmpty((String)destin)) {
                c2.setTime(formatter.parse(destin));
            }
            long validDays = (c1.getTimeInMillis() - c2.getTimeInMillis()) / 86400000L;
            if (new Date(c1.getTimeInMillis()).compareTo(new Date(c2.getTimeInMillis())) == 0) {
                validDays = 1L;
            }
            return validDays;
        }
        catch (ParseException e) {
            logger.error((Object)"parse license date error:", (Throwable)e);
            return 0L;
        }
    }
}

