/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.cache;

import com.kingdee.eas.portal.web.configuration.PortalConfig;
import com.kingdee.eas.portal.web.util.DateTool;
import com.kingdee.util.ConfigurationItem;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class SSOCacheConfig {
    public static String CACHECONFIG = "cacheConfig";
    private String cacheMime = ".js,.htc,.css,.gif,.jpeg,.jpg,.png,.xml,.gz,.html";
    private boolean gz = true;
    private String gzMime = ".js,.htc,.css,.xml,.html";
    private long maxAge = 31536000L;
    private String expires;
    private int exp_day = 365;
    private long curTime;
    private static SSOCacheConfig instance = new SSOCacheConfig();

    public static SSOCacheConfig getInstance() {
        return instance;
    }

    private SSOCacheConfig() {
        ConfigurationItem configItem = PortalConfig.getConfiguration().getConfigItem("cacheResource");
        if (configItem == null) {
            return;
        }
        String s1 = configItem.getProperty("cacheMime");
        if (s1 != null && !"".equals(s1)) {
            this.cacheMime = s1;
        }
        if ((s1 = configItem.getProperty("isGZ")) != null && !"true".equals(s1)) {
            this.gz = false;
        }
        if ((s1 = configItem.getProperty("gzMine")) != null && !"".equals(s1)) {
            this.gzMime = s1;
        }
        this.curTime = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.add(5, this.exp_day);
        this.expires = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", DateTool.LOCALE_US).format(cal.getTime()) + " GMT";
    }

    public String getExpires() {
        if (this.exp_day < 1) {
            return "" + this.exp_day;
        }
        if (this.expires == null || System.currentTimeMillis() - this.curTime > 3600000L) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.add(5, this.exp_day);
            this.expires = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", DateTool.LOCALE_US).format(cal.getTime()) + "  GMT";
        }
        return this.expires;
    }

    public String getCacheMime() {
        return this.cacheMime;
    }

    public void setCacheMime(String cacheMime) {
        this.cacheMime = cacheMime;
    }

    public String getGzMime() {
        return this.gzMime;
    }

    public void setGzMime(String gzMime) {
        this.gzMime = gzMime;
    }

    public boolean isGZ() {
        return this.gz;
    }

    public void setGZ(boolean isGZ) {
        this.gz = isGZ;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public boolean isCacheMime(String name) {
        if (name == null || this.cacheMime == null) {
            return false;
        }
        return this.cacheMime.indexOf(name) > -1;
    }

    public boolean isGZMime(String name) {
        if (!this.gz || name == null || this.gzMime == null) {
            return false;
        }
        return this.gzMime.indexOf(name) > -1;
    }

    public boolean isCache(String resource) {
        int index = resource.lastIndexOf(".");
        if (index < 0) {
            return false;
        }
        String ext = resource.substring(index);
        return this.isCacheMime(ext);
    }

    public boolean isGZ(String resource) {
        int index = resource.lastIndexOf(".gz");
        if (index < 0) {
            return false;
        }
        String ext = resource.substring(index);
        return this.isCacheMime(ext);
    }
}

