/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.validatecode;

import com.kingdee.eas.base.uiframe.globlelogin.GlobleLoginConfigFactory;
import com.kingdee.eas.cp.eip.sso.EASLoginException;
import com.kingdee.eas.cp.eip.sso.web.server.EASAuthException;
import com.kingdee.eas.portal.web.configuration.PortalConfig;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.ticket.TicketCreationException;

public class ValidateCodeParamUtil {
    private static final String VALIDATECODE_CONFIGITEM = "ValidateCodeParam";
    private static final String ISENABLEVALIDATECODE = "isEnableValidateCode";
    private static ConfigurationItem configItem = null;
    private static String[] authType = new String[]{"KingdeeCloud", "BaseDB", "BaseAD", "BaseLDAP"};

    private static ConfigurationItem getConfigItem() {
        if (configItem == null && (configItem = PortalConfig.getConfigurationItem((String)VALIDATECODE_CONFIGITEM)) == null) {
            configItem = ValidateCodeParamUtil.createValidateCodeParamConfig();
        }
        return configItem;
    }

    private static ConfigurationItem createValidateCodeParamConfig() {
        ConfigurationItem configItem = new ConfigurationItem(VALIDATECODE_CONFIGITEM);
        configItem.setProperty(ISENABLEVALIDATECODE, "false");
        XMLConfiguration config = PortalConfig.getConfiguration();
        config.addConfigItem(configItem);
        config.store();
        return configItem;
    }

    public static final boolean isEnableValidateCode() {
        String isEnableValidateCode = "false";
        isEnableValidateCode = ValidateCodeParamUtil.getConfigItem().getProperty(ISENABLEVALIDATECODE);
        return Boolean.valueOf(isEnableValidateCode);
    }

    public static final boolean isEnableValidateCode(HttpServletRequest request) {
        boolean isEnableValidateCode = false;
        int errorCount = -1;
        Properties properties = null;
        try {
            properties = GlobleLoginConfigFactory.getLocalInstance().getBizConfig();
            if (properties != null) {
                String authType = properties.getProperty("authType");
                if (!StringUtils.isEmpty((String)authType)) {
                    if ("1".equals(authType)) {
                        isEnableValidateCode = true;
                        String errNum = properties.getProperty("errNum");
                        if (!StringUtils.isEmpty((String)errNum)) {
                            errorCount = Integer.parseInt(errNum);
                        }
                    }
                } else {
                    isEnableValidateCode = ValidateCodeParamUtil.isEnableValidateCode();
                }
            } else {
                isEnableValidateCode = ValidateCodeParamUtil.isEnableValidateCode();
            }
            if (isEnableValidateCode) {
                if (errorCount < 0) {
                    return true;
                }
                int sessionErrorCount = 0;
                Integer count = (Integer)request.getSession().getAttribute("login_failed_count");
                if (count != null) {
                    sessionErrorCount = count;
                }
                return sessionErrorCount - errorCount >= 0;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return isEnableValidateCode;
        }
    }

    public static void checkValidateCode(HttpServletRequest request) throws TicketCreationException {
        if (!ValidateCodeParamUtil.isEnableValidateCode(null)) {
            return;
        }
        String validataCode = (String)request.getSession().getAttribute("easportalValidataCode");
        boolean flag = true;
        String userAuthPattern = request.getParameter("userAuthPattern");
        for (int i = 0; i < authType.length; ++i) {
            if (!authType[i].equals(userAuthPattern)) continue;
            flag = false;
            break;
        }
        if (StringUtils.isEmpty((String)validataCode) || flag || validataCode.equalsIgnoreCase(request.getParameter("validateCode"))) {
            if (request.getSession().getAttribute("validataCode") != null) {
                request.getSession().setAttribute("validataCode", null);
            }
        } else {
            try {
                throw new EASLoginException(EASLoginException.CHECKVALIDATECODEERR);
            }
            catch (EASLoginException e) {
                throw new TicketCreationException((Throwable)((Object)new EASAuthException(e.getMessage())));
            }
        }
    }
}

