/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponentBase;
import com.kingdee.bos.ctrl.analysis.bicomponent.ChartDataBuilder;
import com.kingdee.bos.ctrl.analysis.bicomponent.ChartDataBuilder2;
import com.kingdee.bos.ctrl.analysis.bicomponent.ChartDataConfig;
import com.kingdee.bos.ctrl.analysis.bicomponent.ChartEntityPosition;
import com.kingdee.bos.ctrl.analysis.bicomponent.ComponentConfig;
import com.kingdee.bos.ctrl.analysis.bicomponent.DefaultChartDataBuilder;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.Result;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.chart.data.IChartData;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.CategoryDataset;

public class ChartComponent
extends BIComponentBase {
    private static Logger logger = CommonLogger.getLogger(ChartComponent.class);
    private KDChart kdchart;
    private ChartDataBuilder2 chartDataBuilder;
    private boolean autoShowTitle = false;

    public ChartComponent(KDChart kdchart, ComponentConfig config) {
        super(config);
        if (kdchart == null) {
            throw new NullPointerException();
        }
        this.kdchart = kdchart;
        kdchart.setDataLimit(true);
        kdchart.setCommonDataFirstDimLimitNum(40);
        kdchart.setCommonDataSecondDimLimitNum(40);
        this.chartDataBuilder = new DefaultChartDataBuilder(this.olapModel);
    }

    public KDChart getKdchart() {
        return this.kdchart;
    }

    public void setAutoShowTitle(boolean flag) {
        this.autoShowTitle = flag;
    }

    @Override
    public void render() {
        IChartData chartData;
        if (this.kdchart == null) {
            return;
        }
        long t1 = System.currentTimeMillis();
        this.kdchart.clearChartDataCollection();
        Result result = null;
        try {
            result = this.olapModel.getResult();
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        if (result != null && (chartData = this.buildChartData(result)) != null) {
            this.kdchart.addChartData(chartData);
        }
        this.kdchart.setPieChartSectionLabelType(5);
        if (this.autoShowTitle) {
            StringBuilder sb = new StringBuilder();
            Hierarchy[] hies = null;
            if (null != result) {
                int i;
                hies = result.getRowAxis().getHierarchies();
                for (i = 0; i < hies.length; ++i) {
                    sb.append(hies[i].getCaption()).append(" * ");
                }
                hies = result.getColumnAxis().getHierarchies();
                for (i = 0; i < hies.length - 1; ++i) {
                    sb.append(hies[i].getCaption()).append(" * ");
                }
                sb.append(hies[hies.length - 1].getCaption());
            }
            this.kdchart.getChartTitle().setText(sb.toString());
        }
        this.kdchart.repaint();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ChartComponent render cost " + (System.currentTimeMillis() - t1) + "ms."));
        }
    }

    public void setChartDataBuilder(ChartDataBuilder2 cdb) {
        if (cdb == null) {
            throw new NullPointerException();
        }
        this.chartDataBuilder = cdb;
    }

    public ChartDataBuilder getChartDataBuilder() {
        return this.chartDataBuilder;
    }

    IChartData buildChartData(Result result) {
        ChartDataConfig cdc = new ChartDataConfig();
        cdc.nullPointSmooth = this.config.nullPointSmooth;
        return this.chartDataBuilder.buildChartData2(result, cdc);
    }

    @Override
    public JComponent getJComponent() {
        return this.kdchart;
    }

    class MyChartListener
    implements ChartMouseListener {
        MyChartListener() {
        }

        public void chartMouseClicked(ChartMouseEvent event) {
            if (event.getTrigger().getButton() == 3) {
                return;
            }
            ChartEntity entity = event.getEntity();
            if (entity != null) {
                JFreeChart freechart = event.getChart();
                Plot p = freechart.getPlot();
                CategoryDataset dataset = null;
                if (p instanceof CategoryPlot) {
                    CategoryPlot plot = (CategoryPlot)p;
                    dataset = plot.getDataset();
                } else if (p instanceof PiePlot) {
                    dataset = ((PiePlot)p).getMultiDataset();
                } else {
                    return;
                }
                if (entity instanceof LegendItemEntity) {
                    LegendItemEntity lientity = (LegendItemEntity)entity;
                    int index = lientity.getSeriesIndex();
                    Comparable c = dataset.getRowKey(index);
                    Position pos = null;
                    if (c instanceof ChartEntityPosition) {
                        pos = ((ChartEntityPosition)c).getPosition();
                    }
                    if (pos != null) {
                        System.out.println("" + pos);
                    }
                } else if (entity instanceof CategoryItemEntity) {
                    CategoryItemEntity cientity = (CategoryItemEntity)entity;
                    int cindex = cientity.getCategoryIndex();
                    int sindex = cientity.getSeries();
                    Comparable cc = dataset.getColumnKey(cindex);
                    Comparable sc = dataset.getRowKey(sindex);
                    Position groupPos = null;
                    Position serialPos = null;
                    if (cc instanceof ChartEntityPosition) {
                        groupPos = ((ChartEntityPosition)cc).getPosition();
                    }
                    if (sc instanceof ChartEntityPosition) {
                        serialPos = ((ChartEntityPosition)sc).getPosition();
                    }
                    if (groupPos != null && serialPos != null) {
                        System.out.println("" + groupPos + "," + serialPos);
                    }
                } else if (entity instanceof PieSectionEntity) {
                    PieSectionEntity psentity = (PieSectionEntity)entity;
                    Comparable gc = dataset.getColumnKey(psentity.getPieIndex());
                    Comparable sc = dataset.getRowKey(psentity.getSectionIndex());
                    Position groupPos = null;
                    Position serialPos = null;
                    if (gc instanceof ChartEntityPosition) {
                        groupPos = ((ChartEntityPosition)gc).getPosition();
                    }
                    if (sc instanceof ChartEntityPosition) {
                        serialPos = ((ChartEntityPosition)sc).getPosition();
                    }
                    if (groupPos != null && serialPos != null) {
                        System.out.println("" + groupPos + "," + serialPos);
                    }
                }
            }
        }

        public void chartMouseMoved(ChartMouseEvent event) {
            MouseEvent me = event.getTrigger();
            ChartEntity entity = event.getEntity();
            if (entity == null) {
                return;
            }
            if (me.getID() == 504) {
                System.out.println("enter " + entity.getToolTipText());
            } else if (me.getID() == 505) {
                System.out.println("exit " + entity.getToolTipText());
            }
        }
    }
}

