/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.bicomponent.ChartDataBuilder2;
import com.kingdee.bos.ctrl.analysis.bicomponent.ChartDataConfig;
import com.kingdee.bos.ctrl.analysis.bicomponent.ChartEntityPosition;
import com.kingdee.bos.ctrl.analysis.bicomponent.IChartDataVisibleHandler;
import com.kingdee.bos.ctrl.analysis.bicomponent.MultidimensionalModel;
import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.Cell;
import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.Result;
import com.kingdee.bos.ctrl.swing.chart.data.CommonChartData;
import com.kingdee.bos.ctrl.swing.chart.data.IChartData;
import com.kingdee.bos.ctrl.swing.chart.util.ChartDataUtil;
import com.kingdee.bos.ctrl.swing.chart.util.PointUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DefaultChartDataBuilder
implements ChartDataBuilder2 {
    private HashMap includeMembers = new HashMap();
    private HashMap excludeMembers = new HashMap();
    private List visibleList = new ArrayList(0);
    private OlapModel olapModel;
    private boolean reverse;
    private SplitSeriesGroups sss = null;
    private TopFilter topFilter = null;

    public DefaultChartDataBuilder(OlapModel olapModel) {
        this.olapModel = olapModel;
    }

    public void reset() {
        this.includeMembers.clear();
        this.excludeMembers.clear();
        this.visibleList.clear();
        this.reverse = false;
        this.sss = null;
        this.topFilter = null;
    }

    public void setReverse(boolean b) {
        this.reverse = b;
    }

    public void setSeriesGroups(String[] seriesDimensionName, String[] groupsDimensionName) {
        this.sss = new SplitSeriesGroups(seriesDimensionName, groupsDimensionName);
    }

    public void setTopFilter(int topCount, String[] seriesDimItems) {
        this.topFilter = new TopFilter(topCount, seriesDimItems);
    }

    public CommonChartData buildChartDataRebuildSeriesGroups(Result result) {
        Member[] ms;
        Position pos;
        int i;
        MultidimensionalModel mdm = new MultidimensionalModel();
        Axis topAxis = OlapModelUtil.getTopAxis(result);
        Axis leftAxis = OlapModelUtil.getLeftAxis(result);
        int leftsize = leftAxis.getPositions().size();
        int topsize = topAxis.getPositions().size();
        ArrayList<Member[]> listLeftMember = new ArrayList<Member[]>();
        ArrayList<Member[]> listTopMember = new ArrayList<Member[]>();
        ArrayList<Integer> indexLeft = new ArrayList<Integer>();
        ArrayList<Integer> indexTop = new ArrayList<Integer>();
        for (i = 0; i < leftsize; ++i) {
            pos = (Position)leftAxis.getPositions().get(i);
            ms = pos.getMembers();
            if (!this.isVisible(ms)) continue;
            indexLeft.add(new Integer(i));
            listLeftMember.add(ms);
        }
        for (i = 0; i < topsize; ++i) {
            pos = (Position)topAxis.getPositions().get(i);
            ms = pos.getMembers();
            if (!this.isVisible(ms)) continue;
            indexTop.add(new Integer(i));
            listTopMember.add(ms);
        }
        int serialsize = listTopMember.size();
        int groupsize = listLeftMember.size();
        if (groupsize == 0 || serialsize == 0) {
            return null;
        }
        for (int i2 = 0; i2 < serialsize; ++i2) {
            for (int j = 0; j < groupsize; ++j) {
                int jj;
                int ii = (Integer)indexTop.get(i2);
                Cell cell = result.getCell(ii, jj = ((Integer)indexLeft.get(j)).intValue());
                Object value = cell.getValue();
                double v = value instanceof Number ? ((Number)value).doubleValue() : 0.0;
                if (this.sss == null) continue;
                mdm.addCell((Member[])listLeftMember.get(j), (Member[])listTopMember.get(i2), v);
            }
        }
        return mdm.extractGroup(this.sss.series, this.sss.groups, this.reverse);
    }

    @Override
    public IChartData buildChartData(Result result) {
        CommonChartData ccd = this.doBuildChartData(result, new ChartDataConfig());
        if (this.topFilter != null) {
            ccd = MultidimensionalModel.sortBy(this.topFilter.topCount, this.topFilter.getDimFiltKey(), ccd);
        }
        return ccd;
    }

    @Override
    public IChartData buildChartData2(Result result, ChartDataConfig cdc) {
        CommonChartData ccd = this.doBuildChartData(result, cdc);
        if (this.topFilter != null) {
            ccd = MultidimensionalModel.sortBy(this.topFilter.topCount, this.topFilter.getDimFiltKey(), ccd);
        }
        return ccd;
    }

    public CommonChartData doBuildChartData(Result result, ChartDataConfig cdc) {
        Member[] ms;
        Position pos;
        int i;
        if (this.sss != null) {
            return this.buildChartDataRebuildSeriesGroups(result);
        }
        Axis topAxis = OlapModelUtil.getTopAxis(result);
        Axis leftAxis = OlapModelUtil.getLeftAxis(result);
        if (this.reverse) {
            Axis temp = topAxis;
            topAxis = leftAxis;
            leftAxis = temp;
        }
        int leftsize = leftAxis.getPositions().size();
        int topsize = topAxis.getPositions().size();
        ArrayList<ChartEntityPosition> listLeft = new ArrayList<ChartEntityPosition>();
        ArrayList<ChartEntityPosition> listTop = new ArrayList<ChartEntityPosition>();
        ArrayList<Integer> indexLeft = new ArrayList<Integer>();
        ArrayList<Integer> indexTop = new ArrayList<Integer>();
        for (i = 0; i < leftsize; ++i) {
            pos = (Position)leftAxis.getPositions().get(i);
            ms = pos.getMembers();
            if (!this.isVisible(ms)) continue;
            indexLeft.add(new Integer(i));
            listLeft.add(new ChartEntityPosition(pos));
        }
        for (i = 0; i < topsize; ++i) {
            pos = (Position)topAxis.getPositions().get(i);
            ms = pos.getMembers();
            if (!this.isVisible(ms)) continue;
            indexTop.add(new Integer(i));
            listTop.add(new ChartEntityPosition(pos));
        }
        int serialsize = listTop.size();
        int groupsize = listLeft.size();
        if (groupsize == 0 || serialsize == 0) {
            return null;
        }
        double[][] values = new double[serialsize][groupsize];
        ArrayList<Point> lstAdjust = new ArrayList<Point>();
        for (int i2 = 0; i2 < serialsize; ++i2) {
            for (int j = 0; j < groupsize; ++j) {
                double v;
                int ii = (Integer)indexTop.get(i2);
                int jj = (Integer)indexLeft.get(j);
                Cell cell = null;
                cell = this.reverse ? result.getCell(jj, ii) : result.getCell(ii, jj);
                Object value = cell.getValue();
                if (value instanceof Number) {
                    v = ((Number)value).doubleValue();
                } else if (value == null) {
                    if (cdc.nullPointSmooth) {
                        v = Double.NaN;
                        lstAdjust.add(new Point(i2, j));
                    } else {
                        v = 0.0;
                    }
                } else {
                    v = 0.0;
                }
                values[i2][j] = v;
            }
        }
        for (int ii = 0; ii < lstAdjust.size(); ++ii) {
            Point p = (Point)lstAdjust.get(ii);
            int r = (int)p.getX();
            int c = (int)p.getY();
            values[r][c] = PointUtil.CalSmoothPoint((double[][])values, (int)r, (int)c, (double)Double.NaN);
        }
        CommonChartData commonChartData = ChartDataUtil.createCommonChartData((Comparable[])listTop.toArray(new Comparable[0]), (Comparable[])listLeft.toArray(new Comparable[0]), (double[][])values);
        return commonChartData;
    }

    private boolean isVisible(Member[] ms) {
        if (this.excludeMembers.size() != 0 || this.includeMembers.size() != 0) {
            for (int i = 0; i < ms.length; ++i) {
                Member m = ms[i];
                Dimension dim = m.getDimension();
                ArrayList list = (ArrayList)this.excludeMembers.get(dim);
                if (list != null && list.contains(m)) {
                    return false;
                }
                list = (ArrayList)this.includeMembers.get(dim);
                if (list == null || list.contains(m)) continue;
                return false;
            }
        }
        return this.isVisibleFiltWithVisibleHandler(ms);
    }

    public void setShowMembers(String dimUniqueName, String[] memberUniqueNames) {
        Dimension dim = this.olapModel.lookupDimension(dimUniqueName);
        if (memberUniqueNames == null) {
            this.includeMembers.remove(dim);
        } else {
            this.excludeMembers.remove(dim);
            this.includeMembers.put(dim, OlapModelUtil.lookupMembers(this.olapModel, dim.getName(), memberUniqueNames));
        }
    }

    public void setNotShowMembers(String dimUniqueName, String[] memberUniqueNames) {
        Dimension dim = this.olapModel.lookupDimension(dimUniqueName);
        if (dim == null) {
            return;
        }
        if (memberUniqueNames == null) {
            this.excludeMembers.remove(dim);
        } else {
            this.includeMembers.remove(dim);
            this.excludeMembers.put(dim, OlapModelUtil.lookupMembers(this.olapModel, dim.getName(), memberUniqueNames));
        }
    }

    private boolean isVisibleFiltWithVisibleHandler(Member[] ms) {
        int n = this.visibleList.size();
        for (int i = 0; i < n; ++i) {
            if (((IChartDataVisibleHandler)this.visibleList.get(i)).isVisible(ms)) continue;
            return false;
        }
        return true;
    }

    public void addVisibleHandler(IChartDataVisibleHandler handler) {
        if (!this.visibleList.contains(handler)) {
            this.visibleList.add(handler);
        }
    }

    public void removeVisibleHandler(IChartDataVisibleHandler handler) {
        this.visibleList.remove(handler);
    }

    public void clearVisibleHandler() {
        this.visibleList.clear();
    }

    class TopFilter {
        int topCount;
        String[] seriesDimItems;

        TopFilter(int topCount, String[] seriesDimItems) {
            this.topCount = topCount;
            this.seriesDimItems = seriesDimItems;
        }

        String getDimFiltKey() {
            StringBuffer s = new StringBuffer();
            int n = this.seriesDimItems.length;
            for (int i = 0; i < n; ++i) {
                s.append(this.seriesDimItems[i]);
                if (i >= n - 1) continue;
                s.append(",");
            }
            return s.toString();
        }
    }

    class SplitSeriesGroups {
        String[] series;
        String[] groups;

        SplitSeriesGroups(String[] series, String[] groups) {
            this.series = series;
            this.groups = groups;
        }

        public String toString() {
            int i;
            StringBuffer s = new StringBuffer();
            s.append("Series:");
            int n = this.series.length;
            for (i = 0; i < n; ++i) {
                s.append(this.series[i]);
                if (i >= n - 1) continue;
                s.append(",");
            }
            s.append(" Group:");
            n = this.groups.length;
            for (i = 0; i < n; ++i) {
                s.append(this.groups[i]);
                if (i >= n - 1) continue;
                s.append(",");
            }
            return s.toString();
        }
    }
}

