/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.bicomponent.ComponentConfig;
import com.kingdee.bos.ctrl.analysis.bicomponent.MemberCellItem;
import com.kingdee.bos.ctrl.analysis.olap.DrillExpandMember;
import com.kingdee.bos.ctrl.analysis.olap.DrillExpandPosition;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;

public class ExpandHelper {
    ComponentConfig config;

    public ExpandHelper(ComponentConfig config) {
        this.config = config;
    }

    public boolean canExpand(OlapModel olapModel, Position position, Member member) {
        if (this.config.expandMode == 0) {
            DrillExpandMember extension = (DrillExpandMember)olapModel.getExtension("drillExpandMember");
            return extension.canExpand(member);
        }
        DrillExpandPosition extension = (DrillExpandPosition)olapModel.getExtension("drillExpandPosition");
        return extension.canExpand(position, member);
    }

    public boolean canCollapse(OlapModel olapModel, Position position, Member member) {
        if (this.config.expandMode == 0) {
            DrillExpandMember extension = (DrillExpandMember)olapModel.getExtension("drillExpandMember");
            return extension.canCollapse(member);
        }
        DrillExpandPosition extension = (DrillExpandPosition)olapModel.getExtension("drillExpandPosition");
        return extension.canCollapse(position, member);
    }

    public boolean canExpand(MemberCellItem mci) {
        if (mci.isVirtual) {
            return false;
        }
        return this.canExpand(mci.model, mci.position, mci.getMember());
    }

    public boolean canCollapse(MemberCellItem mci) {
        if (mci.isVirtual || mci.member == null) {
            return false;
        }
        return this.canCollapse(mci.model, mci.position, mci.getMember());
    }
}

