/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponentResource;
import com.kingdee.bos.ctrl.analysis.bicomponent.HierarchyCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.MemberSelectListener;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.MemberTree;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeTreeUI;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.NonIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class SliceMemberSelector
extends KDDialog {
    ArrayList listeners = new ArrayList();
    KDPanel topPanel = new KDPanel();
    KDLabel label = new KDLabel();
    KDTree tree;
    Hierarchy hie;
    OlapModel model;
    MemberTree memberTree;
    DefaultKingdeeTreeNode rootNode;
    TreeSelectionListener listener = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
            Object o = node.getUserObject();
            if (o instanceof Member) {
                SliceMemberSelector.this.fireSelectChanged((Member)o);
            }
        }
    };

    public SliceMemberSelector(OlapModel model) {
        this.model = model;
        this.initUI();
    }

    public SliceMemberSelector(Frame owner, OlapModel model) {
        super(owner);
        this.model = model;
        this.initUI();
    }

    public SliceMemberSelector(Dialog owner, OlapModel model) {
        super(owner);
        this.model = model;
        this.initUI();
    }

    private void initUI() {
        this.memberTree = (MemberTree)this.model.getExtension("memberTree");
        this.setSize(200, 250);
        this.setTitle(BIComponentResource.getString(BIComponentResource.class, (String)"SlicerMemberSelector"));
        this.rootNode = new DefaultKingdeeTreeNode((Object)"root");
        this.tree = new KDTree((ITreeNode)this.rootNode);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setShowCheckBox(false);
        this.topPanel.add((Component)this.label);
        JScrollPane sp = new JScrollPane((Component)this.tree);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.topPanel, "North");
        this.getContentPane().add((Component)sp, "Center");
        if (this.getOwner() != null) {
            Window owner = this.getOwner();
            int x = owner.getX() + owner.getWidth() / 2;
            int y = owner.getY() + owner.getHeight() / 2;
            this.setLocation(x, y);
        }
        this.tree.addTreeSelectionListener(this.listener);
        ((DefaultTreeModel)this.tree.getModel()).setAsksAllowsChildren(true);
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (treeNode.getChildCount() == 0) {
                    SliceMemberSelector.this.expandNode(treeNode);
                }
            }
        });
    }

    public void show(HierarchyCellItem hci, boolean model) {
        this.setHierarchyCellInfo(hci);
        super.setModal(model);
        super.show();
    }

    public Hierarchy getHierarchy() {
        return this.hie;
    }

    public void setHierarchyCellInfo(HierarchyCellItem hci) {
        this.tree.removeTreeSelectionListener(this.listener);
        this.hie = hci.getHierarchy();
        this.label.setText(this.hie.getLabel());
        this.tree.removeAllChildrenFromParent((MutableTreeNode)this.rootNode);
        this.makeTree(this.rootNode, this.memberTree.getRootMembers(this.hie));
        ((KingdeeTreeUI)this.tree.getUI()).resetSize();
        this.tree.expandPath(new TreePath(this.rootNode.getPath()));
        this.select(this.rootNode, hci.getSliceMember());
        this.tree.addTreeSelectionListener(this.listener);
    }

    private void makeTree(DefaultKingdeeTreeNode node, Member[] ms) {
        for (int i = 0; i < ms.length; ++i) {
            DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
            child.setCustomIcon((Icon)NonIcon.getInstance());
            child.setText(ms[i].getLabel());
            child.setUserObject((Object)ms[i]);
            this.tree.addNodeInto((MutableTreeNode)child, (MutableTreeNode)node);
            child.setAllowsChildren(this.memberTree.hasChildren(ms[i]));
        }
    }

    private void expandNode(DefaultKingdeeTreeNode node) {
        Member member = (Member)node.getUserObject();
        if (member != null && this.memberTree.hasChildren(member)) {
            this.makeTree(node, this.memberTree.getChildren(member));
        }
    }

    private boolean select(DefaultKingdeeTreeNode node, Member member) {
        Enumeration enum1 = node.children();
        while (enum1.hasMoreElements()) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)enum1.nextElement();
            if (member.equals(child.getUserObject())) {
                this.tree.setSelectionPath(new TreePath(child.getPath()));
                return true;
            }
            if (!this.select(child, member)) continue;
            return true;
        }
        return false;
    }

    public void addSelectListener(MemberSelectListener l) {
        this.listeners.add(l);
    }

    public void removeSelectListener(MemberSelectListener l) {
        this.listeners.remove(l);
    }

    private void fireSelectChanged(Member selected) {
        for (int i = 0; i < this.listeners.size(); ++i) {
        }
    }
}

