/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent.style;

import com.kingdee.bos.ctrl.analysis.bicomponent.style.ExecuteContext;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.Expr;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.ExprBase;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.StyleException;
import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.MDXElement;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.Property;
import java.util.Arrays;
import java.util.HashSet;

public class FunCall
extends ExprBase {
    public static final int FUNCTION = 0;
    public static final int METHOD = 1;
    public static final int PROPERTY = 2;
    private String name;
    private Expr[] params;
    private int type;
    private static HashSet nameSet = new HashSet();

    FunCall(String name, Expr[] params) {
        this.name = name;
        this.params = params;
        this.type = 0;
    }

    FunCall(String name, Expr[] params, int type) {
        this.name = name;
        this.params = params;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Expr[] getParams() {
        return this.params;
    }

    public static boolean isFunCall(String name) {
        return nameSet.contains(name.toUpperCase());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.type) {
            case 0: {
                sb.append(this.name).append("(");
                for (int i = 0; i < this.params.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(this.params[i].toString());
                }
                sb.append(")");
                break;
            }
            case 1: {
                sb.append(this.params[0].toString()).append(".").append(this.name).append("(");
                for (int i = 1; i < this.params.length; ++i) {
                    if (i > 1) {
                        sb.append(",");
                    }
                    sb.append(this.params[i].toString());
                }
                sb.append(")");
                break;
            }
            case 2: {
                sb.append(this.params[0].toString()).append(".").append(this.name);
            }
        }
        return sb.toString();
    }

    private Object currentObject(ExecuteContext context, Expr expr) {
        Object o = expr.execute(context);
        if (o instanceof Dimension) {
            Member[] members = context.getMembers();
            for (int i = 0; i < members.length; ++i) {
                if (!members[i].getDimension().equals(o)) continue;
                return members[i];
            }
        }
        return o;
    }

    @Override
    public Object execute(ExecuteContext context) {
        if (this.name.equalsIgnoreCase("NAME")) {
            Object o = this.params[0].execute(context);
            if (o instanceof MDXElement) {
                return ((MDXElement)o).getName();
            }
            throw new StyleException("\u65e0\u6cd5\u6c42\u503c\uff1a" + this.toString());
        }
        if (this.name.equalsIgnoreCase("CAPTION")) {
            Object o = this.params[0].execute(context);
            if (o instanceof MDXElement) {
                return ((MDXElement)o).getCaption();
            }
            throw new StyleException("\u65e0\u6cd5\u6c42\u503c\uff1a" + this.toString());
        }
        if (this.name.equalsIgnoreCase("PARENT")) {
            try {
                Member m = (Member)this.currentObject(context, this.params[0]);
                return m.getParent();
            }
            catch (OlapException e) {
                throw new StyleException("\u6c42\u503c\u51fa\u9519" + this.toString(), e);
            }
        }
        if (this.name.equalsIgnoreCase("CURRENTMEMBER")) {
            return this.currentObject(context, this.params[0]);
        }
        if (this.name.equalsIgnoreCase("VALUE")) {
            HashSet<Member> s = new HashSet<Member>();
            s.addAll(Arrays.asList(context.getMembers()));
            if (s.contains(this.currentObject(context, this.params[0]))) {
                return context.getValue();
            }
            return null;
        }
        if (this.name.equalsIgnoreCase("PROPERTIES")) {
            Object o2;
            Object o1 = this.currentObject(context, this.params[0]);
            Property prop = ((Member)o1).getProperty((String)(o2 = this.currentObject(context, this.params[1])));
            if (prop == null) {
                throw new StyleException("\u672a\u627e\u5230\u5c5e\u6027\uff1a" + this.toString());
            }
            return prop.getValue();
        }
        throw new StyleException("\u65e0\u6cd5\u8bc6\u522b\u7684\u51fd\u6570\uff1a" + this.name);
    }

    static {
        String[] names = new String[]{"NAME", "CAPTION", "PROPERTIES", "PARENT", "CURRENTMEMBER", "VALUE"};
        for (int i = 0; i < names.length; ++i) {
            nameSet.add(names[i]);
        }
    }
}

