/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent.style;

import com.kingdee.bos.ctrl.analysis.bicomponent.style.ExecuteContext;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.Expr;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.StyleException;

public abstract class Operator {
    public static final Operator AND = new Operator("and"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left instanceof Boolean && right instanceof Boolean) {
                return (Boolean)left != false && (Boolean)right != false;
            }
            throw new StyleException("\u6267\u884c\u51fa\u9519,and\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u903b\u8f91\u5bf9\u8c61");
        }
    };
    public static final Operator OR = new Operator("or"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left instanceof Boolean && right instanceof Boolean) {
                return (Boolean)left != false || (Boolean)right != false;
            }
            throw new StyleException("\u6267\u884c\u51fa\u9519,or\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u903b\u8f91\u5bf9\u8c61");
        }
    };
    public static final Operator XOR = new Operator("xor"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left instanceof Boolean && right instanceof Boolean) {
                return ((Boolean)left).booleanValue() != ((Boolean)right).booleanValue();
            }
            throw new StyleException("\u6267\u884c\u51fa\u9519,xor\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u903b\u8f91\u5bf9\u8c61");
        }
    };
    public static final Operator NOT = new Operator("not"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object o = params[0].execute(context);
            if (o instanceof Boolean) {
                return (Boolean)o == false;
            }
            throw new StyleException("\u6267\u884c\u51fa\u9519,not\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u903b\u8f91\u5bf9\u8c61");
        }
    };
    public static final Operator PLUS = new Operator("+"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return null;
            }
            if (left == null) {
                left = new Integer(0);
            }
            if (right == null) {
                right = new Integer(0);
            }
            if (left instanceof Number && right instanceof Number) {
                if (left instanceof Double || right instanceof Double) {
                    return new Double(((Number)left).doubleValue() + ((Number)right).doubleValue());
                }
                return new Integer(((Number)left).intValue() + ((Number)right).intValue());
            }
            throw new StyleException("\u6267\u884c\u51fa\u9519,+\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator MINUS = new Operator("-"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return null;
            }
            if (left == null) {
                left = new Integer(0);
            }
            if (right == null) {
                right = new Integer(0);
            }
            if (left instanceof Number && right instanceof Number) {
                if (left instanceof Double || right instanceof Double) {
                    return new Double(((Number)left).doubleValue() - ((Number)right).doubleValue());
                }
                return new Integer(((Number)left).intValue() - ((Number)right).intValue());
            }
            throw new StyleException("\u6267\u884c\u51fa\u9519,-\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator TIMES = new Operator("*"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return null;
            }
            if (left == null) {
                left = new Integer(0);
            }
            if (right == null) {
                right = new Integer(0);
            }
            if (left instanceof Number && right instanceof Number) {
                if (left instanceof Double || right instanceof Double) {
                    return new Double(((Number)left).doubleValue() * ((Number)right).doubleValue());
                }
                return new Integer(((Number)left).intValue() * ((Number)right).intValue());
            }
            throw new StyleException("\u6267\u884c\u51fa\u9519,*\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator DIVIDE = new Operator("/"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return null;
            }
            if (left == null) {
                left = new Integer(0);
            }
            if (right == null) {
                right = new Integer(0);
            }
            if (left instanceof Number && right instanceof Number) {
                if (((Number)right).doubleValue() == 0.0) {
                    return null;
                }
                if (left instanceof Double || right instanceof Double) {
                    return new Double(((Number)left).doubleValue() / ((Number)right).doubleValue());
                }
                return new Integer(((Number)left).intValue() / ((Number)right).intValue());
            }
            throw new StyleException("\u6267\u884c\u51fa\u9519,/\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator UMINUS = new Operator("-"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object right = params[1].execute(context);
            if (right == null) {
                return null;
            }
            if (right instanceof Number) {
                if (right instanceof Double) {
                    return new Double(-((Number)right).doubleValue());
                }
                return new Integer(-((Number)right).intValue());
            }
            throw new StyleException("\u6267\u884c\u51fa\u9519,-\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator EQ = new Operator("="){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.TRUE;
            }
            if (left == null || right == null) {
                return Boolean.FALSE;
            }
            if (left instanceof Number && right instanceof Number) {
                return ((Number)left).doubleValue() == ((Number)right).doubleValue();
            }
            if (left instanceof String && right instanceof String) {
                return ((String)left).equalsIgnoreCase((String)right);
            }
            if (left == right) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    };
    public static final Operator GT = new Operator(">"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.FALSE;
            }
            if (left == null) {
                return Boolean.FALSE;
            }
            if (right == null) {
                return Boolean.TRUE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new Boolean(((Number)left).doubleValue() > ((Number)right).doubleValue());
            }
            throw new StyleException("\u6267\u884c\u51fa\u9519,>\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator GE = new Operator(">="){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.TRUE;
            }
            if (left == null) {
                return Boolean.FALSE;
            }
            if (right == null) {
                return Boolean.TRUE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new Boolean(((Number)left).doubleValue() >= ((Number)right).doubleValue());
            }
            throw new StyleException("\u6267\u884c\u51fa\u9519,>=\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator LT = new Operator("<"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.FALSE;
            }
            if (left == null) {
                return Boolean.TRUE;
            }
            if (right == null) {
                return Boolean.FALSE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new Boolean(((Number)left).doubleValue() < ((Number)right).doubleValue());
            }
            throw new StyleException("\u6267\u884c\u51fa\u9519,<\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator LE = new Operator("<="){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.TRUE;
            }
            if (left == null) {
                return Boolean.TRUE;
            }
            if (right == null) {
                return Boolean.FALSE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new Boolean(((Number)left).doubleValue() <= ((Number)right).doubleValue());
            }
            throw new StyleException("\u6267\u884c\u51fa\u9519,<=\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator NE = new Operator("<>"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.FALSE;
            }
            if (left == null) {
                return Boolean.TRUE;
            }
            if (right == null) {
                return Boolean.TRUE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new Boolean(((Number)left).doubleValue() != ((Number)right).doubleValue());
            }
            throw new StyleException("\u6267\u884c\u51fa\u9519,<\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator CONCAT = new Operator("||"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return null;
            }
            if (left == null && right instanceof String) {
                return right;
            }
            if (right == null && left instanceof String) {
                return left;
            }
            if (left instanceof String && right instanceof String) {
                return (String)left + (String)right;
            }
            throw new StyleException("\u6267\u884c\u51fa\u9519,||\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u5b57\u7b26\u4e32\u5bf9\u8c61");
        }
    };
    private String name;

    private Operator(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public abstract Object execute(ExecuteContext var1, Expr[] var2);
}

