/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.common.dbcenter.service;

import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModelUtil;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.pool.DBPoolFactory;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.pool.IDBPool;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class DBPoolManager {
    private static final Logger log = CommonLogger.getLogger(DBPoolManager.class);
    private static final Map poolsRegister = new Hashtable();

    public static synchronized Connection getConnection(Connection con, String dbCenterId) throws DBCenterException {
        if (poolsRegister.get(dbCenterId) != null) {
            return DBPoolManager.getConnection(dbCenterId);
        }
        DBCenterModel model = DBCenterModelUtil.loadModel(con, dbCenterId);
        if (model == null || model.getDbCenterId() == null) {
            throw new DBCenterException("id\u4e3a" + dbCenterId + "\u7684\u6570\u636e\u4e2d\u5fc3\u4e0d\u5b58\u5728\u6216\u8005\u6ca1\u6709\u542f\u7528\uff0c\u8bf7\u5230\u6570\u636e\u4e2d\u5fc3\u7ba1\u7406\u68c0\u67e5\u5b9a\u4e49\u4fe1\u606f\uff01");
        }
        return DBPoolManager.getConnection(model);
    }

    public static synchronized Connection getConnection(DBCenterModel model) throws DBCenterException {
        IDBPool pool = DBPoolManager.getPool(model);
        return pool.getConnection();
    }

    public static synchronized Connection getConnection(String dbCenterId) throws DBCenterException {
        IDBPool pool = DBPoolManager.getPool(dbCenterId);
        if (pool == null) {
            throw new DBCenterException("id\u4e3a" + dbCenterId + "\u7684\u6570\u636e\u4e2d\u5fc3\u8fd8\u6ca1\u6709\u6ce8\u518c\uff0c\u8bf7\u7528\u5176\u4ed6getConnection()\u65b9\u6cd5\u83b7\u53d6\u8fde\u63a5\uff01");
        }
        pool.printPoolStatus();
        return pool.getConnection();
    }

    public static synchronized void updatePool(String dbCenterId) throws DBCenterException {
        if (poolsRegister.get(dbCenterId) == null) {
            return;
        }
        IDBPool pool = (IDBPool)poolsRegister.get(dbCenterId);
        pool.updatePool(dbCenterId, new DBCenterModel());
    }

    public static synchronized void shutdownPool(String dbCenterId) throws DBCenterException {
        if (poolsRegister.get(dbCenterId) == null) {
            return;
        }
        IDBPool pool = (IDBPool)poolsRegister.get(dbCenterId);
        pool.shutdownPool();
        poolsRegister.remove(dbCenterId);
    }

    public static synchronized void printPoolsStates() throws DBCenterException {
        for (Map.Entry entry : poolsRegister.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            log.info((Object)("id\u4e3a" + key + "\u7684\u8fde\u63a5\u6c60\u5df2\u7ecf\u6ce8\u518c\u5230poolsRegister\uff0c\u53ef\u4ee5\u6839\u636eid\u83b7\u53d6\u8fde\u63a5\uff01"));
            ((IDBPool)value).printPoolStatus();
        }
    }

    private static synchronized IDBPool getPool(DBCenterModel model) throws DBCenterException {
        String dbCenterId = model.getDbCenterId();
        if (poolsRegister.get(dbCenterId) == null) {
            IDBPool pool = DBPoolFactory.createPoolInstance(model);
            poolsRegister.put(dbCenterId, pool);
        }
        ((IDBPool)poolsRegister.get(dbCenterId)).printPoolStatus();
        return (IDBPool)poolsRegister.get(dbCenterId);
    }

    private static synchronized IDBPool getPool(String dbCenterId) throws DBCenterException {
        return (IDBPool)poolsRegister.get(dbCenterId);
    }
}

