/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.cubemodel.designer;

import com.kingdee.bos.ctrl.analysis.AnalysisException;
import com.kingdee.bos.ctrl.analysis.cubemodel.CubeModelResource;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.CubeModelEditor;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.model.Table;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Cube;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Dimension;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Join;
import com.kingdee.bos.ctrl.common.ui.joineditor.JoinPanel;
import com.kingdee.bos.ctrl.common.ui.joineditor.ModelField;
import com.kingdee.bos.ctrl.common.ui.joineditor.ModelLine;
import com.kingdee.bos.ctrl.common.ui.joineditor.ModelTable;
import com.kingdee.bos.ctrl.common.ui.joineditor.SelectionEvent;
import com.kingdee.bos.ctrl.common.ui.joineditor.SelectionListener;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

class DiagramHelper {
    private final CubeModelEditor editor;
    private HashMap mapCubeToJoinPanel = new HashMap(2);
    private HashMap mapCubeToMapTables = new HashMap(2);
    private HashMap mapCubeToMapLines = new HashMap(2);
    private CubeModel_Cube currentCube;
    private JoinPanel currentJoinPanel;
    private KDPanel emptyPanel = new KDPanel((LayoutManager)new BorderLayout());
    private JComponent container;

    public DiagramHelper(CubeModelEditor editor, JComponent container) {
        this.container = container;
        this.editor = editor;
        container.setBorder(BorderFactory.createLoweredBevelBorder());
        container.setLayout(new BorderLayout());
        this.emptyPanel.setBackground(Color.WHITE);
        this.emptyPanel.add((Component)new KDLabel(CubeModelResource.getString(CubeModelResource.class, (String)"SelectNode")), (Object)"North");
    }

    public void autoLayout() {
        this.autoLayout(this.currentCube);
    }

    public void autoLayout(CubeModel_Cube cube) {
        JoinPanel jp = this.getJoinPanel(cube);
        HashMap mapTables = this.getMapTables(cube);
        int jwidth = jp.getWidth();
        int jheight = jp.getHeight();
        ModelTable factTable = (ModelTable)mapTables.get(null);
        int ftwidth = factTable.getUi().getWidth();
        int ftheight = factTable.getUi().getHeight();
        Rectangle rect = new Rectangle((jwidth - ftwidth) / 2, (jheight - ftheight) / 2, ftwidth, ftheight);
        jp.moveTable(factTable, rect);
        int index = 0;
        for (ModelTable modelTable : mapTables.values()) {
            if (modelTable == factTable) continue;
            int twidth = modelTable.getUi().getWidth();
            int theight = modelTable.getUi().getHeight();
            Point point = this.getPreferPoint(jwidth, jheight, twidth, theight, index);
            rect = new Rectangle(point.x, point.y, twidth, theight);
            jp.moveTable(modelTable, rect);
            if (++index <= 7) continue;
            break;
        }
        jp.validate();
    }

    private Point getPreferPoint(int jwidth, int jheight, int twidth, int theight, int index) {
        if (index > 7) {
            throw new IllegalArgumentException();
        }
        int x = 0;
        int y = 0;
        int margin = 25;
        if (index == 0) {
            x = margin;
            y = margin;
        } else if (index == 1) {
            x = jwidth - margin - twidth;
            y = margin;
        } else if (index == 2) {
            x = margin;
            y = jheight - margin - theight;
        } else if (index == 3) {
            x = jwidth - margin - twidth;
            y = jheight - margin - theight;
        } else if (index == 4) {
            x = margin;
            y = (jheight - theight) / 2;
        } else if (index == 5) {
            x = jwidth - margin - twidth;
            y = (jheight - theight) / 2;
        } else if (index == 6) {
            x = (jwidth - twidth) / 2;
            y = margin;
        } else if (index == 7) {
            x = (jwidth - twidth) / 2;
            y = jheight - margin - theight;
        }
        return new Point(x, y);
    }

    public void clear() {
        this.mapCubeToJoinPanel.clear();
        this.mapCubeToMapTables.clear();
        this.mapCubeToMapLines.clear();
        this.showEmpty();
    }

    public KDPanel getEmptyPanel() {
        return this.emptyPanel;
    }

    public void showEmpty() {
        this.currentJoinPanel = null;
        this.currentCube = null;
        this.container.removeAll();
        this.container.add((Component)this.emptyPanel);
        this.container.validate();
        this.container.repaint();
    }

    public void showJoinPanelForCube(CubeModel_Cube cube) {
        JoinPanel jp = (JoinPanel)this.mapCubeToJoinPanel.get(cube);
        if (jp == null) {
            return;
        }
        this.currentJoinPanel = jp;
        this.currentCube = cube;
        this.container.removeAll();
        this.container.add((Component)jp);
        this.container.validate();
        this.container.setVisible(true);
        this.autoLayout(cube);
        this.container.repaint();
    }

    public void addJoinPanelForCube(CubeModel_Cube cube, Table factTable) {
        JoinPanel jp = new JoinPanel();
        jp.setBackground(Color.WHITE);
        jp.setOpaque(true);
        jp.setDrawLineArrow(false);
        jp.setDrawLineIndex(false);
        jp.setShowPopupMenu(false);
        jp.addSelectionListener(new SelectionListener(){

            public void tableSelected(SelectionEvent evt) {
            }

            public void fieldSelected(SelectionEvent evt) {
            }

            public void lineSelected(SelectionEvent evt) {
                DiagramHelper.this.setRelativeLineSelected((ModelLine)evt.getSource(), evt.getSelectionType());
            }
        });
        jp.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                DiagramHelper.this.autoLayout();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.mapCubeToJoinPanel.put(cube, jp);
        HashMap<Object, ModelTable> mapTables = new HashMap<Object, ModelTable>();
        this.mapCubeToMapTables.put(cube, mapTables);
        HashMap mapLines = new HashMap();
        this.mapCubeToMapLines.put(cube, mapLines);
        ModelTable factModelTable = this.newModelTable(factTable);
        mapTables.put(null, factModelTable);
        jp.addTable(factModelTable);
        jp.validate();
        this.showJoinPanelForCube(cube);
    }

    public void addJoinPanelForCube(CubeModel_Cube cube) throws AnalysisException {
        String factTableName = cube.getFact().getTableRef().getName();
        Table factTable = this.editor.dataProvider.queryTableModel(factTableName);
        this.addJoinPanelForCube(cube, factTable);
    }

    public void addDimensionTableForCube(CubeModel_Cube cube, CubeModel_Dimension dimension) throws AnalysisException {
        String tableName = dimension.getTableRefs()[0].getName();
        Table table = this.editor.dataProvider.queryTableModel(tableName);
        this.addDimensionTableForCube(cube, dimension, table);
    }

    public void addDimensionTableForCube(CubeModel_Cube cube, CubeModel_Dimension dimension, Table table) {
        JoinPanel jp = this.getJoinPanel(cube);
        HashMap mapTables = this.getMapTables(cube);
        HashMap mapLines = this.getMapLines(cube);
        ModelTable modelTable = this.newModelTable(table);
        modelTable.setId(modelTable.getId() + "(" + dimension.getName() + ")");
        jp.addTable(modelTable);
        mapTables.put(dimension, modelTable);
        if (dimension.getFactJoinRef() != null) {
            CubeModel_Join join = this.editor.findJoin(cube, dimension.getFactJoinRef().getName());
            ModelLine line = new ModelLine();
            ModelTable left = modelTable;
            ModelTable right = (ModelTable)mapTables.get(null);
            ModelField leftField = left.findModelField(join.getLeftColumn());
            ModelField rightField = right.findModelField(join.getRightColumn());
            line.setFromTable(left);
            line.setToTable(right);
            line.setFromField(leftField);
            line.setToField(rightField);
            line.setId(join.getName());
            mapLines.put(modelTable, line);
            jp.addLine(line);
        }
        this.autoLayout(cube);
        jp.validate();
    }

    public void removeDimensionForCube(CubeModel_Cube cube, CubeModel_Dimension dimension) {
        JoinPanel jp = this.getJoinPanel(cube);
        HashMap mapTables = this.getMapTables(cube);
        HashMap mapLines = this.getMapLines(cube);
        ModelTable modelTable = (ModelTable)mapTables.remove(dimension);
        ModelLine line = (ModelLine)mapLines.remove(modelTable);
        jp.removeTable(modelTable);
        jp.removeLine(line);
        jp.validate();
    }

    public void removeCube(CubeModel_Cube cube) {
        this.mapCubeToJoinPanel.remove(cube);
        this.mapCubeToMapTables.remove(cube);
        this.mapCubeToMapTables.remove(cube);
        this.showEmpty();
    }

    public void setRelativeLineSelected(ModelLine line, int selectionType) {
        ModelLine[] mls = this.findRelativeLine(line);
        if (mls != null & mls.length > 0) {
            this.currentJoinPanel.selectedRelativeLine(mls, selectionType);
        }
    }

    private ModelLine[] findRelativeLine(ModelLine line) {
        ModelLine[] mls = null;
        ArrayList<ModelLine> list = new ArrayList<ModelLine>(2);
        CubeModel_Cube cube = this.currentCube;
        HashMap mapLines = this.getMapLines(cube);
        for (ModelLine ml : mapLines.values()) {
            if (ml == line || !ml.getId().equals(line.getId())) continue;
            list.add(ml);
        }
        mls = new ModelLine[list.size()];
        list.toArray(mls);
        return mls;
    }

    public JoinPanel getJoinPanel(CubeModel_Cube cube) {
        return (JoinPanel)this.mapCubeToJoinPanel.get(cube);
    }

    private HashMap getMapTables(CubeModel_Cube cube) {
        return (HashMap)this.mapCubeToMapTables.get(cube);
    }

    private HashMap getMapLines(CubeModel_Cube cube) {
        return (HashMap)this.mapCubeToMapLines.get(cube);
    }

    private ModelTable newModelTable(Table table) {
        ModelTable mt = new ModelTable();
        mt.setId(table.getName());
        mt.setAlias(table.getAlias());
        ArrayList<ModelField> al = new ArrayList<ModelField>();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            ModelField mf = new ModelField();
            mf.setId(table.getColumn(i).getName());
            mf.setType(table.getColumn(i).getDataType());
            mf.setAlias(table.getColumn(i).getAlias());
            al.add(mf);
        }
        mt.setFields(al);
        return mt;
    }

    public void setSelectNull(CubeModel_Cube cube) {
        JoinPanel p = this.getJoinPanel(cube);
        if (p != null) {
            p.setSelectedTable(null);
        }
    }

    public void setSelectTable(CubeModel_Cube cube, CubeModel_Dimension dimension) {
        JoinPanel p = this.getJoinPanel(cube);
        if (p != null) {
            HashMap mapTables = this.getMapTables(cube);
            if (dimension != null && dimension.getFactJoinRef() == null) {
                dimension = null;
            }
            ModelTable mt = (ModelTable)mapTables.get(dimension);
            p.setSelectedTable(mt);
        }
    }

    public void setSelectDimension(CubeModel_Cube cube, CubeModel_Dimension dimension) {
        if (dimension == null) {
            return;
        }
        this.setSelectTable(cube, dimension);
    }

    public void setSelectLine(CubeModel_Cube cube, CubeModel_Dimension dimension) {
        JoinPanel p = this.getJoinPanel(cube);
        if (p != null) {
            HashMap mapTables = this.getMapTables(cube);
            HashMap mapLines = this.getMapLines(cube);
            ModelLine ml = (ModelLine)mapLines.get(mapTables.get(dimension));
            p.setSelectedLine(ml);
            this.setRelativeLineSelected(ml, SelectionEvent.SELECTED);
        }
    }

    public void setSelectField(CubeModel_Cube cube, CubeModel_Dimension dimension, String fieldId) {
        JoinPanel p = this.getJoinPanel(cube);
        if (p != null) {
            ModelTable mt;
            ModelField mf;
            HashMap mapTables = this.getMapTables(cube);
            if (dimension != null && dimension.getFactJoinRef() == null) {
                dimension = null;
            }
            if ((mf = (mt = (ModelTable)mapTables.get(dimension)).findModelField(fieldId)) != null) {
                p.setSelectedField(mt, mf);
            }
        }
    }
}

