/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.model;

import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.model.Column;
import java.util.HashMap;

public class Table {
    String type;
    String name;
    String alias;
    Column[] columns = null;
    private HashMap nameToIndex = new HashMap(7);

    public Table(String type, String name, String alias) {
        this.type = type;
        this.name = name;
        this.alias = alias;
    }

    public Table(String type, String name, String alias, Column[] columns) {
        this(type, name, alias);
        this.setColumns(columns);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public void setColumns(Column[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            this.addColumn(columns[i]);
        }
    }

    public void addColumn(Column column) {
        if (this.columns == null) {
            this.columns = new Column[1];
            this.columns[0] = column;
            this.nameToIndex.put(column.getName(), new Integer(1));
        } else {
            if (this.nameToIndex.get(column.getName()) != null) {
                throw new IllegalArgumentException("Column named '" + this.name + "' has already existed.");
            }
            Column[] columns2 = new Column[this.columns.length + 1];
            System.arraycopy(this.columns, 0, columns2, 0, this.columns.length);
            columns2[this.columns.length] = column;
            this.nameToIndex.put(column.getName(), new Integer(this.columns.length));
            this.columns = columns2;
        }
    }

    public Column getColumn(int index) {
        if (this.columns == null) {
            return null;
        }
        if (index < 0 || index >= this.columns.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.columns[index];
    }

    public Column getColumn(String name) {
        Integer index = (Integer)this.nameToIndex.get(name);
        if (index == null) {
            return null;
        }
        return this.columns[index];
    }

    public boolean equals(Object x) {
        if (x == null || !(x instanceof Table)) {
            return false;
        }
        return this.name.equals(((Table)x).getName());
    }
}

