/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olap.base;

import com.kingdee.bos.ctrl.analysis.modelcore.ExtensionSupport;
import com.kingdee.bos.ctrl.analysis.olap.DrillExpandPosition;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;

public class DrillExpandPositionBase
extends ExtensionSupport
implements DrillExpandPosition {
    public DrillExpandPositionBase() {
        super.setId("drillExpandPosition");
    }

    @Override
    public boolean canExpand(Position position, Member member) {
        OlapModel model = (OlapModel)this.getModel();
        Member[] pathMembers = this.memberPath(position, member);
        return model.getQueryManager().canExpand(pathMembers);
    }

    @Override
    public boolean canCollapse(Position position, Member member) {
        OlapModel model = (OlapModel)this.getModel();
        Member[] pathMembers = this.memberPath(position, member);
        return model.getQueryManager().canCollapse(pathMembers);
    }

    @Override
    public void expand(Position position, Member member) {
        OlapModel model = (OlapModel)this.getModel();
        Member[] pathMembers = this.memberPath(position, member);
        model.getQueryManager().expand(pathMembers);
    }

    @Override
    public void collapse(Position position, Member member) {
        OlapModel model = (OlapModel)this.getModel();
        Member[] pathMembers = this.memberPath(position, member);
        model.getQueryManager().collapse(pathMembers);
    }

    private Member[] memberPath(Position position, Member member) {
        Member[] posMembers = position.getMembers();
        int pathlen = 0;
        for (int i = 0; i < posMembers.length; ++i) {
            if (!posMembers[i].equals(member)) continue;
            pathlen = i + 1;
            break;
        }
        if (pathlen == 0) {
            return null;
        }
        Member[] pathMembers = new Member[pathlen];
        for (int i = 0; i < pathlen; ++i) {
            pathMembers[i] = posMembers[i];
        }
        return pathMembers;
    }

    @Override
    public void setUseExpandStateCache(boolean b) {
        OlapModel model = (OlapModel)this.getModel();
        model.getQueryManager().setUseExpandStateCache(b);
    }
}

