/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olap.querymanage;

import com.kingdee.bos.ctrl.analysis.olap.querymanage.TreeNodeCallback;
import com.kingdee.bos.olap.mdx.Exp;
import java.util.ArrayList;
import java.util.List;

public class TreeNode {
    private TreeNode parent = null;
    private List children = null;
    private Exp reference;

    public TreeNode(Exp obj) {
        this.reference = obj;
        this.children = new ArrayList();
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    private void removeChild(TreeNode child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
        }
    }

    public void addChildNode(TreeNode child) {
        child.parent = this;
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
    }

    public void insertChildNodeAfter(TreeNode child, TreeNode before) {
        if (this.children.contains(child)) {
            return;
        }
        int index = this.children.indexOf(before);
        if (index > -1) {
            this.children.add(index + 1, child);
        } else {
            this.children.add(child);
        }
        child.parent = this;
    }

    public void insertChildNodeBefore(TreeNode child, TreeNode after) {
        if (this.children.contains(child)) {
            return;
        }
        int index = this.children.indexOf(after);
        if (index > -1) {
            this.children.add(index, child);
        } else {
            this.children.add(child);
        }
        child.parent = this;
    }

    public TreeNode deepCopy() {
        TreeNode newNode = new TreeNode(this.reference);
        for (TreeNode child : this.children) {
            newNode.addChildNode(child.deepCopy());
        }
        return newNode;
    }

    public TreeNode deepCopyPrune(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("Depth is negative");
        }
        TreeNode newNode = new TreeNode(this.reference);
        if (depth == 0) {
            return newNode;
        }
        for (TreeNode child : this.children) {
            newNode.addChildNode(child.deepCopyPrune(depth - 1));
        }
        return newNode;
    }

    public int getLevel() {
        int level = 0;
        TreeNode p = this.parent;
        while (p != null) {
            ++level;
            p = p.parent;
        }
        return level;
    }

    public int walkTree(TreeNodeCallback callbackHandler) {
        int code = 0;
        code = callbackHandler.handleTreeNode(this);
        if (code != 0) {
            return code;
        }
        for (TreeNode child : this.children) {
            code = child.walkTree(callbackHandler);
            if (code < 2) continue;
            return code;
        }
        return code;
    }

    public int walkChildren(TreeNodeCallback callbackHandler) {
        int code = 0;
        for (TreeNode child : this.children) {
            code = callbackHandler.handleTreeNode(child);
            if (code >= 2) {
                return code;
            }
            if (code != 0 || (code = child.walkChildren(callbackHandler)) <= 2) continue;
            return code;
        }
        return code;
    }

    public List getChildren() {
        return this.children;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public Exp getReference() {
        return this.reference;
    }

    public void setReference(Exp object) {
        this.reference = object;
    }
}

