/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap;

import com.kingdee.bos.ctrl.analysis.olap.querymanage.TreeNode;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.TreeNodeCallback;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.DefaultListFactory;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.Syntax;
import com.kingdee.bos.olap.mdx.elementexp.ExprUtil;
import com.kingdee.bos.olap.mdx.elementexp.LevelExpr;
import com.kingdee.bos.olap.mdx.elementexp.MemberExpr;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class KDOLAP_Util {
    private static final Logger logger = CommonLogger.getLogger(KDOLAP_Util.class);

    public static Exp topLevelMembers(Hierarchy kdHier, boolean expandAllMember, SchemaReader scr) {
        try {
            if (kdHier.hasAll()) {
                String sAll = kdHier.getAllMemberName();
                Member kda = (Member)scr.lookupCompound((OLAPElement)kdHier.getDimension(), new String[]{sAll}, 6);
                if (kda != null) {
                    if (!expandAllMember) {
                        return new MemberExpr(kda);
                    }
                    MemberExpr[] kdar = new MemberExpr[]{new MemberExpr(kda)};
                    FunCall kdaSet = new FunCall("{}", (Exp[])kdar, Syntax.Braces);
                    FunCall mAllChildren = new FunCall("children", (Exp[])kdar, Syntax.Property);
                    FunCall union = new FunCall("{}", new Exp[]{kdaSet, mAllChildren}, Syntax.Braces);
                    return union;
                }
            }
            Level level0 = kdHier.getLevels()[0];
            LevelExpr levelExp = new LevelExpr(level0);
            return new FunCall("members", new Exp[]{levelExp}, Syntax.Property);
        }
        catch (OLAPException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Member[] getMemberDescendants(SchemaReader scr, Member member, Level level) throws OLAPException {
        Level lev;
        byte depth = level.getDepth();
        if (depth <= (lev = member.getLevel()).getDepth()) {
            return new Member[0];
        }
        IMemberList currentMembers = DefaultListFactory.instance.createMemberList();
        currentMembers.add((Object)member);
        while (depth > lev.getDepth()) {
            lev = lev.getChildLevel();
            currentMembers = scr.getMemberChildren(currentMembers);
        }
        return (Member[])currentMembers.toArray((Object[])new Member[0]);
    }

    public static Syntax funCallSyntax(String fuName, int nArgs) {
        if (fuName.equals("()")) {
            return Syntax.Parentheses;
        }
        if (fuName.equals("{}")) {
            return Syntax.Braces;
        }
        if (nArgs == 1) {
            if (fuName.equalsIgnoreCase("members")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("children")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("dimension")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("hierarchy")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("level")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("currentmember")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("defaultmember")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("firstchild")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("firstsibling")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("lastchild")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("lastsibling")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("nextmember")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("parent")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("prevmember")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("ordinal")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("value")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("lastperiods")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("siblings")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("name")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("uniquename")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("current")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("not")) {
                return Syntax.Prefix;
            }
            if (fuName.equals("-")) {
                return Syntax.Prefix;
            }
        } else if (nArgs == 2) {
            if (fuName.indexOf(60) >= 0) {
                return Syntax.Infix;
            }
            if (fuName.indexOf(61) >= 0) {
                return Syntax.Infix;
            }
            if (fuName.indexOf(62) >= 0) {
                return Syntax.Infix;
            }
            if (fuName.equals("*")) {
                return Syntax.Infix;
            }
            if (fuName.equals(":")) {
                return Syntax.Infix;
            }
            if (fuName.equals("+")) {
                return Syntax.Infix;
            }
            if (fuName.equals("-")) {
                return Syntax.Infix;
            }
            if (fuName.equals("/")) {
                return Syntax.Infix;
            }
            if (fuName.equalsIgnoreCase("||")) {
                return Syntax.Infix;
            }
            if (fuName.equalsIgnoreCase("and")) {
                return Syntax.Infix;
            }
            if (fuName.equalsIgnoreCase("or")) {
                return Syntax.Infix;
            }
            if (fuName.equalsIgnoreCase("xor")) {
                return Syntax.Infix;
            }
        }
        if (fuName.equalsIgnoreCase("lead")) {
            return Syntax.Method;
        }
        if (fuName.equalsIgnoreCase("properties")) {
            return Syntax.Method;
        }
        if (fuName.equalsIgnoreCase("item")) {
            return Syntax.Method;
        }
        return Syntax.Function;
    }

    static List collectMembers(TreeNode root, final int iDim, final SchemaReader scr) {
        if (root == null) {
            return null;
        }
        final ArrayList memberList = new ArrayList();
        int ret = root.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Exp exp = node.getReference();
                if (exp instanceof MemberExpr) {
                    Member m = ((MemberExpr)exp).getMember();
                    if (!memberList.contains(m)) {
                        memberList.add(m);
                    }
                } else {
                    FunCall f = (FunCall)exp;
                    boolean b = KDOLAP_Util.resolveFunCallMembers(f, memberList, scr);
                    if (!b) {
                        return 3;
                    }
                }
                return 1;
            }
        });
        if (ret == 3) {
            return null;
        }
        return memberList;
    }

    static boolean resolveFunCallMembers(FunCall f, List memberList, SchemaReader scr) {
        boolean canHandle = true;
        if (f.isCallTo("Children")) {
            Member[] members;
            Member m = ExprUtil.toMember((Exp)f.getArg(0));
            try {
                IMemberList list = scr.getMemberChildren(m);
                members = (Member[])list.toArray((Object[])new Member[0]);
            }
            catch (OLAPException e) {
                logger.info((Object)e);
                return false;
            }
            for (int i = 0; i < members.length; ++i) {
                if (memberList.contains(members[i])) continue;
                memberList.add(members[i]);
            }
        } else if (f.isCallTo("Descendants")) {
            Member[] members;
            Member m = ExprUtil.toMember((Exp)f.getArg(0));
            Level level = ExprUtil.toLevel((Exp)f.getArg(1));
            try {
                members = KDOLAP_Util.getMemberDescendants(scr, m, level);
            }
            catch (OLAPException e) {
                logger.info((Object)e.getMessage());
                return false;
            }
            for (int i = 0; i < members.length; ++i) {
                if (memberList.contains(members[i])) continue;
                memberList.add(members[i]);
            }
        } else if (f.isCallTo("Members")) {
            Level level = ExprUtil.toLevel((Exp)f.getArg(0));
            Member[] members = null;
            try {
                IMemberList list = scr.getLevelMembers(level);
                members = (Member[])list.toArray((Object[])new Member[0]);
            }
            catch (OLAPException list) {
                // empty catch block
            }
            for (int i = 0; i < members.length; ++i) {
                if (memberList.contains(members[i])) continue;
                memberList.add(members[i]);
            }
        } else if (f.isCallTo("Union")) {
            KDOLAP_Util.resolveFunCallMembers((FunCall)f.getArg(0), memberList, scr);
            KDOLAP_Util.resolveFunCallMembers((FunCall)f.getArg(1), memberList, scr);
        } else if (f.isCallTo("{}")) {
            for (int i = 0; i < f.getArgs().length; ++i) {
                if (f.getArg(i) instanceof FunCall) {
                    KDOLAP_Util.resolveFunCallMembers((FunCall)f.getArg(i), memberList, scr);
                    continue;
                }
                Member m = ExprUtil.toMember((Exp)f.getArg(i));
                if (memberList.contains(m)) continue;
                memberList.add(m);
            }
        } else {
            canHandle = false;
        }
        return canHandle;
    }
}

