/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.olapconnection;

import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModelUtil;
import com.kingdee.bos.ctrl.analysis.report.ReportResource;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.ConnectionInfoWrapper;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.IConnectStringParser;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.IOlapConnection;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.IOlapDriver;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.IURLResolver;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.KDOlapConnection;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.OlapConnectConstants;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.OlapConnectionException;
import com.kingdee.bos.ctrl.analysis.xmlutil.XMLException;
import java.io.IOException;
import java.io.InputStream;

public class OlapDriver
implements IOlapDriver,
OlapConnectConstants {
    IConnectStringParser connectStringParser;
    IURLResolver urlResolver;

    public OlapDriver(IConnectStringParser connectStringParser, IURLResolver urlResolver) {
        this.connectStringParser = connectStringParser;
        this.urlResolver = urlResolver;
    }

    @Override
    public IOlapConnection openConnection(String connectString) throws OlapConnectionException {
        ConnectionInfoWrapper info = this.connectStringParser.parse(connectString);
        switch (info.getConnectType()) {
            case 0: {
                return this.createKDConnection(info.getUrl());
            }
        }
        throw new OlapConnectionException(info.getProvider() + ReportResource.getString(ReportResource.class, (String)"unimplemented"));
    }

    private IOlapConnection createKDConnection(String url) throws OlapConnectionException {
        try {
            InputStream in = this.urlResolver.openInputStream(url);
            CubeModel cubemodel = CubeModelUtil.loadSchema(in);
            return new KDOlapConnection(cubemodel);
        }
        catch (IOException e) {
            throw new OlapConnectionException(ReportResource.getString(ReportResource.class, (String)"cantcreate") + "KDOlap" + ReportResource.getString(ReportResource.class, (String)"connopen") + url + ReportResource.getString(ReportResource.class, (String)"fail"), e);
        }
        catch (XMLException e) {
            throw new OlapConnectionException(ReportResource.getString(ReportResource.class, (String)"cantcreate") + "KDOlap" + ReportResource.getString(ReportResource.class, (String)"con") + url + ReportResource.getString(ReportResource.class, (String)"illegal") + "KD Olap" + ReportResource.getString(ReportResource.class, (String)"model"), e);
        }
    }
}

