/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.ui;

import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.Result;
import com.kingdee.bos.ctrl.analysis.report.ui.ValueColFilter;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ValueColFilterHelper {
    ArrayList valueColFilterList = null;
    int leftAxisCount = -1;
    int topAxisCount = -1;
    Result result = null;
    List topPoses = null;

    ValueColFilterHelper() {
    }

    public List getValueColFilterList(OlapModel olapModel, KDPanel container) {
        this.getAxisInfo(olapModel);
        this.valueColFilterList = new ArrayList();
        int nIndex = 0;
        Iterator it = this.topPoses.iterator();
        while (it.hasNext()) {
            ValueColFilter o = new ValueColFilter((Position)it.next(), nIndex++, this.leftAxisCount, this.topAxisCount, this.result, container);
            this.valueColFilterList.add(o);
        }
        return this.valueColFilterList;
    }

    public void reloadValueColData(OlapModel olapModel, ValueColFilter filter) {
        if (this.valueColFilterList == null) {
            return;
        }
        int index = 0;
        Iterator iter = this.valueColFilterList.iterator();
        while (iter.hasNext()) {
            if (filter.sameCol(iter.next())) {
                this.getAxisInfo(olapModel);
                filter.loadCellList(index, this.leftAxisCount, this.topAxisCount, this.result);
            }
            ++index;
        }
    }

    private void getAxisInfo(OlapModel olapModel) {
        Axis leftAxis = null;
        Axis topAxis = null;
        try {
            leftAxis = OlapModelUtil.getLeftAxis(olapModel);
            List leftPoses = leftAxis.getPositions();
            this.leftAxisCount = leftPoses.size();
            topAxis = OlapModelUtil.getTopAxis(olapModel);
            this.topPoses = topAxis.getPositions();
            this.topAxisCount = this.topPoses.size();
            this.result = olapModel.getResult();
        }
        catch (OlapException e1) {
            e1.printStackTrace();
        }
    }
}

