/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.ui.style;

import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.report.ui.style.HierarchyTreeModel;
import com.kingdee.bos.ctrl.analysis.util.FaceUtil;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.NonIcon;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SelectMergeMembersDlg
extends TypicalDialog
implements KDPromptSelector {
    private OlapModel model = null;
    private KDTree tree = null;

    SelectMergeMembersDlg(Dialog parent) {
        super(parent);
        this.setSize(400, 400);
        this.setTitle("\u9009\u62e9\u878d\u5408\u6210\u5458");
        this.tree = new KDTree();
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (treeNode.getChildCount() == 0) {
                    SelectMergeMembersDlg.this.expandNode(treeNode);
                }
            }
        });
    }

    public void setOlapModel(OlapModel model) {
        this.model = model;
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"");
        DefaultTreeModel tm = new DefaultTreeModel((TreeNode)root);
        tm.setAsksAllowsChildren(true);
        Dimension[] dims = model.getDimensions();
        for (int i = 0; i < dims.length; ++i) {
            Hierarchy hie = dims[i].getHierarchies()[0];
            HierarchyTreeModel htm = new HierarchyTreeModel(model, hie);
            root.add((MutableTreeNode)((DefaultKingdeeTreeNode)htm.getRoot()));
        }
        this.tree.setRootVisible(false);
        this.tree.setModel((TreeModel)tm);
    }

    protected void todoInit() {
        FaceUtil.center((Window)((Object)this));
    }

    private void expandNode(DefaultKingdeeTreeNode node) {
        Member member;
        if (node.getUserObject() instanceof Member && (member = (Member)node.getUserObject()) != null && OlapModelUtil.getMemberTree(this.model).hasChildren(member)) {
            this.makeTree(node, OlapModelUtil.getMemberTree(this.model).getChildren(member));
        }
    }

    private void makeTree(DefaultKingdeeTreeNode node, Member[] ms) {
        for (int i = 0; i < ms.length; ++i) {
            this.tree.addNodeInto((MutableTreeNode)this.createMemberNode(ms[i]), (MutableTreeNode)node);
        }
    }

    private DefaultKingdeeTreeNode createMemberNode(Member member) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)member);
        node.setText(member.getLabel());
        node.setAllowsChildren(OlapModelUtil.getMemberTree(this.model).hasChildren(member));
        node.setCustomIcon((Icon)NonIcon.getInstance());
        return node;
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        parent.add((Component)this.tree, thisCell);
    }

    public boolean isCanceled() {
        return !this.isOk;
    }

    protected boolean verify() {
        String[] ss = this.getSelectedUniqueNames();
        if (ss == null || ss.length < 2) {
            JOptionPane.showMessageDialog((Component)((Object)this), "\u8bf7\u9009\u62e9\u4e24\u4e2a\u6216\u4ee5\u4e0a\u6210\u5458\u3002");
            return false;
        }
        return true;
    }

    public Object getData() {
        if (this.isOk) {
            return this.getSelectedUniqueNames();
        }
        return null;
    }

    private String[] getSelectedUniqueNames() {
        TreePath[] tps = this.tree.getSelectionPaths();
        if (tps != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < tps.length; ++i) {
                TreePath tp = tps[i];
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
                Object v = node.getUserObject();
                if (v == null || !(v instanceof Member)) continue;
                list.add(((Member)v).getUniqueName());
            }
            String[] ss = new String[list.size()];
            list.toArray(ss);
            return ss;
        }
        return null;
    }

    public void show() {
        this.showDialog();
    }
}

