/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax;

import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.olap.ChangeSlicer;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.SwapAxes;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Hierarchy;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Member;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_QueryManager;
import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.BIWebComponent;
import com.kingdee.bos.ctrl.analysis.web.WebFrameworkException;
import com.kingdee.bos.ctrl.analysis.web.ajax.BIReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.ChartUIO;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.ajax.MdxQueryO;
import com.kingdee.bos.ctrl.analysis.web.ajax.ReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.WorksheetUIO;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONFactory;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.util.IDGenerator;
import com.kingdee.bos.ctrl.analysis.web.worksheet.WorksheetComponent;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.func.FuncUtil2;
import java.io.BufferedWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public abstract class UIO {
    private static Logger logger = CommonLogger.getLogger(UIO.class);
    protected String id = IDGenerator.getID();
    protected String name;
    protected String caption;
    protected String type;
    protected ReportPage page;
    protected String schemename;
    protected int perPageRows;
    private static final String REQUEST_LINKFLAG = "linkFlag";

    public UIO(ReportPage page, String name, String caption, String type) {
        this.name = name;
        this.caption = caption;
        this.type = type;
        this.page = page;
    }

    public UIO(ReportPage page, String name, String caption, String type, String schemename, int perPageRows) {
        this(page, name, caption, type);
        this.schemename = schemename;
        this.perPageRows = perPageRows;
    }

    public abstract BIWebComponent getComponent();

    public abstract String service(HttpServletRequest var1) throws BIReportException;

    protected Map getParametersForXSL(HttpServletRequest request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("context", request.getContextPath());
        parameters.put("pageId", this.page.pageId.toString());
        parameters.put("uiid", this.id);
        parameters.put("reportUrl", request.getContextPath() + "/" + Constants.SERVLET_URL);
        String baseHref = request.getRequestURL().toString();
        baseHref = baseHref.substring(0, baseHref.indexOf(request.getContextPath() + "/" + Constants.SERVLET_URL));
        parameters.put("base_href", baseHref);
        parameters.put("useRepository", this.page.canUseRepository() ? "true" : "false");
        return parameters;
    }

    protected String transXSL(HttpServletRequest request, String xslUri, BIWebComponent comp) throws BIReportException {
        Document document;
        Map parameters = this.getParametersForXSL(request);
        Transformer transformer = XmlUtil.getTransformer(request.getSession(), xslUri, false);
        for (String name : parameters.keySet()) {
            Object value = parameters.get(name);
            transformer.setParameter(name, value);
        }
        try {
            document = comp.render(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BIReportException(e);
        }
        DOMSource source = new DOMSource(document);
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw, 4096);
        StreamResult result = new StreamResult(bw);
        try {
            transformer.transform(source, result);
            sw.flush();
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new BIReportException(e);
        }
        return sw.toString().replaceAll("\\n|\\r", "");
    }

    protected String getAllHierarchy(HttpServletRequest request, OlapModel olapModel) throws BIReportException {
        StringBuffer sb = new StringBuffer();
        String STRING_SEPARATOR = "\u0001";
        List hies = OlapModelUtil.getAllHierarchy(olapModel);
        boolean first = true;
        for (com.kingdee.bos.ctrl.analysis.olap.Hierarchy hie : hies) {
            if (!first) {
                sb.append(STRING_SEPARATOR);
            }
            sb.append(hie.getUniqueName());
            sb.append(STRING_SEPARATOR);
            sb.append(hie.getCaption());
            first = false;
        }
        return sb.toString();
    }

    protected String getSlicerChildren(HttpServletRequest request, OlapModel olapModel) {
        String hierName = request.getParameter("hierarchyName");
        String memberUniqueName = request.getParameter("memberUniqueName");
        IMemberList kdMembers = null;
        ArrayList<com.kingdee.bos.olap.Member> list = new ArrayList<com.kingdee.bos.olap.Member>();
        if (memberUniqueName == null) {
            KDOLAP_Hierarchy hier = (KDOLAP_Hierarchy)olapModel.lookupHierarchy(hierName);
            Hierarchy kdHier = hier.getKDHierarchy();
            kdMembers = kdHier.getMembers();
            KDOLAP_QueryManager queryManager = (KDOLAP_QueryManager)olapModel.getQueryManager();
            SchemaReader sr = queryManager.getKDQuery().getSchemaReader();
            Cube cube = sr.getCube(olapModel.getCubeName());
            List<com.kingdee.bos.olap.Member> calMembers = Arrays.asList(sr.getCalculatedMembers(cube, kdHier));
            if (!kdHier.hasAll() & !kdHier.getDimension().isMeasureDimension()) {
                list.add(kdHier.getInnerAllMember());
            }
            for (com.kingdee.bos.olap.Member m : kdMembers) {
                if (!m.isVisible()) continue;
                list.add(m);
            }
            for (com.kingdee.bos.olap.Member m : calMembers) {
                if (!m.isVisible()) continue;
                list.add(m);
            }
            if (calMembers.size() > 0) {
                Collections.sort(list, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        return FuncUtil2.compareSiblingMembers((com.kingdee.bos.olap.Member)((com.kingdee.bos.olap.Member)arg0), (com.kingdee.bos.olap.Member)((com.kingdee.bos.olap.Member)arg1));
                    }
                });
            }
        } else {
            com.kingdee.bos.olap.Member parent = ((KDOLAP_Member)olapModel.lookupMember(memberUniqueName)).getKDMember();
            kdMembers = parent.getChildMembers();
            for (com.kingdee.bos.olap.Member m : kdMembers) {
                if (!m.isVisible()) continue;
                list.add(m);
            }
        }
        StringBuffer sb = new StringBuffer();
        String STRING_SEPARATOR = "\u0001";
        for (com.kingdee.bos.olap.Member kdMember : list) {
            sb.append(kdMember.getCaption());
            sb.append(STRING_SEPARATOR);
            sb.append(kdMember.getUniqueName());
            sb.append(STRING_SEPARATOR);
            sb.append(kdMember.isLeaf() ? 1 : 0);
            sb.append(STRING_SEPARATOR);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String getSlicerDescendant(HttpServletRequest request, OlapModel olapModel) {
        String memberUniqueName = request.getParameter("memberUniqueName");
        com.kingdee.bos.olap.Member parent = ((KDOLAP_Member)olapModel.lookupMember(memberUniqueName)).getKDMember();
        HashMap root = new HashMap(4);
        this.appendMemberInfo(root, parent);
        return JSONFactory.create(root).toString();
    }

    private void appendMemberInfo(Map map, com.kingdee.bos.olap.Member member) {
        map.put("caption", member.getCaption());
        map.put("value", member.getUniqueName());
        if (!member.isLeaf()) {
            IMemberList children = member.getChildMembers();
            ArrayList list = new ArrayList();
            map.put("children", list);
            for (com.kingdee.bos.olap.Member child : children) {
                if (!child.isVisible()) continue;
                HashMap map2 = new HashMap(4);
                list.add(map2);
                this.appendMemberInfo(map2, child);
            }
        }
    }

    protected String swapAxis(HttpServletRequest request, MdxQueryO mdxQueryO) throws BIReportException {
        SwapAxes swap;
        OlapModel olapModel = mdxQueryO.getOlapModel(request);
        swap.setSwapAxes(!(swap = (SwapAxes)olapModel.getExtension("swapAxes")).isSwapAxes());
        return this.getUsedUIOString(mdxQueryO);
    }

    protected String swapHierarchy(HttpServletRequest request, MdxQueryO mdxQueryO) throws BIReportException {
        OlapModel olapModel = mdxQueryO.getOlapModel(request);
        String src = request.getParameter("src");
        String dest = request.getParameter("dest");
        com.kingdee.bos.ctrl.analysis.olap.Hierarchy srcHier = olapModel.lookupHierarchy(src);
        com.kingdee.bos.ctrl.analysis.olap.Hierarchy destHier = olapModel.lookupHierarchy(dest);
        OlapModelUtil.swap(olapModel, srcHier, destHier);
        return this.getUsedUIOString(mdxQueryO);
    }

    protected String moveBefore(HttpServletRequest request, MdxQueryO mdxQueryO) throws BIReportException {
        com.kingdee.bos.ctrl.analysis.olap.Hierarchy destHier;
        OlapModel olapModel = mdxQueryO.getOlapModel(request);
        String src = request.getParameter("src");
        String dest = request.getParameter("dest");
        com.kingdee.bos.ctrl.analysis.olap.Hierarchy srcHier = olapModel.lookupHierarchy(src);
        if (OlapModelUtil.moveBefore(olapModel, srcHier, destHier = olapModel.lookupHierarchy(dest))) {
            return this.getUsedUIOString(mdxQueryO);
        }
        return "false";
    }

    protected String moveAfter(HttpServletRequest request, MdxQueryO mdxQueryO) throws BIReportException {
        com.kingdee.bos.ctrl.analysis.olap.Hierarchy destHier;
        OlapModel olapModel = mdxQueryO.getOlapModel(request);
        String src = request.getParameter("src");
        String dest = request.getParameter("dest");
        com.kingdee.bos.ctrl.analysis.olap.Hierarchy srcHier = olapModel.lookupHierarchy(src);
        if (OlapModelUtil.moveAfter(olapModel, srcHier, destHier = olapModel.lookupHierarchy(dest))) {
            return this.getUsedUIOString(mdxQueryO);
        }
        return "false";
    }

    protected String moveTo(HttpServletRequest request, MdxQueryO mdxQueryO) throws BIReportException {
        OlapModel olapModel = mdxQueryO.getOlapModel(request);
        String src = request.getParameter("src");
        String dest = request.getParameter("dest");
        com.kingdee.bos.ctrl.analysis.olap.Hierarchy srcHier = olapModel.lookupHierarchy(src);
        boolean suc = false;
        if (dest.equals("slicer")) {
            suc = OlapModelUtil.moveToSlice(olapModel, srcHier);
        } else if (dest.equals("columns")) {
            suc = OlapModelUtil.moveToTop(olapModel, srcHier);
        } else if (dest.equals("rows")) {
            suc = OlapModelUtil.moveToLeft(olapModel, srcHier);
        } else {
            throw new BIReportException("Illegal moveTo dest:" + dest);
        }
        if (suc) {
            return this.getUsedUIOString(mdxQueryO);
        }
        return "false";
    }

    private void changeSlicerLinkage(HttpServletRequest request, MdxQueryO mdxQueryO, String memberUniqueName, StringBuffer sb) throws BIReportException {
        boolean linkFlag = "true".equalsIgnoreCase(request.getParameter(REQUEST_LINKFLAG));
        if (linkFlag) {
            Object[] querys = ((BIReportPage)this.page).getMdxQueryOManager().getAllMdxQueryO();
            for (int i = 0; i < querys.length; ++i) {
                OlapModel olapModel;
                Member member;
                MdxQueryO queryO = (MdxQueryO)querys[i];
                if (queryO == null || queryO.getName().equals(mdxQueryO.getName()) || (member = (olapModel = queryO.getOlapModel(null)).lookupMember(memberUniqueName)) == null || !this.isSlicer(olapModel, member.getHierarchy())) continue;
                ChangeSlicer changeSlicer = (ChangeSlicer)olapModel.getExtension("changeSlicer");
                changeSlicer.setMember(member);
                if (!sb.toString().equals("")) {
                    sb.append(",");
                }
                sb.append(this.getUsedUIOString(queryO));
            }
        }
    }

    private void changeHierarchyMembersLinkage(HttpServletRequest request, MdxQueryO mdxQueryO, List memberList, String hierUniqueName, StringBuffer sb) throws BIReportException {
        boolean linkFlag = "true".equalsIgnoreCase(request.getParameter(REQUEST_LINKFLAG));
        if (linkFlag) {
            Object[] querys = ((BIReportPage)this.page).getMdxQueryOManager().getAllMdxQueryO();
            for (int i = 0; i < querys.length; ++i) {
                com.kingdee.bos.ctrl.analysis.olap.Hierarchy hier;
                MdxQueryO queryO = (MdxQueryO)querys[i];
                if (queryO == null || queryO.getName().equals(mdxQueryO.getName())) continue;
                OlapModel olapModel = queryO.getOlapModel(null);
                Iterator iter = memberList.iterator();
                while (iter.hasNext()) {
                    Member member = (Member)iter.next();
                    if (olapModel.lookupMember(member.getUniqueName()) != null) continue;
                    iter.remove();
                }
                if (memberList.size() == 0 || (hier = olapModel.lookupHierarchy(hierUniqueName)) == null || this.isSlicer(olapModel, hier)) continue;
                OlapModelUtil.changeHierarchyMembers(olapModel, hier, memberList);
                if (!sb.toString().equals("")) {
                    sb.append(",");
                }
                sb.append(this.getUsedUIOString(queryO));
            }
        }
    }

    private boolean isSlicer(OlapModel model, com.kingdee.bos.ctrl.analysis.olap.Hierarchy h) throws BIReportException {
        com.kingdee.bos.ctrl.analysis.olap.Hierarchy[] hs;
        try {
            hs = model.getResult().getSlicer().getHierarchies();
        }
        catch (OlapException e) {
            throw new BIReportException(e);
        }
        for (int i = 0; i < hs.length; ++i) {
            if (!hs[i].getName().equals(h.getName())) continue;
            return true;
        }
        return false;
    }

    protected String changeSlicer(HttpServletRequest request, MdxQueryO mdxQueryO) throws BIReportException {
        OlapModel olapModel = mdxQueryO.getOlapModel(request);
        String memberUniqueName = request.getParameter("memberUniqueName");
        ChangeSlicer changeSlicer = (ChangeSlicer)olapModel.getExtension("changeSlicer");
        changeSlicer.setMember(olapModel.lookupMember(memberUniqueName));
        StringBuffer sb = new StringBuffer();
        sb.append(this.getUsedUIOString(mdxQueryO));
        this.changeSlicerLinkage(request, mdxQueryO, memberUniqueName, sb);
        return sb.toString();
    }

    protected String findVisibleMembers(HttpServletRequest request, MdxQueryO mdxQueryO) throws BIReportException {
        OlapModel olapModel = mdxQueryO.getOlapModel(request);
        String hierUniqueName = request.getParameter("hierarchyName");
        List list = OlapModelUtil.findVisibleMembers(olapModel, olapModel.lookupHierarchy(hierUniqueName));
        Iterator it = list.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append("\u0001");
            }
            sb.append(((KDOLAP_Member)it.next()).getUniqueName());
        }
        return sb.toString();
    }

    protected String changeHierarchyMembers(HttpServletRequest request, MdxQueryO mdxQueryO) throws BIReportException {
        OlapModel olapModel = mdxQueryO.getOlapModel(request);
        String hierUniqueName = request.getParameter("hierarchyName");
        String[] memberUniqueNames = request.getParameterValues("memberUniqueNames");
        ArrayList<Member> memberList = new ArrayList<Member>();
        for (int i = 0; i < memberUniqueNames.length; ++i) {
            memberList.add(olapModel.lookupMember(memberUniqueNames[i]));
        }
        com.kingdee.bos.ctrl.analysis.olap.Hierarchy hier = olapModel.lookupHierarchy(hierUniqueName);
        OlapModelUtil.changeHierarchyMembers(olapModel, hier, memberList);
        StringBuffer sb = new StringBuffer();
        sb.append(this.getUsedUIOString(mdxQueryO));
        this.changeHierarchyMembersLinkage(request, mdxQueryO, memberList, hierUniqueName, sb);
        return sb.toString();
    }

    protected String getUsedUIOString(MdxQueryO mdxQueryO) {
        UIO[] uios = this.getUsedUIOs(mdxQueryO);
        return this.getUIOString(uios);
    }

    protected String getUIOString(UIO[] uios) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < uios.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(uios[i].getId().toString());
        }
        return sb.toString();
    }

    protected UIO[] getUsedUIOs(MdxQueryO mdxQueryO) {
        ArrayList<UIO> list = new ArrayList<UIO>();
        UIO[] uios = this.page.uioManager.getAllUIOs();
        for (int i = 0; i < uios.length; ++i) {
            if (uios[i] instanceof ChartUIO && ((ChartUIO)uios[i]).getMdxQueryO() == mdxQueryO) {
                list.add(uios[i]);
                continue;
            }
            if (!(uios[i] instanceof WorksheetUIO) || ((WorksheetUIO)uios[i]).getMdxQueryO() != mdxQueryO) continue;
            list.add(uios[i]);
        }
        uios = new UIO[list.size()];
        list.toArray(uios);
        return uios;
    }

    protected UIO[] getUsedChartUIOs(MdxQueryO mdxQueryO) {
        ArrayList<UIO> list = new ArrayList<UIO>();
        UIO[] uios = this.page.uioManager.getAllUIOs();
        for (int i = 0; i < uios.length; ++i) {
            if (!(uios[i] instanceof ChartUIO) || ((ChartUIO)uios[i]).getMdxQueryO() != mdxQueryO) continue;
            list.add(uios[i]);
        }
        uios = new UIO[list.size()];
        list.toArray(uios);
        return uios;
    }

    protected String getUsedChartUIOString(MdxQueryO mdxQueryO) {
        UIO[] uios = this.getUsedChartUIOs(mdxQueryO);
        return this.getUIOString(uios);
    }

    protected String setPerPageRows(HttpServletRequest request, MdxQueryO mdxQueryO) {
        int perPageRows = (int)Double.parseDouble(request.getParameter("rows"));
        UIO[] uios = this.getUsedUIOs(mdxQueryO);
        for (int i = 0; i < uios.length; ++i) {
            BIWebComponent component = uios[i].getComponent();
            if (component instanceof WorksheetComponent) {
                ((WorksheetComponent)component).setPagePerRows(perPageRows);
                continue;
            }
            ((ChartComponent)component).setPagePerRows(perPageRows);
        }
        return this.getUsedUIOString(mdxQueryO);
    }

    protected String setPage(HttpServletRequest request, MdxQueryO mdxQueryO) {
        int pageIndex = (int)Double.parseDouble(request.getParameter("page"));
        UIO[] uios = this.getUsedUIOs(mdxQueryO);
        for (int i = 0; i < uios.length; ++i) {
            BIWebComponent component = uios[i].getComponent();
            if (component instanceof WorksheetComponent) {
                ((WorksheetComponent)component).setCurrentPage(pageIndex);
                continue;
            }
            ((ChartComponent)component).setCurrentPage(pageIndex);
        }
        return this.getUsedUIOString(mdxQueryO);
    }

    public Object getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getType() {
        return this.type;
    }

    public void clearUIStatus() {
    }

    public void release() {
        BIWebComponent component = this.getComponent();
        if (component != null) {
            try {
                component.destroy();
            }
            catch (WebFrameworkException e) {
                logger.error((Object)("error when release UIO,id=" + this.id + ",name=" + this.name));
            }
        }
    }

    public String getSchemeName() {
        return this.schemename;
    }
}

