/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.chart;

import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartModel;
import com.kingdee.bos.ctrl.analysis.web.chart.IMemberFilter;
import com.kingdee.bos.ctrl.analysis.web.chart.MemberFilterFactory;
import com.kingdee.bos.ctrl.analysis.web.chart.TopInfo;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.olap.util.Util;
import org.w3c.dom.Node;

public class ChartDataModel {
    private Dimension[] rowDimensions;
    private Dimension[] columnDimensions;
    private Member[] memberIncludes;
    private Member[] memberExcludes;
    private IMemberFilter[] memberFilters;
    private TopInfo topN;
    private ChartModel chartModel;

    private ChartDataModel() {
    }

    public ChartDataModel(ChartModel chartModel, Node node) throws BIReportException {
        this.chartModel = chartModel;
        if (node != null) {
            this.parse(node);
        }
    }

    public static ChartDataModel createDefaultDataModel(ChartModel chartModel) {
        ChartDataModel cdm = new ChartDataModel();
        cdm.chartModel = chartModel;
        TopInfo topN = new TopInfo();
        topN.value = 10;
        cdm.topN = topN;
        return cdm;
    }

    private void parse(Node root) throws BIReportException {
        Node topNode;
        Node memberFilterNode;
        Node memberExcludeNode;
        Node rowNode = XmlUtil.getChildNode(root, "Row");
        Node columnNode = XmlUtil.getChildNode(root, "Column");
        if (rowNode != null && columnNode != null) {
            this.rowDimensions = this.parseDimension(rowNode);
            this.columnDimensions = this.parseDimension(columnNode);
        } else if (rowNode != null || columnNode != null) {
            throw new BIReportException("ChartComponent\u7684DataModel\u4e2dRow\u548cColumn\u5fc5\u987b\u540c\u65f6\u51fa\u73b0.");
        }
        Node memberIncludeNode = XmlUtil.getChildNode(root, "MemberInclude");
        if (memberIncludeNode != null) {
            this.memberIncludes = this.parseMembers(memberIncludeNode);
        }
        if ((memberExcludeNode = XmlUtil.getChildNode(root, "MemberExclude")) != null) {
            this.memberExcludes = this.parseMembers(memberExcludeNode);
        }
        if ((memberFilterNode = XmlUtil.getChildNode(root, "MemberFilter")) != null) {
            this.memberFilters = this.parseMemberFilters(memberFilterNode);
        }
        if ((topNode = XmlUtil.getChildNode(root, "TopN")) != null) {
            this.topN = this.parseTopN(topNode);
        }
    }

    private TopInfo parseTopN(Node node) throws BIReportException {
        TopInfo topInfo = new TopInfo();
        String attr = XmlUtil.getNodeAttribute(node, "value");
        if (attr == null || "".equals(attr)) {
            throw new BIReportException("TopN 'value' must not be null.");
        }
        int value = 0;
        try {
            value = Integer.parseInt(attr);
        }
        catch (Throwable t) {
            throw new BIReportException("TopN 'value' must be integer.");
        }
        topInfo.value = value;
        attr = XmlUtil.getNodeAttribute(node, "other");
        topInfo.other = "true".equals(attr);
        return topInfo;
    }

    private IMemberFilter[] parseMemberFilters(Node node) throws BIReportException {
        String s = XmlUtil.getNodeTextContent(node);
        if (s == "") {
            return null;
        }
        String[] ss = ChartDataModel.split(s);
        IMemberFilter[] mfs = new IMemberFilter[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            mfs[i] = MemberFilterFactory.getMemberFilter(this.chartModel.getOlapModel(), ss[i]);
            if (mfs[i] != null) continue;
            throw new BIReportException(ss[i] + " invalid.");
        }
        return mfs;
    }

    private Member[] parseMembers(Node node) throws BIReportException {
        String s = XmlUtil.getNodeTextContent(node);
        if (s.trim() == "") {
            return null;
        }
        String[] ss = ChartDataModel.split(s);
        Member[] ms = new Member[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            ms[i] = this.chartModel.getOlapModel().lookupMember(Util.createUName((String)ss[i]));
            if (ms[i] != null) continue;
            throw new BIReportException(ss[i] + " is not a member.");
        }
        return ms;
    }

    private Dimension[] parseDimension(Node node) throws BIReportException {
        String s = XmlUtil.getNodeTextContent(node);
        if (s == "") {
            throw new BIReportException(node.getNodeName() + " can't be null.");
        }
        String[] ss = ChartDataModel.split(s);
        Dimension[] dims = new Dimension[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            dims[i] = this.chartModel.getOlapModel().lookupDimension(Util.createUName((String)ss[i]));
            if (dims[i] != null) continue;
            throw new BIReportException(ss[i] + " is not a dimension.");
        }
        return dims;
    }

    private static String[] split(String str) {
        return str.split(";");
    }

    public Dimension[] getRowDimensions() {
        return this.rowDimensions;
    }

    public Dimension[] getColumnDimensions() {
        return this.columnDimensions;
    }

    public Member[] getMemberIncludes() {
        return this.memberIncludes;
    }

    public Member[] getMemberExcludes() {
        return this.memberExcludes;
    }

    public IMemberFilter[] getMemberFilters() {
        return this.memberFilters;
    }

    public TopInfo getTopN() {
        return this.topN;
    }
}

