/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.chart;

import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.DrillReplace;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Level;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartComponent;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartDataModel;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartDataSet;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.category.IntervalSubCategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.category.SubCategoryDataset;
import com.kingdee.bos.ctrl.freechart.util.TableOrder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ChartModel {
    private OlapModel olapModel;
    private boolean dirty = true;
    ChartComponent component;
    private ChartDataModel dataModel;
    private ChartDataSet chartDataSet;

    ChartModel(ChartComponent component) throws BIReportException {
        this.component = component;
    }

    public ChartDataModel getDataModel() throws BIReportException {
        if (this.dataModel == null) {
            this.dataModel = this.component.getChartConfig().getDataModelNode() != null ? new ChartDataModel(this, this.component.getChartConfig().getDataModelNode()) : ChartDataModel.createDefaultDataModel(this);
        }
        return this.dataModel;
    }

    public Member[] getSlicerMembers() throws OlapException {
        Iterator pi = this.olapModel.getResult().getSlicer().getPositions().iterator();
        if (pi.hasNext()) {
            return ((Position)pi.next()).getMembers();
        }
        return null;
    }

    private ChartDataSet getChartDataSet() throws OlapException, BIReportException {
        if (this.chartDataSet == null) {
            this.chartDataSet = new ChartDataSet(this);
        }
        return this.chartDataSet;
    }

    public Hierarchy[] getRowHierarchies() throws OlapException, BIReportException {
        return this.getChartDataSet().getRowHierarchies();
    }

    public Hierarchy[] getColumnHierarchies() throws OlapException, BIReportException {
        return this.getChartDataSet().getColumnHierarchies();
    }

    public int getRowCount() throws OlapException, BIReportException {
        return this.getChartDataSet().getRowCount();
    }

    public CategoryDataset buildDataset(int rowStart, int rowEnd) throws OlapException, BIReportException {
        return this.getChartDataSet().buildDataset();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.chartDataSet = null;
    }

    public boolean doDrillUp(String memberUniqueName) {
        Member member = this.olapModel.lookupMember(memberUniqueName);
        DrillReplace drillReplace = (DrillReplace)this.olapModel.getExtension("drillReplace");
        if (drillReplace.canDrillUp(member.getHierarchy())) {
            drillReplace.drillUp(member.getHierarchy());
            return true;
        }
        return false;
    }

    public boolean doMemberDrill(String memberUniqueName) {
        Member member = this.olapModel.lookupMember(memberUniqueName);
        DrillReplace drillReplace = (DrillReplace)this.olapModel.getExtension("drillReplace");
        if (drillReplace.canDrillDown(member)) {
            drillReplace.drillDown(member);
            return true;
        }
        return false;
    }

    public boolean doLevelDrill(String memberUniqueName) {
        Member member = this.olapModel.lookupMember(memberUniqueName);
        Level level = member.getLevel();
        DrillReplace drillReplace = (DrillReplace)this.olapModel.getExtension("drillReplace");
        if (drillReplace.canDrillDown(level)) {
            drillReplace.drillDown(level);
            return true;
        }
        return false;
    }

    public boolean setOlapModel(OlapModel newOlapModel) {
        if (this.olapModel != newOlapModel) {
            if (this.olapModel != null) {
                this.olapModel.removeModelChangeListener(this.component);
                this.olapModel.destroy();
            }
            this.setDirty(true);
            this.olapModel = newOlapModel;
            this.olapModel.addModelChangeListener(this.component);
            return true;
        }
        return false;
    }

    public Member[] getMemberContext(int column, int row) throws OlapException, BIReportException {
        return this.getChartDataSet().getMemberContext(column, row);
    }

    public OlapModel getOlapModel() {
        return this.olapModel;
    }

    public void setDataModel(ChartDataModel model) {
        this.dataModel = model;
    }

    public CategoryDataset[] splitBarLineDataset(CategoryDataset dataset, String memberString) {
        if (memberString != null && !memberString.equals("")) {
            String[] names = StringUtil.splitString((String)memberString, (String)",");
            ArrayList<Member> members = new ArrayList<Member>();
            for (int i = 0; i < names.length; ++i) {
                Member member = this.olapModel.lookupMember(names[i]);
                if (member == null) continue;
                members.add(member);
            }
            if (members.size() > 0) {
                try {
                    ArrayList<Integer> ret = new ArrayList<Integer>();
                    Axis axis = OlapModelUtil.getTopAxis(this.olapModel);
                    List listPos = axis.getPositions();
                    HashSet<String> posSet = new HashSet<String>();
                    int repeat = 0;
                    for (int i = 0; i < listPos.size(); ++i) {
                        Position pos = (Position)listPos.get(i);
                        if (posSet.contains(pos.toString())) {
                            ++repeat;
                            continue;
                        }
                        posSet.add(pos.toString());
                        Member[] posMembers = pos.getMembers();
                        for (int j = 0; j < posMembers.length; ++j) {
                            if (!members.contains(posMembers[j])) continue;
                            ret.add(new Integer(i - repeat));
                        }
                    }
                    if (ret.size() > 0 && ret.size() < listPos.size()) {
                        int[] indexes = new int[ret.size()];
                        for (int i = 0; i < ret.size(); ++i) {
                            indexes[i] = (Integer)ret.get(i);
                        }
                        IntervalSubCategoryDataset dataset1 = new IntervalSubCategoryDataset(dataset, indexes, true);
                        IntervalSubCategoryDataset dataset2 = new IntervalSubCategoryDataset(dataset, indexes, false);
                        return new CategoryDataset[]{dataset1, dataset2};
                    }
                }
                catch (OlapException e) {
                    e.printStackTrace();
                }
            }
        }
        int rowCount = dataset.getRowCount();
        SubCategoryDataset dataset1 = new SubCategoryDataset(dataset, TableOrder.BY_ROW, 0, rowCount - 1);
        SubCategoryDataset dataset2 = new SubCategoryDataset(dataset, TableOrder.BY_ROW, rowCount - 1, rowCount);
        return new CategoryDataset[]{dataset1, dataset2};
    }
}

