/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.chart;

import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetChartServletHandler {
    public static void handle(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String filename = request.getParameter("filename");
        if (filename == null) {
            throw new ServletException("Parameter 'filename' must be supplied");
        }
        File file = new File(System.getProperty("java.io.tmpdir"), filename);
        if (!file.exists()) {
            throw new ServletException("File '" + file.getAbsolutePath() + "' does not exist");
        }
        GetChartServletHandler.sendTempFile(file, response);
    }

    public static void sendTempFile(File file, HttpServletResponse response) throws IOException, FileNotFoundException {
        String mimeType = null;
        String filename = file.getName();
        if (filename.length() > 5) {
            if (filename.substring(filename.length() - 5, filename.length()).equals(".jpeg") || filename.substring(filename.length() - 5, filename.length()).equals(".jpg")) {
                mimeType = "image/jpeg";
            } else if (filename.substring(filename.length() - 4, filename.length()).equals(".png")) {
                mimeType = "image/png";
            } else if (filename.substring(filename.length() - 4, filename.length()).equals(".gif")) {
                mimeType = "image/gif";
            }
        }
        GetChartServletHandler.sendTempFile(file, response, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendTempFile(File file, HttpServletResponse response, String mimeType) throws IOException {
        BufferedOutputStream bos;
        BufferedInputStream bis;
        block6: {
            block5: {
                if (!file.exists()) break block5;
                bis = null;
                bos = null;
                try {
                    bis = new BufferedInputStream(new FileInputStream(file));
                    if (mimeType != null) {
                        response.setHeader("Content-Type", mimeType);
                    }
                    response.setHeader("Content-Length", String.valueOf(file.length()));
                    SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
                    response.setHeader("Last-Modified", sdf.format(new Date(file.lastModified())));
                    bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
                    byte[] input = new byte[1024];
                    boolean eof = false;
                    while (!eof) {
                        int length = bis.read(input);
                        if (length == -1) {
                            eof = true;
                            continue;
                        }
                        bos.write(input, 0, length);
                    }
                    bos.flush();
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{bis, bos});
                    throw throwable;
                }
                break block6;
            }
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        CloseUtil.close((Closeable[])new Closeable[]{bis, bos});
    }
}

