/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.chart;

import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.util.Escape;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartModel;
import com.kingdee.bos.ctrl.freechart.chart.urls.StandardPieURLGenerator;
import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.category.CategoryToPieDataset;
import com.kingdee.bos.ctrl.freechart.data.general.PieDataset;
import com.kingdee.bos.ctrl.freechart.util.TableOrder;
import java.util.Arrays;
import java.util.List;

public class MyPieURLGenerator
extends StandardPieURLGenerator {
    private static final long serialVersionUID = -4242899211997527261L;
    private ChartModel chartModel;
    private String compId;

    public MyPieURLGenerator(ChartModel chartModel, String compId) {
        this.chartModel = chartModel;
        this.compId = compId;
    }

    public String generateURL(PieDataset data, Comparable key, int pieIndex) {
        if (data instanceof CategoryToPieDataset) {
            int category;
            int series;
            CategoryDataset dataset = ((CategoryToPieDataset)data).getUnderlyingDataset();
            String key_category = null;
            String key_series = null;
            if (((CategoryToPieDataset)data).getExtractType().equals((Object)TableOrder.BY_COLUMN)) {
                key_series = key.toString();
                key_category = dataset.getColumnKey(pieIndex).toString();
                series = dataset.getRowIndex(key);
                category = pieIndex;
            } else {
                key_category = key.toString();
                key_series = dataset.getRowKey(pieIndex).toString();
                category = dataset.getColumnIndex(key);
                series = pieIndex;
            }
            try {
                List<Member> slicerList = Arrays.asList(this.chartModel.getSlicerMembers());
                Member[] ms = this.chartModel.getMemberContext(series, category);
                StringBuffer sb = new StringBuffer();
                StringBuffer captions = new StringBuffer();
                boolean first = true;
                for (int i = 0; i < ms.length; ++i) {
                    if (slicerList.contains(ms[i]) || ms[i].isMeasure()) continue;
                    if (!first) {
                        sb.append("||");
                        captions.append("||");
                    }
                    first = false;
                    sb.append(Escape.escape(ms[i].getUniqueName())).append(ms[i].isLeaf() ? "1" : "0").append(ms[i].getDepth() == 0 ? "1" : "0");
                    captions.append(Escape.escape(ms[i].getCaption()));
                }
                String url = "uilayout.doDrillThrough('" + this.compId + "','" + sb.toString() + "','" + captions.toString() + "',event||window.event);";
                return url;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

