/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard;

import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.ajax.OlapModelManager;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoard;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardException;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DataSource;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.Dial;
import com.kingdee.bos.ctrl.analysis.web.session.DashBoardState;
import com.kingdee.bos.ctrl.analysis.web.session.UserSessionHelper;
import com.kingdee.bos.ctrl.analysis.web.solution.AbstractVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.ScriptSQL;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.variant.BaseVarProvider;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DashBoardPage {
    private String pageId;
    private DashBoard board;
    private Map map;
    private OlapModelManager olapModelManager;
    private Map dsMap;
    private BaseVarProvider varProvider;
    private static final Logger logger = CommonLogger.getLogger(DashBoardPage.class);

    DashBoardPage(String pageId, DashBoard board) {
        this.pageId = pageId;
        this.board = board;
        this.olapModelManager = new OlapModelManager();
    }

    public AbstractVarProvider getVarProvider() {
        return this.varProvider;
    }

    JSON init(HttpServletRequest request) throws DashBoardException {
        this.createVarProvider(request);
        this.createDatasource();
        this.createDial(request);
        String caption = request.getParameter("caption");
        if (caption != null) {
            HttpSession session = UserSessionHelper.getUserSession(request);
            Set set = (Set)session.getAttribute("lastDashboardSet");
            String queryString = request.getQueryString();
            set.add(new DashBoardState(caption, request.getRequestURI() + "?" + queryString.substring(0, queryString.indexOf("&caption"))));
        }
        String layoutInfo = this.board.getLayoutInfo();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("layoutTable", layoutInfo);
        map.put("pageId", this.pageId);
        map.put("url", request.getContextPath() + "/" + Constants.SERVLET_URL);
        map.put("servletType", "BIDashBoard");
        map.put("urlSeparator", "\u0001");
        map.put("background", this.board.getBackgroundInfo());
        map.put("dials", this.initAllDials(request));
        map.put("dbheight", this.board.getDashBoardHeight());
        String script = this.board.getPageScript();
        if (script != null) {
            script = this.transSystemVar(script);
            map.put("pageScript", script);
        }
        map.put("datasources", new ArrayList(this.dsMap.keySet()));
        return new JSONMap(map);
    }

    public static String getDashBoradHeight(String xml) {
        int height = 0;
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Element root = doc.getRootElement();
            Element table = root.element("Layout").element("Table").element("TBody");
            List rows = table.elements("TR");
            for (int i = 0; i < rows.size(); ++i) {
                Element e = (Element)rows.get(i);
                int h = (int)Math.floor(Float.parseFloat(e.attributeValue("height")));
                height += h;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(height);
    }

    public Dial getDial(String id) {
        return (Dial)this.map.get(id);
    }

    public DataSource getDataSource(String dsId) {
        return (DataSource)this.dsMap.get(dsId);
    }

    public OlapModelManager getOlapModelManager() {
        return this.olapModelManager;
    }

    private void createDial(HttpServletRequest request) throws DashBoardException {
        this.map = new HashMap();
        List list = this.board.getDials(this, request);
        for (Dial dial : list) {
            this.setSystemVarValue(dial);
            this.map.put(dial.getId(), dial);
        }
    }

    private void setSystemVarValue(Dial dial) {
        String valueParse = dial.getScript();
        String scriptValue = "";
        String startScript = "";
        String endScript = "";
        try {
            if (valueParse != null && valueParse.trim().length() > 0) {
                int startIndex = valueParse.indexOf("{");
                int endIndex = valueParse.lastIndexOf("}");
                startScript = valueParse.substring(0, startIndex + 1);
                endScript = valueParse.substring(endIndex, valueParse.length());
                valueParse = valueParse.substring(startIndex + 1, endIndex);
                scriptValue = new ScriptSQL().transSql(valueParse, (AbstractVarProvider)this.varProvider, null, null);
                dial.setScript(startScript + scriptValue + endScript);
            }
        }
        catch (BIReportException e) {
            e.printStackTrace();
        }
    }

    private String transSystemVar(String script) {
        String scriptValue = "";
        try {
            String startScript = "";
            String endScript = "});";
            String valueParse = "";
            int startIndex = script.indexOf("{");
            int endIndex = script.lastIndexOf("}");
            startScript = script.substring(0, startIndex + 1);
            valueParse = script.substring(startIndex + 1, endIndex);
            scriptValue = new ScriptSQL().transSql(valueParse, (AbstractVarProvider)this.varProvider, null, null);
            scriptValue = startScript + scriptValue + endScript;
        }
        catch (BIReportException e) {
            e.printStackTrace();
        }
        return scriptValue;
    }

    private void createDatasource() {
        this.dsMap = new HashMap();
        for (DataSource ds : this.board.getDataSources()) {
            this.dsMap.put(ds.getId(), ds);
        }
    }

    private List initAllDials(HttpServletRequest request) throws DashBoardException {
        ArrayList<Object> dialList = new ArrayList<Object>();
        Iterator it = this.map.keySet().iterator();
        while (it.hasNext()) {
            Dial dial = (Dial)this.map.get(it.next());
            try {
                dialList.add(dial.getClass().getMethod("init", HttpServletRequest.class).invoke((Object)dial, request));
            }
            catch (Exception e) {
                InvocationTargetException reflectE;
                Throwable biReportE;
                logger.warn((Object)e.getMessage(), (Throwable)e);
                if (e instanceof InvocationTargetException && (biReportE = (reflectE = (InvocationTargetException)e).getTargetException()) instanceof BIReportException) {
                    throw new DashBoardException(biReportE.getMessage());
                }
                throw new DashBoardException(" \u5bf9\u8c61[" + dial.getName() + "]\u5b9a\u4e49\u6709\u8bef,\u6570\u636e\u6e90\u53ef\u80fd\u5df2\u88ab\u4fee\u6539,\u8bf7\u91cd\u65b0\u5b9a\u4e49!");
            }
        }
        return dialList;
    }

    private void createVarProvider(HttpServletRequest request) throws DashBoardException {
        try {
            this.varProvider = new BaseVarProvider(BISystem.getContext(request));
        }
        catch (BIReportException e) {
            throw new DashBoardException(e);
        }
    }
}

