/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.export;

import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONString;
import com.kingdee.bos.ctrl.analysis.web.export.ExportType;
import com.kingdee.bos.ctrl.analysis.web.export.ExportTypeNotFoundException;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.util.IDGenerator;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.olap.util.ByteArrayOutputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class DashboardExportImport {
    private static final String PROPERTY_JAVA_IO_TMPDIR = "java.io.tmpdir";

    public static File createTempDashboardFile() throws IOException, ExportTypeNotFoundException {
        String exportType = "zip";
        String tempDirName = System.getProperty(PROPERTY_JAVA_IO_TMPDIR);
        if (tempDirName == null) {
            throw new RuntimeException("Temporary directory system property (java.io.tmpdir) is null.");
        }
        File tempDir = new File(tempDirName);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        String prefix = "Dashboard";
        File tempFile = null;
        tempFile = File.createTempFile(prefix, "." + ExportType.findFileSuffix(exportType), new File(System.getProperty(PROPERTY_JAVA_IO_TMPDIR)));
        return tempFile;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String exportDashboard(Repository rep, HttpServletRequest request, String paths) throws RepositoryException {
        String string;
        String[] fullpaths = paths.split("\\|");
        File exportFile = null;
        ZipOutputStream out = null;
        try {
            exportFile = DashboardExportImport.createTempDashboardFile();
            out = new ZipOutputStream((OutputStream)new FileOutputStream(exportFile));
            out.setEncoding("gb2312");
            DashboardExportImport.zip(out, null, fullpaths, rep);
            out.flush();
            string = request.getContextPath() + "/" + Constants.SERVLET_URL + "?" + "servletType" + "=" + "export" + "&" + "exportType" + "=zip&" + "filename" + "=" + exportFile.getName();
        }
        catch (ExportTypeNotFoundException e) {
            try {
                throw new RepositoryException(e);
                catch (IOException e2) {
                    throw new RepositoryException(e2);
                }
                catch (Exception e3) {
                    throw new RepositoryException(e3);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{out});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{out});
        return string;
    }

    private static void zip(ZipOutputStream out, String baseName, String[] fullpaths, Repository rep) throws Exception {
        String prix = "/dashboard_tree";
        int len = fullpaths.length;
        for (int i = 0; i < len; ++i) {
            String caption;
            String baseName2;
            if (!fullpaths[i].startsWith(prix)) {
                fullpaths[i] = prix + fullpaths[i];
            }
            boolean isFolder = rep.isFolder("DBD", fullpaths[i]);
            String string = baseName2 = baseName == null ? "" : baseName + "/";
            if (!isFolder) {
                caption = rep.getDashboardCaption(fullpaths[i]);
                byte[] content = rep.getNodeBinaryData("DBD", fullpaths[i]);
                DashboardExportImport.zip(out, baseName2 + caption, content);
                continue;
            }
            caption = rep.getNodePropertyByPath("DBD", fullpaths[i], "caption");
            out.putNextEntry(new ZipEntry(baseName2 + caption + "/"));
            List listFullpaths2 = rep.getNodeChildrenPaths("DBD", fullpaths[i]);
            String[] fullpaths2 = new String[listFullpaths2.size()];
            listFullpaths2.toArray(fullpaths2);
            DashboardExportImport.zip(out, baseName2 + caption, fullpaths2, rep);
        }
    }

    private static void zip(ZipOutputStream out, String baseName, byte[] content) throws Exception {
        out.putNextEntry(new ZipEntry(baseName));
        String xml = new String(content, "UTF-8");
        out.write(xml.getBytes("gb2312"));
        out.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSON importDashboard(Map map, HttpServletRequest request) throws BIReportException {
        JSONString jSONString;
        String parent = (String)map.get("savePath");
        String overwrite = (String)map.get("isOverwrite");
        String filename = (String)map.get("MultipartFileName");
        byte[] data = (byte[])map.get("MultipartByte");
        ZipFile zipFile = null;
        Repository rep = BISystem.getRepository(request);
        Node root = Node.createRoot(parent);
        try {
            Node node;
            File file = DashboardExportImport.createTempDashboardFile();
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                fos.write(data);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fos});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{fos});
            zipFile = new ZipFile(file, "gb2312");
            Enumeration enumeration = zipFile.getEntries();
            ZipEntry zipEntry = null;
            byte[] buffer = new byte[1024];
            while (enumeration.hasMoreElements()) {
                zipEntry = (ZipEntry)enumeration.nextElement();
                String name = zipEntry.getName();
                if ("".equals(name)) continue;
                if (zipEntry.isDirectory()) {
                    root.addPathNode(name, true, null);
                    continue;
                }
                BufferedOutputStream bos = null;
                try {
                    int len;
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    bos = new BufferedOutputStream((OutputStream)baos);
                    while ((len = inputStream.read(buffer)) > 0) {
                        bos.write(buffer, 0, len);
                    }
                    bos.flush();
                    String content = baos.toString("gb2312");
                    root.addPathNode(name, false, content);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{bos});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{bos});
            }
            if (root.children == null) {
                throw new BIReportException("\u5bfc\u5165\u6587\u4ef6\u4e3a\u7a7a.");
            }
            String user = BISystem.getCurrentUser(request);
            String cu = BISystem.getCurrentCU(request);
            LinkedList<Node> todoList = new LinkedList<Node>();
            ArrayList<Node> ignoreList = new ArrayList<Node>();
            ArrayList<String> ignoreMessage = new ArrayList<String>();
            ArrayList<Node> errorList = new ArrayList<Node>();
            ArrayList<Node> succeedList = new ArrayList<Node>();
            ArrayList<Node> succeedDirList = new ArrayList<Node>();
            todoList.add(root);
            while (todoList.size() > 0) {
                int i;
                Node todo = (Node)todoList.removeFirst();
                Node[] children = todo.getChildren();
                if (children == null) continue;
                String parentPath = todo.fullpath;
                String[] captions = new String[children.length];
                for (int i2 = 0; i2 < captions.length; ++i2) {
                    captions[i2] = children[i2].name;
                }
                String[][] pf = rep.findDashboardPaths(parentPath, captions);
                String[] childrenPaths = pf[0];
                String[] childrenCaptions = pf[1];
                String[] isFolders = pf[2];
                if (childrenPaths != null && childrenPaths.length > 0) {
                    for (i = 0; i < childrenPaths.length; ++i) {
                        Node node2 = DashboardExportImport.findNodeByCaption(todo.children, childrenCaptions[i]);
                        node2.fullpath = node2.parent.fullpath + "/" + childrenPaths[i];
                        if (!"true".equals(overwrite)) {
                            ignoreList.add(node2);
                            ignoreMessage.add("\u5ffd\u7565\"" + node2.getFullName() + "\",\u5b58\u5728\u540c\u540d" + (isFolders[i].equals("true") ? "\u76ee\u5f55" : "\u4eea\u8868\u677f"));
                            continue;
                        }
                        if (node2.isFolder && isFolders[i].equals("false")) {
                            ignoreList.add(node2);
                            ignoreMessage.add("\u5ffd\u7565\"" + node2.getFullName() + "\",\u662f\u76ee\u5f55\u4f46\u5b58\u5728\u540c\u540d\u4eea\u8868\u677f");
                            continue;
                        }
                        if (!node2.isFolder && isFolders[i].equals("true")) {
                            ignoreList.add(node2);
                            ignoreMessage.add("\u5ffd\u7565\"" + node2.getFullName() + "\",\u662f\u6587\u4ef6\u4f46\u5b58\u5728\u540c\u540d\u76ee\u5f55");
                            continue;
                        }
                        if (node2.isFolder) {
                            ignoreList.add(node2);
                            todoList.add(node2);
                            continue;
                        }
                        try {
                            String parentPath2 = parentPath;
                            if (parentPath2.startsWith("/")) {
                                parentPath2 = parentPath2.substring(1);
                            }
                            rep.saveDashboard(parentPath2, childrenCaptions[i], childrenPaths[i], node2.content, user, cu);
                            succeedList.add(node2);
                            continue;
                        }
                        catch (Exception e) {
                            errorList.add(node2);
                            ignoreMessage.add(node2.getFullName() + "\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
                        }
                    }
                }
                for (i = 0; i < children.length; ++i) {
                    Node child = children[i];
                    if (ignoreList.contains(child) || errorList.contains(child) || succeedList.contains(child)) continue;
                    if (child.isFolder) {
                        try {
                            String dirName = "DIR" + IDGenerator.getUUID();
                            String parentPath2 = parentPath;
                            if (parentPath2.startsWith("/")) {
                                parentPath2 = parentPath2.substring(1);
                            }
                            rep.addNewDirectory(parentPath2, child.name, dirName, 5, user, cu);
                            child.fullpath = child.parent.fullpath + "/" + dirName;
                            if (!todoList.contains(child)) {
                                todoList.add(child);
                            }
                            succeedDirList.add(child);
                        }
                        catch (Exception e) {
                            errorList.add(child);
                            ignoreMessage.add("\u76ee\u5f55" + child.getFullName() + "\u4fdd\u5b58\u5931\u8d25\uff0c\u5ffd\u7565\u5176\u5b50\u76ee\u5f55\uff0c\u539f\u56e0\u662f:" + e.getMessage());
                        }
                        continue;
                    }
                    try {
                        String dashboardName = "DASHBOARD" + IDGenerator.getUUID();
                        rep.saveDashboard(parentPath, child.name, dashboardName, child.content, user, cu);
                        child.fullpath = child.parent.fullpath + "/" + dashboardName;
                        succeedList.add(child);
                        continue;
                    }
                    catch (Exception e) {
                        errorList.add(child);
                        ignoreMessage.add(child.getFullName() + "\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
                    }
                }
            }
            StringBuffer message = new StringBuffer();
            if (succeedList.size() > 0) {
                message.append("\u6210\u529f\u5bfc\u5165\u4eea\u8868\u677f").append(succeedList.size()).append("\u4e2a:||||");
                for (int i = 0; i < succeedList.size(); ++i) {
                    node = (Node)succeedList.get(i);
                    message.append(node.getFullName());
                    message.append("||||");
                }
            }
            if (succeedDirList.size() > 0) {
                message.append("\u6dfb\u52a0\u76ee\u5f55").append(succeedDirList.size()).append("\u4e2a:||||");
                for (int i = 0; i < succeedDirList.size(); ++i) {
                    node = (Node)succeedDirList.get(i);
                    message.append(node.getFullName());
                    message.append("||||");
                }
            }
            if (ignoreMessage.size() > 0) {
                message.append("\u5ffd\u7565\u6216\u9519\u8bef\u5171").append(ignoreMessage.size());
                message.append("\u4e2a:||||");
                for (int i = 0; i < ignoreMessage.size(); ++i) {
                    message.append(ignoreMessage.get(i));
                    message.append("||||");
                }
            }
            jSONString = new JSONString(message.toString());
        }
        catch (IOException e) {
            try {
                throw new BIReportException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{zipFile});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{zipFile});
        return jSONString;
    }

    private static Node findNodeByCaption(ArrayList children, String caption) {
        for (Node child : children) {
            if (!child.name.equals(caption)) continue;
            return child;
        }
        return null;
    }

    static class Node {
        boolean isRoot;
        String rootpath;
        boolean isFolder;
        boolean isNew;
        String name;
        String content;
        ArrayList children;
        Node parent;
        Node root;
        int depth;
        String fullpath;

        Node() {
        }

        public static Node createRoot(String rootpath) {
            Node root = new Node();
            root.isRoot = true;
            root.rootpath = rootpath;
            root.fullpath = rootpath;
            root.root = root;
            return root;
        }

        public Node addPathNode(String path, boolean isFolder, String content) {
            if (this.root.rootpath != null && !"".equals(this.root.rootpath)) {
                path = path.substring(path.indexOf(this.root.rootpath) + 1);
            }
            String[] paths = path.split("\\/");
            Node node = this.root;
            for (int i = 0; i < paths.length - 1; ++i) {
                Node child = node.getChild(paths[i]);
                node = child == null ? node.addChild(true, paths[i], null) : child;
            }
            if (isFolder) {
                Node child = node.getChild(paths[paths.length - 1]);
                if (child == null) {
                    return node.addChild(true, paths[paths.length - 1], null);
                }
                return child;
            }
            return node.addChild(false, paths[paths.length - 1], content);
        }

        public Node addChild(boolean isFolder, String name, String content) {
            Node child = new Node();
            child.isFolder = isFolder;
            child.name = name;
            child.content = content;
            return this.addChild(child);
        }

        public Node addChild(Node child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
            child.depth = this.depth + 1;
            child.parent = this;
            child.root = this.root;
            return child;
        }

        public int getChildCount() {
            if (this.children == null) {
                return 0;
            }
            return this.children.size();
        }

        public Node getChild(String name) {
            if (this.children == null) {
                return null;
            }
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                Node child = (Node)this.children.get(i);
                if (!name.equals(child.name)) continue;
                return child;
            }
            return null;
        }

        public Node[] getChildren() {
            if (this.children == null) {
                return null;
            }
            Node[] nodes = new Node[this.children.size()];
            this.children.toArray(nodes);
            return nodes;
        }

        public String getFullName() {
            String fullName = this.name;
            Node p = this.parent;
            if (p != this.root) {
                String parentFullName = p.getFullName();
                fullName = (parentFullName == null ? "" : parentFullName) + "/" + this.name;
            }
            return fullName;
        }
    }
}

