/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ext;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.ajax.ReportPage;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtReport;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.lic.EXTLicenseAgent;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.lic.ExtLicenseException;
import com.kingdee.bos.ctrl.analysis.web.session.ThemeAnalysisReportState;
import com.kingdee.bos.ctrl.analysis.web.session.UserSessionHelper;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.json.JSONObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class ExtReportPage
extends ReportPage {
    private boolean isSkipRepository = false;
    private String extid;
    private Context _ctx;
    private Logger _log = CommonLogger.getLogger(ExtReportPage.class);
    private String _reportID;

    public ExtReportPage(String pageId, ExtReport extReport) {
        super(pageId, "ext", extReport);
        this.access();
    }

    public ExtReport getExtReport() {
        return (ExtReport)super.getReport();
    }

    @Override
    protected String generateUI(HttpServletRequest request) throws BIReportException {
        this._ctx = BISystem.getContext(request);
        StringBuffer sb = new StringBuffer();
        if (this.getExtReport().hasFilter(request)) {
            sb.append("filter:");
            ExtReportPage.createUIOInfo(this.uioManager.createFilterUIO(this.getExtReport().getFilter(request)), sb);
            sb.append("~~");
        }
        sb.append("\u6269\u5c55\u62a5\u8868\u65b9\u6848::");
        sb.append("\u6807\u9898::");
        sb.append("\u8868\u5934::");
        sb.append("\u8868\u5c3e::");
        sb.append("\u65b9\u6848\u540d::");
        ExtReportPage.createUIOInfo(this.uioManager.createExtWorksheetUIO(this), sb);
        return sb.toString();
    }

    @Override
    public boolean canUseRepository() {
        return !this.isSkipRepository;
    }

    public void skipRepository() {
        this.isSkipRepository = true;
    }

    public String getExtID() {
        return this.extid;
    }

    public void setExtID(String extId) {
        this.extid = extId;
    }

    @Override
    public void close() {
        if (this._ctx != null) {
            EXTLicenseAgent agent = new EXTLicenseAgent(null, this._ctx);
            try {
                agent.releaseLicense(this._reportID);
            }
            catch (ExtLicenseException e) {
                this._log.error((Object)"EXT:\u91ca\u653eLicense\u5931\u8d25", (Throwable)e);
            }
        }
        super.close();
    }

    public String getReportID() {
        return this._reportID;
    }

    public void setReportID(String reportID) {
        this._reportID = reportID;
    }

    @Override
    public String init(HttpServletRequest request) throws BIReportException {
        String caption = request.getParameter("caption");
        if (caption != null) {
            HttpSession session = UserSessionHelper.getUserSession(request);
            Set set = (Set)session.getAttribute("lastReportSet");
            String queryString = request.getQueryString();
            String from = request.getParameter("from");
            String url = request.getRequestURI() + "?" + queryString.substring(0, queryString.indexOf("&caption"));
            ThemeAnalysisReportState o = new ThemeAnalysisReportState(caption, url, from);
            Iterator it = set.iterator();
            ThemeAnalysisReportState temp = null;
            while (it.hasNext()) {
                temp = (ThemeAnalysisReportState)it.next();
                if (null == temp.getFrom() || !temp.getFrom().equals(from)) continue;
                if (temp.getUrl().equals(url)) {
                    temp.setSelected(true);
                    o = null;
                    continue;
                }
                temp.setSelected(false);
            }
            if (o != null) {
                set.add(o);
            }
        }
        this._ctx = BISystem.getContext(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageId", this.pageId + "");
        map.put("url", request.getContextPath() + "/" + Constants.SERVLET_URL);
        ExtReport report = this.getExtReport();
        map.put("hasFilter", new Boolean(report.hasFilter(request)));
        map.put("isHideMenubarInReport", report.isHideMenubarInReport(this._ctx));
        map.put("isFullScreen", report.isFullScreen(this._ctx));
        map.put("isPopFilter", report.isPopFilter(this._ctx));
        boolean isAccredited = report.isAccredited(this._ctx);
        boolean isModifiedTemplate = report.isModifiedTemplate(this._ctx);
        String cloudRptUuid = report.getCloudRptId(this._ctx);
        boolean isOriginalCloudRpt = !StringUtil.isEmptyString((String)cloudRptUuid) && !isAccredited && !isModifiedTemplate;
        map.put("isNeedFill", isOriginalCloudRpt ? false : new Boolean(report.isParamsNeedFill()));
        String hasExportPermissionString = request.getParameter("OriginPermission");
        Boolean hasExportPermission = false;
        if (hasExportPermissionString == null || "".equals(hasExportPermissionString)) {
            try {
                hasExportPermission = (Boolean)Class.forName("com.kingdee.eas.rpts.ctrlreport.bo.PermissionBO").getMethod("hasDataPermissionByReportId", Context.class, String.class, String.class, String.class, Class.forName("com.kingdee.eas.rpts.ctrlreport.data.PermissionKind")).invoke(null, BISystem.getContext(request), BISystem.getCurrentUser(request), BISystem.getCurrentOrgUnitID(request), this._reportID, Class.forName("com.kingdee.eas.rpts.ctrlreport.data.PermissionKind").getField("EXPORT").get(null)) != false || Boolean.parseBoolean(request.getParameter("OriginPermission"));
            }
            catch (Exception e) {
                this._log.info((Object)"\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u62a5\u8868\u6743\u9650\u5931\u8d25", (Throwable)e);
            }
        } else {
            hasExportPermission = Boolean.parseBoolean(hasExportPermissionString);
        }
        map.put("hasExportPermission", hasExportPermission);
        String hasPrintPermissonString = request.getParameter("OriginPrintPermission");
        boolean hasPrintPermission = false;
        if (null == hasPrintPermissonString || "".equals(hasPrintPermissonString)) {
            try {
                hasPrintPermission = (Boolean)Class.forName("com.kingdee.eas.rpts.ctrlreport.bo.PermissionBO").getMethod("hasDataPermissionByReportId", Context.class, String.class, String.class, String.class, Class.forName("com.kingdee.eas.rpts.ctrlreport.data.PermissionKind")).invoke(null, BISystem.getContext(request), BISystem.getCurrentUser(request), BISystem.getCurrentOrgUnitID(request), this._reportID, Class.forName("com.kingdee.eas.rpts.ctrlreport.data.PermissionKind").getField("PRINT").get(null)) != false || Boolean.parseBoolean(request.getParameter("OriginPrintPermission"));
            }
            catch (Exception e) {
                this._log.info((Object)("\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u62a5\u8868\u6743\u9650\u5931\u8d25\uff1a" + e));
            }
        } else {
            hasPrintPermission = Boolean.parseBoolean(hasPrintPermissonString);
        }
        map.put("hasDataSet", report.hasDataSet(this._ctx));
        map.put("hasPrintPermission", hasPrintPermission);
        map.put("isCloudRptCenterEnable", report.isCloudRptCenterEnable(this._ctx));
        map.put("cloudRptId", cloudRptUuid);
        map.put("isAccredited", isAccredited);
        map.put("isModifiedTemplate", isModifiedTemplate);
        map.put("rptName", report.getRptName(this._ctx));
        map.put("repositoryPath", report.getRepositoryPath());
        return new JSONObject(map).toString();
    }
}

