/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ext.mp.dao;

import com.kingdee.bos.ctrl.analysis.web.ext.mp.vo.MyFolderNodeVO;
import com.kingdee.bos.ctrl.analysis.web.ext.util.JDBCUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class MyFolderTreeDAO {
    private static final Logger logger = CommonLogger.getLogger(MyFolderTreeDAO.class);

    public ArrayList getChildsByParent(String pid, HttpServletRequest request) throws BIReportException {
        ArrayList<MyFolderNodeVO> arrayList;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rset = null;
        try {
            conn = BISystem.getJdbcConnection(request);
            String sql = "select t.fid as id,t.fname_l2 as name,t.fpid as pid,t.flevel as lev,t.fleaf as leaf,t.flongnumber as longNumber from t_ext_foldernode t where t.fpid=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, pid);
            rset = pstmt.executeQuery();
            ArrayList<MyFolderNodeVO> list = new ArrayList<MyFolderNodeVO>();
            while (rset.next()) {
                MyFolderNodeVO node = new MyFolderNodeVO();
                node.setId(rset.getString("id"));
                node.setPid(rset.getString("pid"));
                node.setLevel(rset.getInt("lev"));
                node.setName(rset.getString("name"));
                node.setLeaf(rset.getInt("leaf") == 0);
                node.setLongNumber(rset.getString("longNumber"));
                list.add(node);
            }
            arrayList = list;
        }
        catch (SQLException e) {
            try {
                throw new BIReportException(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rset, pstmt, conn);
                throw throwable;
            }
        }
        JDBCUtil.close(rset, pstmt, conn);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isNameExist(Connection connection, MyFolderNodeVO params) throws SQLException {
        boolean bl;
        ResultSet rs;
        PreparedStatement pstmt;
        block6: {
            boolean bl2;
            Connection conn = null;
            pstmt = null;
            rs = null;
            try {
                conn = connection;
                String sql = "select count(*) as exist from t_ext_foldernode t where t.forgid =? and t.fcreatorid =? and t.fname_l2=? and t.flevel = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, params.getOrgId());
                pstmt.setString(2, params.getCreatorId());
                pstmt.setString(3, params.getName());
                pstmt.setInt(4, params.getLevel());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int count = rs.getInt("exist");
                    if (count != 0) continue;
                    bl = false;
                    break block6;
                }
                bl2 = true;
            }
            catch (SQLException e) {
                try {
                    logger.warn((Object)"\u67e5\u8be2\u6587\u4ef6\u540d\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    JDBCUtil.close(rs, pstmt);
                    throw throwable;
                }
            }
            JDBCUtil.close(rs, pstmt);
            return bl2;
        }
        JDBCUtil.close(rs, pstmt);
        return bl;
    }

    public MyFolderNodeVO buildMyFolderTree(Connection connection, MyFolderNodeVO params) throws SQLException {
        MyFolderNodeVO myFolderNodeVO;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = connection;
            String sql = "select t.fid as id,t.fname_l2 as name,t.fpid as pid,t.flevel as lev,t.fleaf as leaf,t.flongnumber as longNumber from t_ext_foldernode t where t.forgid =? and t.fcreatorid =?  order by t.flevel asc,t.fcreatetime desc";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, params.getOrgId());
            pstmt.setString(2, params.getCreatorId());
            rs = pstmt.executeQuery();
            HashMap<String, MyFolderNodeVO> cache = new HashMap<String, MyFolderNodeVO>();
            MyFolderNodeVO folderRoot = new MyFolderNodeVO();
            folderRoot.setId("MyFolderRoot");
            folderRoot.setPid("MyFolderRoot");
            folderRoot.setNodeType(3);
            cache.put("MyFolderRoot", folderRoot);
            while (rs.next()) {
                MyFolderNodeVO node = new MyFolderNodeVO();
                String id = rs.getString("id");
                node.setId(id);
                String pid = rs.getString("pid");
                node.setPid(pid);
                node.setName(rs.getString("name"));
                node.setLevel(rs.getInt("lev"));
                node.setLeaf(rs.getInt("leaf") == 1);
                node.setLongNumber(rs.getString("longNumber"));
                node.setNodeType(3);
                cache.put(id, node);
                if (!cache.containsKey(pid)) continue;
                MyFolderNodeVO pNode = (MyFolderNodeVO)cache.get(pid);
                pNode.addChild(node);
            }
            myFolderNodeVO = folderRoot;
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)"\u6784\u5efa\u6211\u7684\u6587\u4ef6\u5939\u6811\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, pstmt);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, pstmt);
        return myFolderNodeVO;
    }

    public void insertMyFolderNode(Connection connection, MyFolderNodeVO node) throws SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = connection;
            String sql = "insert into t_ext_folderNode(fid,fname_l2,fpid,flevel,fleaf,fcreatorid,forgid,flongnumber,fcreatetime)values(?,?,?,?,?,?,?,?,?)";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, node.getId());
            pstmt.setString(2, node.getName());
            pstmt.setString(3, node.getPid());
            pstmt.setInt(4, node.getLevel());
            pstmt.setInt(5, 0);
            pstmt.setString(6, node.getCreatorId());
            pstmt.setString(7, node.getOrgId());
            pstmt.setString(8, node.getLongNumber());
            pstmt.setTimestamp(9, new Timestamp(node.getCreateTime().getTime()));
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)"\u589e\u52a0\u6211\u7684\u6587\u4ef6\u5939\u8282\u70b9\u64cd\u4f5c", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(null, pstmt, null);
                throw throwable;
            }
        }
        JDBCUtil.close(null, pstmt, null);
    }

    public MyFolderNodeVO updateFolderName(Connection connection, MyFolderNodeVO node) throws SQLException {
        MyFolderNodeVO myFolderNodeVO;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = connection;
            String sql = "update t_ext_folderNode  set fname_l2=? ,fmodifiedTime=? where fid=? and forgid=? and fcreatorid=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, node.getName());
            pstmt.setDate(2, new Date(node.getModifiedTime().getTime()));
            pstmt.setString(3, node.getId());
            pstmt.setString(4, node.getOrgId());
            pstmt.setString(5, node.getCreatorId());
            pstmt.execute();
            myFolderNodeVO = node;
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)"\u6784\u5efa\u6211\u7684\u6587\u4ef6\u5939\u6811\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.close(pstmt);
        return myFolderNodeVO;
    }

    public void updateNode(MyFolderNodeVO node) {
    }

    public void deleteFolderNode(Connection connection, MyFolderNodeVO pVO) throws SQLException {
        if (pVO.isLeaf()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = connection;
            String sql = "delete from t_ext_folderNode  where forgid=? and (charindex(flongNumber,?)>0  or charindex(?,flongNumber)>0)  and fcreatorid=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(2, pVO.getId());
            pstmt.setString(3, pVO.getId());
            pstmt.setString(1, pVO.getOrgId());
            pstmt.setString(4, pVO.getCreatorId());
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)"\u5220\u9664\u6211\u7684\u6587\u4ef6\u5939\u6811\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.close(pstmt);
    }
}

