/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.kpimonitor;

import com.kingdee.bos.ctrl.analysis.web.ajax.PageManager;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardException;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.KPIMonitorDial;
import com.kingdee.bos.ctrl.analysis.web.kpimonitor.IKPIMonitor;
import com.kingdee.bos.ctrl.analysis.web.kpimonitor.KPIMonitorPage;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.util.IDGenerator;
import com.kingdee.bos.ctrl.analysis.web.solution.util.StringEncodeUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class KPIMonitorSerlvetHandler {
    private static final Logger log = CommonLogger.getLogger(KPIMonitorSerlvetHandler.class);

    public static JSON handle(HttpServletRequest request, HttpServletResponse response) throws BIReportException {
        JSON ret = null;
        KPIMonitorPage page = null;
        KPIMonitorDial kpiMonitorDial = null;
        String id = "kpiMonitor";
        String uiid = request.getParameter("uiid");
        String pageId = request.getParameter("pageId");
        String command = request.getParameter("command");
        String kpiMonitorId = request.getParameter("kpiMonitorId");
        kpiMonitorId = kpiMonitorId == null ? kpiMonitorId : StringEncodeUtil.decode(kpiMonitorId);
        String monitorType = request.getParameter("kpiMonitorType");
        String showType = request.getParameter("showType");
        if (StringUtils.isEmpty((String)pageId)) {
            page = (KPIMonitorPage)PageManager.createPage("kpiMonitor", request, response);
            uiid = IDGenerator.getID();
            pageId = page.getPageId();
            String name = "\u6307\u6807\u76d1\u63a7";
            String title = "\u6307\u6807\u76d1\u63a7";
            boolean showTitle = false;
            int compWidth = 240;
            int compHeight = 160;
            String autoWrap = request.getParameter("autoWrap");
            String showList = request.getParameter("showList");
            String servletUrl = request.getParameter("url");
            String servletType = request.getParameter("servletType");
            try {
                compWidth = Integer.parseInt(request.getParameter("compWidth"));
                compHeight = Integer.parseInt(request.getParameter("compHeight"));
            }
            catch (NumberFormatException e) {
                log.error((Object)("\u6307\u6807\u76d1\u63a7\u5355\u4e2a\u7ec4\u4ef6\u7684\u9ad8\u5ea6\u6216\u5bbd\u5ea6\u53ea\u80fd\u662f\u5927\u4e8e0\u7684\u6574\u6570\uff01\u5bbd\u5ea6\u3010" + request.getParameter("compWidth") + "\u3011\uff0c\u9ad8\u5ea6\u3010" + request.getParameter("compHeight") + "\u3011\uff1a" + e.getMessage()));
            }
            HashMap<String, String> baseInfoMap = new HashMap<String, String>();
            baseInfoMap.put("id", id);
            baseInfoMap.put("name", name);
            baseInfoMap.put("title", title);
            baseInfoMap.put("showTitle", Boolean.toString(showTitle));
            baseInfoMap.put("uiid", uiid);
            baseInfoMap.put("pageId", pageId);
            baseInfoMap.put("kpiMonitorId", kpiMonitorId);
            baseInfoMap.put("metricAutoFlow", autoWrap);
            baseInfoMap.put("metricWidth", Integer.toString(compWidth));
            baseInfoMap.put("metricHeight", Integer.toString(compHeight));
            baseInfoMap.put("monitorType", monitorType);
            baseInfoMap.put("command", command);
            baseInfoMap.put("showList", showList);
            baseInfoMap.put("servletUrl", servletUrl);
            baseInfoMap.put("servletType", servletType);
            baseInfoMap.put("showType", showType);
            kpiMonitorDial = new KPIMonitorDial(id, baseInfoMap);
            kpiMonitorDial.createKPIMonitorInstance(request);
            IKPIMonitor kpiMonitor = kpiMonitorDial.getKpiMonitor();
            String[] types = kpiMonitor.enumTypes();
            if (types != null) {
                int n = types.length;
                for (int i = 0; i < n; ++i) {
                    String[] values = new String[]{request.getParameter(types[i])};
                    kpiMonitor.setCondition(request, types[i], values);
                }
            }
            page.setKPIMonitorDial(kpiMonitorDial);
            if (StringUtils.isEmpty((String)command)) {
                return kpiMonitorDial.init(request);
            }
        } else {
            page = (KPIMonitorPage)PageManager.getPage(pageId);
            kpiMonitorDial = page.getKPIMonitorDial();
        }
        if (command == null) {
            throw new BIReportException("\u6ca1\u6709\u6307\u5b9a\u8981\u6267\u884c\u7684\u6307\u4ee4!");
        }
        if ("close".equalsIgnoreCase(command)) {
            PageManager.close(pageId);
            return ret;
        }
        if ("ping".equalsIgnoreCase(command)) {
            PageManager.ping(pageId);
            return ret;
        }
        try {
            ret = (JSON)kpiMonitorDial.getClass().getDeclaredMethod(command, HttpServletRequest.class).invoke((Object)kpiMonitorDial, request);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            log.warn((Object)t.getMessage(), t);
            throw new DashBoardException(t);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            throw new DashBoardException(e);
        }
        return ret;
    }
}

