/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.repository;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.web.repository.IORMRPCBIJCRService;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryContext;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryImpl;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryRPCService;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;

public class RepositoryFactory {
    private static final String DEBUG_DATACENTER_NAME = "debug_datacenter";
    private static final String BIJCR_SERVER_LOCATION = "BIOLAP";
    private static Repository debugRepository = null;

    public static Repository createRepository(RepositoryContext ctx) throws BIReportException {
        boolean isDebug = (Boolean)ctx.get("DEBUG");
        String dataCenter = DEBUG_DATACENTER_NAME;
        String user = (String)ctx.get("CURRENT_USER");
        String cu = (String)ctx.get("CURRENT_CU");
        if (isDebug) {
            if (debugRepository == null) {
                debugRepository = new RepositoryImpl(dataCenter, user, cu, true);
            }
            return debugRepository;
        }
        dataCenter = (String)ctx.get("DATACENTER");
        String userNumber = (String)ctx.get("CURRENT_USER_NUMBER");
        return RepositoryFactory.getORMRPCBosObject(dataCenter, user, cu, userNumber);
    }

    private static String getORMRPCServerURL() throws BOSException {
        ORMServiceLocation loc = new ORMServiceLocation(BIJCR_SERVER_LOCATION);
        if (loc == null) {
            throw new BOSException("Invalidate config file! please make sure you have the config item about NetCtrl!");
        }
        try {
            return loc.getServiceURL();
        }
        catch (Exception err) {
            throw new BOSException("Invalidate config file! please make sure you have the config item about NetCtrl!", (Throwable)err);
        }
    }

    private static IORMRPCBIJCRService getORMRPCBosObject(String dataCenter, String user, String cu, String userNumber) throws BIReportException {
        String url = null;
        try {
            url = RepositoryFactory.getORMRPCServerURL();
        }
        catch (BOSException e) {
            throw new BIReportException("\u65e0\u6cd5\u83b7\u53d6\u5b58\u50a8\u8fdc\u7a0b\u670d\u52a1!", e);
        }
        LtpaToken token = LtpaTokenManager.generate((String)userNumber, (String)LtpaTokenManager.getDefaultLtpaConfig());
        String password = token.toString();
        RepositoryRPCService bosObject = null;
        bosObject = url == null || url.trim().equals("") || url.equalsIgnoreCase("tcp://127.0.0.1") ? new RepositoryRPCService(dataCenter, user, cu, true, password, userNumber) : RPCEngineFactory.getEngine((String)url).createObject(RepositoryRPCService.class.getName(), IORMRPCBIJCRService.class, new Class[]{String.class, String.class, String.class, String.class, String.class}, new Object[]{dataCenter, user, cu, password, userNumber});
        return bosObject;
    }
}

