/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.filter;

import java.util.Arrays;
import java.util.List;

public class Operator {
    public static final String LT = "LT";
    public static final String GT = "GT";
    public static final String EQ = "EQ";
    public static final String LE = "LE";
    public static final String GE = "GE";
    public static final String NE = "NE";
    public static final String BETWEEN = "BETWEEN";
    public static final String LIKE = "LIKE";
    public static final String IN = "IN";
    private static final String[] exprs = new String[]{"LT", "<", "GT", ">", "EQ", "=", "LE", "<=", "GE", ">=", "NE", "<>", "LIKE", "Like", "IN", "In"};
    private static final List exprList = Arrays.asList(exprs);

    private static String getExpr(String operator) {
        int index = exprList.indexOf(operator);
        if (index < 0) {
            return null;
        }
        return exprs[index + 1];
    }

    public static String getExpr(String column, Object value, String operator, String dataType) throws Exception {
        String opexpr = " " + Operator.getExpr(operator) + " ";
        if (opexpr == null) {
            throw new Exception("\u64cd\u4f5c\u7b26\u975e\u6cd5:" + operator);
        }
        StringBuffer expr = new StringBuffer(column).append(opexpr);
        String[] strValue = (String[])value;
        if (strValue == null || strValue.length <= 0) {
            throw new RuntimeException("Value is null or empty!");
        }
        if (operator.equalsIgnoreCase(IN)) {
            expr.append("(");
            for (int i = 0; i < strValue.length; ++i) {
                if (i > 0) {
                    expr.append(",");
                }
                Operator.appendValue(expr, strValue[i], dataType);
            }
            expr.append(")");
        } else {
            Operator.appendValue(expr, strValue[0], dataType);
        }
        return expr.toString();
    }

    private static void appendValue(StringBuffer expr, String value, String dataType) {
        if ("string".equalsIgnoreCase(dataType)) {
            expr.append("'").append(value).append("'");
        } else if ("number".equalsIgnoreCase(dataType)) {
            expr.append(value);
        } else if ("date".equalsIgnoreCase(dataType)) {
            expr.append("{").append(value).append("}");
        } else {
            throw new RuntimeException("TODO:Operator.getExpr");
        }
    }
}

