/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.filter;

import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterItem;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterValue;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.Operator;
import com.kingdee.bos.olap.util.IgnoreCaseString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PieceFilterValue
implements FilterValue {
    private BIReportFilter filterInfo;
    private Object[] params;
    Map conditionMap;
    List macroList = null;

    public PieceFilterValue(BIReport report, Object[] params) throws BIReportException {
        this.filterInfo = report.getFilter(null);
        this.params = params;
        this.makeMacroList();
        this.makeFilterConditions();
    }

    @Override
    public List getMacroList() {
        return this.macroList;
    }

    private Object getItemValue(BIReportFilterItem item, int index) {
        String[] value = null;
        List selectedValue = (List)this.params[index];
        if (selectedValue != null && selectedValue.size() > 0) {
            value = selectedValue.toArray(new String[0]);
        }
        return value;
    }

    private void makeMacroList() {
        this.macroList = new ArrayList();
        for (int i = 0; i < this.filterInfo.getItemCount(); ++i) {
            Object value;
            String[] arrayValue;
            BIReportFilterItem item = this.filterInfo.getItem(i);
            String macroName = item.getVarname();
            if (macroName == null || macroName.equals("") || (arrayValue = (String[])(value = this.getItemValue(item, i))) == null || arrayValue.length <= 0) continue;
            StringBuffer condition = new StringBuffer(macroName + "\u0001" + arrayValue[0]);
            for (int j = 1; j < arrayValue.length; ++j) {
                condition.append("\u0002");
                condition.append(arrayValue[j]);
            }
            this.macroList.add(condition.toString());
        }
    }

    @Override
    public Map getFilterConditions() {
        return this.conditionMap;
    }

    private void makeFilterConditions() throws BIReportException {
        this.conditionMap = new HashMap();
        for (int i = 0; i < this.filterInfo.getItemCount(); ++i) {
            try {
                BIReportFilterItem item = this.filterInfo.getItem(i);
                String columnExpr = item.getColumn();
                if (columnExpr == null || columnExpr.equals("")) continue;
                String[] tcs = this.splitTableColumn(columnExpr);
                String operator = item.getOperator();
                String dataType = item.getDataType();
                Object value = this.getItemValue(item, i);
                if (value == null) continue;
                for (int j = 0; j < tcs.length; ++j) {
                    String tableName = tcs[j];
                    String columnName = tcs[j + 1];
                    String condition = this.makeCondition(columnName, value, operator, dataType);
                    this.setTableConditions(tableName, condition, this.conditionMap);
                    ++j;
                }
                continue;
            }
            catch (Exception e) {
                throw new BIReportException(e);
            }
        }
    }

    private String makeCondition(String column, Object value, String operator, String dataType) throws Exception {
        return Operator.getExpr(column, value, operator, dataType);
    }

    private void setTableConditions(String tableName, String condition, Map map) {
        IgnoreCaseString tableNameIgnoreCase = new IgnoreCaseString(tableName);
        ArrayList<String> list = (ArrayList<String>)map.get(tableNameIgnoreCase);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(condition);
        map.put(tableNameIgnoreCase, list);
    }

    private String[] splitTableColumn(String columnExpr) throws Exception {
        String[] tokens = columnExpr.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < tokens.length; ++i) {
            String[] tc = tokens[i].split("\\.");
            if (tc.length != 2) {
                throw new Exception("Column:" + columnExpr + "\u683c\u5f0f\u4e0d\u5bf9\uff0c\u5fc5\u987b\u662fTable.column");
            }
            list.add(tc[0]);
            list.add(tc[1]);
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        return ret;
    }
}

