/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.variant;

import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.sql.SQLProvider;
import com.kingdee.bos.ctrl.analysis.web.variant.VariantManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class TextVariant {
    private VariantManager manager;
    private Pattern pattern = Pattern.compile("\\$\\{([\\w.]+)\\}\\$");

    public TextVariant(SQLProvider provider) {
        this.manager = new VariantManager(provider);
    }

    public void clear() {
        this.manager.clear();
    }

    public String parse(String text, HttpServletRequest req) throws BIReportException {
        String newText = "";
        Matcher m = this.pattern.matcher(text);
        int nStart = 0;
        while (m.find()) {
            newText = newText + text.substring(nStart, m.start());
            String sqlVariant = m.group();
            int nSeperator = (sqlVariant = sqlVariant.substring(2, sqlVariant.length() - 2)).indexOf(".");
            if (nSeperator == -1 || nSeperator == sqlVariant.length() - 1) {
                newText = newText + "${" + sqlVariant + "}$";
                nStart = m.end();
                continue;
            }
            String sql = sqlVariant.substring(0, nSeperator);
            String var = sqlVariant.substring(nSeperator + 1);
            String value = null;
            String error = "";
            try {
                value = (String)this.manager.getValue(sql, var, req);
            }
            catch (BIReportException e) {
                error = e.getMessage();
            }
            if (value == null) {
                newText = newText + "${" + sqlVariant + "}$";
                nStart = m.end();
                continue;
            }
            newText = newText + value;
            nStart = m.end();
        }
        newText = newText + text.substring(nStart, text.length());
        return newText;
    }
}

