/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.worksheet.span;

import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeEvent;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeListener;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.DimensionProperty;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Property;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.PropertyConfig;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.Span;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.SpanCalc;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class PropertySpanBuilder
implements PropertyConfig,
ModelChangeListener {
    private List[] propertyColumns;
    private int PCOUNT;
    private int HCOUNT;
    private SpanCalc spanCalc;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private static Logger logger = CommonLogger.getLogger(PropertySpanBuilder.class);
    private boolean showProperties = true;

    public PropertySpanBuilder(OlapModel model) {
        model.addModelChangeListener(this);
    }

    void initialize(Axis axis, SpanCalc spanCalc) {
        this.spanCalc = spanCalc;
        this.HCOUNT = spanCalc.getHierarchyCount();
        this.PCOUNT = spanCalc.getPositionCount();
        this.initializePropertyColumns(axis);
    }

    void initializePropertyColumns(Axis axis) {
        Hierarchy[] hiers = axis.getHierarchies();
        this.propertyColumns = new List[this.HCOUNT];
        for (int i = 0; i < hiers.length; ++i) {
            DimensionProperty[] ps = OlapModelUtil.getDimensionProperties(axis, hiers[i].getDimension());
            if (ps == null) {
                this.propertyColumns[i] = Collections.EMPTY_LIST;
                continue;
            }
            this.propertyColumns[i] = new ArrayList();
            this.propertyColumns[i].addAll(Arrays.asList(ps));
        }
    }

    public void addPropertySpans(Axis axis, SpanCalc sc) {
        if (!this.showProperties) {
            return;
        }
        this.initialize(axis, sc);
        int newHierCount = this.spanCalc.getHierarchyCount();
        for (int hi = 0; hi < this.HCOUNT; ++hi) {
            newHierCount += this.propertyColumns[hi].size();
        }
        Span[][] dst = new Span[this.PCOUNT][];
        for (int pi = 0; pi < this.PCOUNT; ++pi) {
            dst[pi] = new Span[newHierCount];
        }
        Span[][] src = this.spanCalc.getSpans();
        for (int pi = 0; pi < this.PCOUNT; ++pi) {
            int dstHierIndex = 0;
            for (int hi = 0; hi < this.HCOUNT; ++hi) {
                Span span = src[pi][hi];
                dst[pi][dstHierIndex++] = span;
                if (!span.isMember()) continue;
                for (DimensionProperty dp : this.propertyColumns[hi]) {
                    Property prop = span.getMember().getProperty(dp.getPropertyName());
                    dst[pi][dstHierIndex++] = new Span(span.getAxis(), span.getPosition(), prop);
                }
            }
        }
        this.spanCalc.setSpans(dst);
    }

    @Override
    public boolean isShowProperties() {
        return this.showProperties;
    }

    @Override
    public void setShowProperties(boolean b) {
        Boolean oldValue = new Boolean(this.showProperties);
        this.showProperties = b;
        Boolean newValue = new Boolean(this.showProperties);
        this.propertyChangeSupport.firePropertyChange("showProperties", oldValue, newValue);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
    }
}

