/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.xmlutil;

import com.kingdee.bos.ctrl.analysis.xmlutil.StringPair;
import com.kingdee.bos.ctrl.analysis.xmlutil.XmlUtilResource;
import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class Names {

    public static class OrderMethods {
        public static StringPair[] getOrderMethods() {
            return new StringPair[]{new StringPair("asc", "\u5347\u5e8f"), new StringPair("desc", "\u964d\u5e8f")};
        }

        public static StringPair getEmptyOrderBy() {
            return new StringPair(null, "\u4e0d\u6392\u5e8f");
        }
    }

    public static class ChartTypes {
        public static String getChartType(KDChart chart) {
            return chart.getChartType().getName();
        }

        public static void setChartType(KDChart chart, String type) {
            ChartType chartType = ChartType.getChartType((String)type);
            if (chartType != null) {
                chart.setChartType(chartType);
            }
        }
    }

    public static class AxisTypes {
        public static final String row = "row";
        public static final String column = "column";
        public static final String slice = "slice";
    }

    public static class QueryTypes {
        public static final String basic = "basic";
        public static final String mdx = "mdx";
    }

    public static class AggTypes {
        public static final String[] getTypes() {
            return new String[]{"sum", "count", "avg", "max", "min", "first", "last"};
        }

        public static final String[] getTypeLabels(Locale locale) {
            if (Locale.CHINA.equals(locale) || Locale.CHINESE.equals(locale)) {
                return new String[]{XmlUtilResource.getString(XmlUtilResource.class, (String)"Sum"), XmlUtilResource.getString(XmlUtilResource.class, (String)"Count"), XmlUtilResource.getString(XmlUtilResource.class, (String)"Avg"), XmlUtilResource.getString(XmlUtilResource.class, (String)"Max"), XmlUtilResource.getString(XmlUtilResource.class, (String)"Min"), "\u6700\u521d\u503c", "\u6700\u540e\u503c"};
            }
            return AggTypes.getTypes();
        }

        public static String getTypeLabel(Locale locale, String type) {
            List<String> list = Arrays.asList(AggTypes.getTypes());
            int i = list.indexOf(type);
            if (i >= 0) {
                return AggTypes.getTypeLabels(locale)[i];
            }
            return null;
        }
    }

    public static class TimeHierarchyTypes {
        public static final String Year_Quarter_Month_Day = "Year-Quarter-Month-Day";
        public static final String Year_Quarter_Month = "Year-Quarter-Month";
        public static final String Year_Month_Day = "Year-Month-Day";
        public static final String Year_Week_Day = "Year-Week-Day";
        public static final String Year_Quarter = "Year-Quarter";
        public static final String Year_Month = "Year-Month";
        public static final String Year_Week = "Year-Week";
        public static final String seperator = "-";

        public static final String[] getTypes() {
            return new String[]{Year_Quarter_Month_Day, Year_Quarter_Month, Year_Month_Day, Year_Week_Day, Year_Quarter, Year_Month, Year_Week};
        }

        public static final String[] getTypeLabels(Locale locale) {
            if (Locale.CHINA.equals(locale) || Locale.CHINESE.equals(locale)) {
                return new String[]{XmlUtilResource.getString(XmlUtilResource.class, (String)"YQMD"), XmlUtilResource.getString(XmlUtilResource.class, (String)"YQM"), XmlUtilResource.getString(XmlUtilResource.class, (String)"YMD"), XmlUtilResource.getString(XmlUtilResource.class, (String)"YWD"), XmlUtilResource.getString(XmlUtilResource.class, (String)"YQ"), XmlUtilResource.getString(XmlUtilResource.class, (String)"YM"), XmlUtilResource.getString(XmlUtilResource.class, (String)"YW")};
            }
            return TimeHierarchyTypes.getTypes();
        }

        public static boolean valid(String type) {
            return Arrays.asList(TimeHierarchyTypes.getTypes()).contains(type);
        }

        public static final String getTypeLabel(Locale locale, String type) {
            String[] types = TimeHierarchyTypes.getTypes();
            String[] labels = TimeHierarchyTypes.getTypeLabels(locale);
            int index = Arrays.asList(types).indexOf(type);
            if (index != -1) {
                return labels[index];
            }
            return null;
        }

        public static final String getTypeForOlap(String type) {
            return type + "s";
        }

        public static final String unparseTypeFromOlap(String type) {
            return type.substring(0, type.length() - 1);
        }

        public static final String[] split(String type) {
            return type.split(seperator);
        }

        public static final String unsplit(String[] types) {
            String s = "";
            for (int i = 0; i < types.length; ++i) {
                s = i == 0 ? s + types[i] : s + seperator + types[i];
            }
            return s;
        }
    }

    public static class DimensionTypes {
        public static final String standard = "standard";
        public static final String time = "time";
        public static final String parentchild = "parent/child";

        public static final String[] getTypes() {
            return new String[]{standard, time, parentchild};
        }

        public static final String[] getTypeLabels(Locale locale) {
            if (Locale.CHINA.equals(locale) || Locale.CHINESE.equals(locale)) {
                return new String[]{XmlUtilResource.getString(XmlUtilResource.class, (String)"Standard"), XmlUtilResource.getString(XmlUtilResource.class, (String)"Time"), XmlUtilResource.getString(XmlUtilResource.class, (String)"ParentChild")};
            }
            return DimensionTypes.getTypes();
        }

        public static boolean valid(String type) {
            return Arrays.asList(DimensionTypes.getTypes()).contains(type);
        }

        public static final String getTypeLabel(Locale locale, String type) {
            String[] types = DimensionTypes.getTypes();
            String[] labels = DimensionTypes.getTypeLabels(locale);
            int index = Arrays.asList(types).indexOf(type);
            if (index != -1) {
                return labels[index];
            }
            return null;
        }
    }

    public static class Attributes {
        public static final String name = "name";
        public static final String alias = "alias";
        public static final String desc = "desc";
        public static final String type = "type";
        public static final String ref = "ref";
        public static final String leftTable = "leftTable";
        public static final String rightTable = "rightTable";
        public static final String leftColumn = "leftColumn";
        public static final String rightColumn = "rightColumn";
        public static final String template = "template";
        public static final String function = "function";
        public static final String table = "table";
        public static final String version = "version";
        public static final String hasAll = "hasAll";
        public static final String allMemberName = "allMemberName";
        public static final String allMemberCaption = "allMemberCaption";
        public static final String orderBy = "orderBy";
        public static final String orderMethod = "orderMethod";
        public static final String caption = "caption";
        public static final String column = "column";
        public static final String defaultPage = "defaultPage";
        public static final String encryptType = "encryptType";
        public static final String dimensionName = "dimensionName";
        public static final String width = "width";
        public static final String height = "height";
        public static final String left = "left";
        public static final String top = "top";
        public static final String title = "title";
        public static final String position = "position";
        public static final String sliceInSheet = "sliceInSheet";
        public static final String showNesting = "showNesting";
        public static final String showStatic = "showStatic";
        public static final String nonEmpty = "nonEmpty";
        public static final String defaultWidth = "defaultWidth";
        public static final String hierarchyName = "hierarchyName";
        public static final String defaultHeight = "defaultHeight";
        public static final String formatString = "formatString";
    }

    public static class Elements {
        public static final String Schema = "Schema";
        public static final String Model = "Model";
        public static final String CubeModel = "CubeModel";
        public static final String Table = "Table";
        public static final String TableRef = "TableRef";
        public static final String Join = "Join";
        public static final String JoinRef = "JoinRef";
        public static final String FactJoinRef = "FactJoinRef";
        public static final String Fact = "Fact";
        public static final String Dimesion = "Dimension";
        public static final String Hierarchy = "Hierarchy";
        public static final String Measure = "Measure";
        public static final String Cube = "Cube";
        public static final String Level = "Level";
        public static final String Property = "Property";
        public static final String Expression = "Expression";
        public static final String Column = "Column";
        public static final String Attribute = "Attribute";
        public static final String Aggregation = "Aggregation";
        public static final String DataType = "DataType";
        public static final String MemberKey = "MemberKey";
        public static final String ChildKey = "ChildKey";
        public static final String ParentKey = "ParentKey";
        public static final String MemberName = "MemberName";
        public static final String MemberAlias = "MemberAlias";
        public static final String ParentMemberRule = "ParentMemberRule";
        public static final String OlapReport = "OlapReport";
        public static final String OlapConnection = "OlapConnection";
        public static final String QueryInfo = "QueryInfo";
        public static final String Axis = "Axis";
        public static final String Member = "Member";
        public static final String Style = "Style";
        public static final String Page = "Page";
        public static final String Title = "Title";
        public static final String Caption = "Caption";
        public static final String Worksheet = "Worksheet";
        public static final String DataStyle = "DataStyle";
        public static final String MapItem = "MapItem";
        public static final String CSS = "CSS";
        public static final String Merge = "Merge";
        public static final String RowHeader = "RowHeader";
        public static final String CellSizes = "CellSizes";
        public static final String MemberSize = "MemberSize";
        public static final String HierarchySizes = "HierarchySizes";
        public static final String HierarchySize = "HierarchySize";
        public static final String ColumnHeader = "ColumnHeader";
        public static final String MeasureFormat = "MeasureFormat";
        public static final String MeasureFormats = "MeasureFormats";
        public static final String Chart = "Chart";
    }
}

