/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.common.dbcenter.center;

import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.EnumObj;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterConst;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.IDBCenterFacade;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.service.DBCenterUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.util.db.SQLUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DBCenterModelUtil {
    public static List loadAllEnabledDBCenter(Connection con) throws DBCenterException {
        Vector<DBCenterModel> list = new Vector<DBCenterModel>();
        Statement stmt = null;
        ResultSet rs = null;
        DBCenterModel model = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(DBCenterModelUtil.getLoadSQL(null, true));
            while (rs.next()) {
                model = new DBCenterModel();
                model.setDbCenterId(rs.getString("ID"));
                model.setDbCenterName(rs.getString("DBCENTERNAME"));
                model.setBusiType(rs.getString("BIZTYPE"));
                model.setDbType(rs.getString("DBTYPE"));
                model.setUrl(KSqlUtil.decodePassword((String)rs.getString("URL")));
                model.setPort(rs.getString("PORT"));
                model.setDbName(rs.getString("DBNAME"));
                model.setUserName(KSqlUtil.decodePassword((String)rs.getString("DBUSERNAME")));
                model.setPassWord(KSqlUtil.decodePassword((String)rs.getString("DBPASSWORD")));
                model.setMaxIdle(rs.getInt("MAXIDLE"));
                model.setMinIdle(rs.getInt("MINIDLE"));
                model.setMaxActive(rs.getInt("MAXACTIVE"));
                model.setMaxWait(rs.getLong("MAXWAIT"));
                model.setWhenExhausted(Byte.valueOf(rs.getString("WHENEXHAUSTED")));
                list.add(model);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBCenterException("\u83b7\u53d6\u6240\u6709\u5df2\u542f\u7528\u7684\u6570\u636e\u4e2d\u5fc3\u65f6\u51fa\u9519:" + e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return list;
    }

    public static List loadAllEnabledDBCenter2(Connection con) throws DBCenterException {
        Vector<EnumObj> list = new Vector<EnumObj>();
        Statement stmt = null;
        ResultSet rs = null;
        EnumObj obj = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(DBCenterModelUtil.getLoadSQL(null, true));
            while (rs.next()) {
                obj = new EnumObj();
                obj.setNumber(rs.getString("ID"));
                obj.setName(rs.getString("DBCENTERNAME"));
                list.add(obj);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBCenterException("\u83b7\u53d6\u6240\u6709\u5df2\u542f\u7528\u7684\u6570\u636e\u4e2d\u5fc3\u65f6\u51fa\u9519:" + e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return list;
    }

    public static DBCenterModel loadModel(IDBCenterFacade facade, String dbCenterId) throws DBCenterException {
        Map mapSet = facade.executeQuery2(DBCenterModelUtil.getLoadSQL(dbCenterId, false));
        DBCenterModel model = new DBCenterModel();
        model.setDbCenterId(((String[])mapSet.get("ID"))[0]);
        model.setDbCenterName(((String[])mapSet.get("DBCENTERNAME"))[0]);
        model.setBusiType(((String[])mapSet.get("BIZTYPE"))[0]);
        model.setDbType(((String[])mapSet.get("DBTYPE"))[0]);
        model.setUrl(KSqlUtil.decodePassword((String)((String[])mapSet.get("URL"))[0]));
        model.setPort(((String[])mapSet.get("PORT"))[0]);
        model.setDbName(((String[])mapSet.get("DBNAME"))[0]);
        model.setUserName(KSqlUtil.decodePassword((String)((String[])mapSet.get("DBUSERNAME"))[0]));
        model.setPassWord(KSqlUtil.decodePassword((String)((String[])mapSet.get("DBPASSWORD"))[0]));
        model.setMaxIdle(Integer.parseInt(((String[])mapSet.get("MAXIDLE"))[0]));
        model.setMinIdle(Integer.parseInt(((String[])mapSet.get("MINIDLE"))[0]));
        model.setMaxActive(Integer.parseInt(((String[])mapSet.get("MAXACTIVE"))[0]));
        model.setMaxWait(Integer.parseInt(((String[])mapSet.get("MAXWAIT"))[0]));
        model.setWhenExhausted(Byte.parseByte(((String[])mapSet.get("WHENEXHAUSTED"))[0]));
        return model;
    }

    private static String getLoadSQL(String dbCenterId, boolean useFlag) {
        StringBuffer sb = new StringBuffer();
        sb.append("select ").append("FID ").append("ID");
        sb.append(",FDBCenterName ").append("DBCENTERNAME");
        sb.append(",FBizType ").append("BIZTYPE");
        sb.append(",FDBType ").append("DBTYPE");
        sb.append(",FDBUrl ").append("URL");
        sb.append(",FDBPort ").append("PORT");
        sb.append(",FDBName ").append("DBNAME");
        sb.append(",FDBUserName ").append("DBUSERNAME");
        sb.append(",FDBPassWord ").append("DBPASSWORD");
        sb.append(",FMaxIdle ").append("MAXIDLE");
        sb.append(",FMinIdle ").append("MINIDLE");
        sb.append(",FMaxActive ").append("MAXACTIVE");
        sb.append(",FMaxWait ").append("MAXWAIT");
        sb.append(",FWhenExhausted ").append("WHENEXHAUSTED");
        sb.append(",FDiscription ").append("DISCRIPTION");
        sb.append("\tfrom ").append(DBCenterModelUtil.getTableName());
        if (!StringUtil.isEmptyString((String)dbCenterId) || useFlag) {
            sb.append(" where ");
            sb.append(StringUtil.isEmptyString((String)dbCenterId) ? "fid is not NULL" : "fid='" + dbCenterId + "'");
            sb.append(useFlag ? " and FUseFlag=1" : "");
        }
        return sb.toString();
    }

    public static DBCenterModel loadModel(Connection con, String dbCenterId) throws DBCenterException {
        if (StringUtil.isEmptyString((String)dbCenterId) || con == null) {
            return null;
        }
        DBCenterModel model = new DBCenterModel();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(DBCenterModelUtil.getLoadSQL(dbCenterId, true));
            if (rs.next()) {
                model.setDbCenterId(rs.getString("ID"));
                model.setDbCenterName(rs.getString("DBCENTERNAME"));
                model.setBusiType(rs.getString("BIZTYPE"));
                model.setDbType(rs.getString("DBTYPE"));
                model.setUrl(KSqlUtil.decodePassword((String)rs.getString("URL")));
                model.setPort(rs.getString("PORT"));
                model.setDbName(rs.getString("DBNAME"));
                model.setUserName(KSqlUtil.decodePassword((String)rs.getString("DBUSERNAME")));
                model.setPassWord(KSqlUtil.decodePassword((String)rs.getString("DBPASSWORD")));
                model.setMaxIdle(rs.getInt("MAXIDLE"));
                model.setMinIdle(rs.getInt("MINIDLE"));
                model.setMaxActive(rs.getInt("MAXACTIVE"));
                model.setMaxWait(rs.getLong("MAXWAIT"));
                model.setWhenExhausted(Byte.valueOf(rs.getString("WHENEXHAUSTED")));
            }
        }
        catch (SQLException e) {
            try {
                throw new DBCenterException("\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u51fa\u9519\uff1a" + e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return model;
    }

    public static boolean checkIsDBCenterNameExist(IDBCenterFacade facade, String dbCenterName) throws DBCenterException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from ").append(DBCenterModelUtil.getTableName()).append(" where ");
        sql.append("FDBCenterName='").append(dbCenterName).append("'");
        String id = facade.executeQuery3(sql.toString());
        return !StringUtil.isEmptyString((String)id);
    }

    public static int save(IDBCenterFacade facade, String operateType, DBCenterModel model) throws DBCenterException {
        if ("addNew".equals(operateType)) {
            return DBCenterModelUtil.insert(facade, model);
        }
        if ("update".equals(operateType)) {
            return DBCenterModelUtil.update(facade, model);
        }
        return -1;
    }

    public static int insert(IDBCenterFacade facade, DBCenterModel m) throws DBCenterException {
        StringBuffer sbi = new StringBuffer();
        sbi.append("insert into ").append(DBCenterModelUtil.getTableName());
        sbi.append("(").append("FID");
        sbi.append(",FDBCenterName,FBizType,FDBType,FDBUrl,FDBPort,FDBName,FDBUserName,FDBPassWord");
        sbi.append(",FMaxIdle,FMinIdle,FMaxActive,FMaxWait,FWhenExhausted,FUseFlag,FDiscription");
        sbi.append(",FCreatorID,FLastUpdateUserID,FCreateTime,FLastUpdateTime").append(")");
        sbi.append("values(");
        sbi.append("'").append(facade.getUUID()).append("'");
        sbi.append(",'").append(m.getDbCenterName()).append("','").append(m.getBusiType()).append("'");
        sbi.append(",'").append(m.getDbType()).append("','").append(KSqlUtil.encodePassword((String)m.getUrl())).append("'");
        sbi.append(",'").append(m.getPort()).append("','").append(m.getDbName()).append("'");
        sbi.append(",'").append(KSqlUtil.encodePassword((String)m.getUserName())).append("','").append(KSqlUtil.encodePassword((String)m.getPassWord())).append("'");
        sbi.append(",").append(m.getMaxIdle()).append(",").append(m.getMinIdle());
        sbi.append(",").append(m.getMaxActive()).append(",").append(m.getMaxWait());
        sbi.append(",'").append(m.getWhenExhausted()).append("',").append(0).append(",NULL");
        sbi.append(",'").append(facade.getCurrentUser()).append("','").append(facade.getCurrentUser());
        sbi.append("',").append("getdate()").append(",").append("getdate()");
        sbi.append(")");
        return facade.executeUpdate(sbi.toString());
    }

    public static int update(IDBCenterFacade facade, DBCenterModel m) throws DBCenterException {
        StringBuffer sbu = new StringBuffer();
        sbu.append("update ").append(DBCenterModelUtil.getTableName());
        sbu.append(" set FDBCenterName = '").append(m.getDbCenterName());
        sbu.append("' , FBizType = '").append(m.getBusiType());
        sbu.append("' , FDBType  = '").append(m.getDbType());
        sbu.append("' , FDBUrl  = '").append(KSqlUtil.encodePassword((String)m.getUrl()));
        sbu.append("' , FDBPort  = '").append(m.getPort());
        sbu.append("' , FDBName = '").append(m.getDbName());
        sbu.append("' , FDBUserName = '").append(KSqlUtil.encodePassword((String)m.getUserName()));
        sbu.append("' , FDBPassWord = '").append(KSqlUtil.encodePassword((String)m.getPassWord()));
        sbu.append("' , FMaxIdle = ").append(m.getMaxIdle());
        sbu.append(" , FMinIdle = ").append(m.getMinIdle());
        sbu.append(" , FMaxActive = ").append(m.getMaxActive());
        sbu.append(" , FMaxWait = ").append(m.getMaxWait());
        sbu.append(" , FWhenExhausted = '").append(m.getWhenExhausted());
        sbu.append("' , FLastUpdateUserID='").append(facade.getCurrentUser());
        sbu.append("' , FLastUpdateTime=getdate() where FID='").append(m.getDbCenterId()).append("'");
        return facade.executeUpdate(sbu.toString());
    }

    public static int delete(IDBCenterFacade facade, String id) throws DBCenterException {
        StringBuffer sbd = new StringBuffer();
        sbd.append("delete from ").append(DBCenterModelUtil.getTableName()).append(" where fid='").append(id).append("'");
        return facade.executeUpdate(sbd.toString());
    }

    public static int useEnable(IDBCenterFacade facade, String viewId, boolean enable) throws DBCenterException {
        StringBuffer sbd = new StringBuffer();
        sbd.append("update ").append(DBCenterModelUtil.getTableName()).append(" set FUseFlag = ");
        sbd.append(enable ? 1 : 0).append(" where FID='").append(viewId).append("'");
        return facade.executeUpdate(sbd.toString());
    }

    public static boolean enableDBCenter(Connection con, String dbCenterId) {
        return true;
    }

    private static String getTableName() {
        return "T_BI_DB_CENTER";
    }

    public static Vector getBizTypeVector() {
        Vector<EnumObj> vector = new Vector<EnumObj>();
        vector.add(new EnumObj("simple", "\u666e\u901a\u6570\u636e\u5e93"));
        vector.add(new EnumObj("ods", "ODS"));
        vector.add(new EnumObj("dw", "\u6570\u636e\u4ed3\u5e93"));
        vector.add(new EnumObj("dm", "\u6570\u636e\u96c6\u5e02"));
        return vector;
    }

    public static Vector getDBTypeVector() {
        Vector<EnumObj> vector = new Vector<EnumObj>();
        vector.add(new EnumObj("sqlserver", "SQL SERVER"));
        vector.add(new EnumObj("oracle", "ORACLE"));
        vector.add(new EnumObj("db2", "DB2"));
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Vector getDBNames(String url, String port, String userName, String passWord) throws DBCenterException {
        Vector<EnumObj> vector = new Vector<EnumObj>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Class.forName("com.kingdee.bos.sql.shell.Driver");
            con = DriverManager.getConnection("jdbc:ksql:net.sourceforge.jtds.jdbc.Driver:dbtype=mssqlserver:TempTableSpace=temp2:jdbc:jtds:sqlserver://" + url + ":" + port + "/master;prepareSQL=2;sendStringParametersAsUnicode=false;useCursors=true", userName, passWord);
            stmt = con.createStatement();
            rs = stmt.executeQuery("select name from master.dbo.sysdatabases order by name");
            while (rs.next()) {
                String dbName = rs.getString("name");
                vector.add(new EnumObj(dbName));
            }
        }
        catch (SQLException sQLException) {
            DBCenterUtil.closeAll(con, stmt, rs);
        }
        catch (ClassNotFoundException classNotFoundException) {
            DBCenterUtil.closeAll(con, stmt, rs);
            {
                catch (Throwable throwable) {
                    DBCenterUtil.closeAll(con, stmt, rs);
                    throw throwable;
                }
            }
        }
        DBCenterUtil.closeAll(con, stmt, rs);
        return vector;
    }

    public static Vector getWhenExhaustedActions() {
        Vector<EnumObj> vector = new Vector<EnumObj>();
        vector.add(new EnumObj(DBCenterConst.POOL_WHEN_EXHAUSTED_ACTION_NUMBER_GROW, "\u521b\u5efa\u65b0\u7684\u8fde\u63a5"));
        vector.add(new EnumObj(DBCenterConst.POOL_WHEN_EXHAUSTED_ACTION_NUMBER_BLOCK, "\u7b49\u5f85\u91ca\u653e"));
        vector.add(new EnumObj(DBCenterConst.POOL_WHEN_EXHAUSTED_ACTION_NUMBER_FAIL, "\u629b\u51fa\u5f02\u5e38"));
        return vector;
    }

    public static String getLocalIp() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return null;
        }
        return addr.getHostAddress();
    }
}

