/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap;

import com.kingdee.bos.ctrl.analysis.modelcore.ExtensionSupport;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.AxisMembersHelper;
import com.kingdee.bos.ctrl.analysis.olap.ChangeSlicer;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.Result;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryAxisManager;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Axis;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Hierarchy;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Member;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Model;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_QueryManager;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Util;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.Syntax;
import com.kingdee.bos.olap.mdx.elementexp.ExprUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class KDOLAP_AxisMembersHelper
extends ExtensionSupport
implements AxisMembersHelper {
    private static Logger logger = CommonLogger.getLogger(KDOLAP_AxisMembersHelper.class);
    private boolean expandAllMember = false;
    ArrayList aMemberSet = null;

    public KDOLAP_AxisMembersHelper() {
        super.setId("axisMembersHelper");
    }

    @Override
    public Exp createMemberExpression(Hierarchy hier) {
        com.kingdee.bos.olap.Hierarchy kdHier = ((KDOLAP_Hierarchy)hier).getKDHierarchy();
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        KDOLAP_QueryManager adapter = (KDOLAP_QueryManager)model.getQueryManager();
        QueryAxisManager qam = adapter.findQueryAxisManager(hier.getDimension());
        if (qam == null) {
            SchemaReader scr = ((KDOLAP_Model)this.getModel()).getConnection().getSchemaReader();
            Exp o = KDOLAP_Util.topLevelMembers(kdHier, this.expandAllMember, scr);
            if (o == null) {
                o = ExprUtil.toExp((OLAPElement)kdHier.getInnerAllMember());
            }
            return o;
        }
        int iDimension = qam.dimIdx(hier.getDimension());
        return this.genExpForDim(qam, iDimension, hier);
    }

    private void changeQueryAxisManager(QueryAxisManager qam, Hierarchy[] hiers, Exp[] memberExpressions) {
        Exp[] sets = new Exp[hiers.length];
        boolean changedMemberSet = true;
        int j = 0;
        for (int i = 0; i < memberExpressions.length; ++i) {
            if (memberExpressions[i] == null) continue;
            sets[j++] = memberExpressions[i];
        }
        qam.regeneratePosTree(sets, hiers);
        qam.changed(this, changedMemberSet);
    }

    private void innerSetQueryAxis(Axis target, Hierarchy[] hiers, Exp[] memberExpressions) {
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        KDOLAP_QueryManager adapter = (KDOLAP_QueryManager)model.getQueryManager();
        int iQueryAxisManager = ((KDOLAP_Axis)target).getOrdinal();
        if (adapter.isSwapAxes()) {
            iQueryAxisManager = (iQueryAxisManager + 1) % 2;
        }
        QueryAxisManager qam = adapter.getQueryAxisManageres()[iQueryAxisManager];
        this.changeQueryAxisManager(qam, hiers, memberExpressions);
    }

    @Override
    public void setQueryAxis(Axis target, Hierarchy[] hiers, Position[] positions) {
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        KDOLAP_QueryManager adapter = (KDOLAP_QueryManager)model.getQueryManager();
        int iQueryAxisManager = ((KDOLAP_Axis)target).getOrdinal();
        if (adapter.isSwapAxes()) {
            iQueryAxisManager = (iQueryAxisManager + 1) % 2;
        }
        QueryAxisManager qam = adapter.getQueryAxisManageres()[iQueryAxisManager];
        ArrayList<Position> list = new ArrayList<Position>(positions.length);
        for (int i = 0; i < positions.length; ++i) {
            list.add(positions[i]);
        }
        qam.init(hiers, list);
        qam.changed(this, false);
        model.fireModelChanged();
    }

    @Override
    public void setQueryAxis(Axis target, Hierarchy[] hiers, Exp[] memberExpressions) {
        this.innerSetQueryAxis(target, hiers, memberExpressions);
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        model.fireModelChanged();
    }

    @Override
    public void setQueryAxis(Axis[] targets, Hierarchy[][] hiers, Exp[][] memberExpressions) {
        if (targets.length != memberExpressions.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < targets.length; ++i) {
            this.innerSetQueryAxis(targets[i], hiers[i], memberExpressions[i]);
        }
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        model.fireModelChanged();
    }

    @Override
    public void setExpandAllMember(boolean expandAllMember) {
        this.expandAllMember = expandAllMember;
    }

    @Override
    public boolean getExpandAllMember() {
        return this.expandAllMember;
    }

    private Exp genExpForDim(QueryAxisManager qam, int iDim, Hierarchy hier) {
        Exp o = qam.genExpForDim(iDim);
        if (o != null) {
            if (qam.getUtil().isMember(o)) {
                o = qam.getUtil().createFunCall("{}", new Exp[]{o}, 2);
            }
            return o;
        }
        SchemaReader scr = ((KDOLAP_Model)this.getModel()).getConnection().getSchemaReader();
        o = KDOLAP_Util.topLevelMembers(((KDOLAP_Hierarchy)hier).getKDHierarchy(), false, scr);
        if (o == null) {
            o = ExprUtil.toExp((OLAPElement)((KDOLAP_Hierarchy)hier).getKDHierarchy().getInnerAllMember());
        }
        return o;
    }

    @Override
    public void swapHierarchy(Hierarchy hier1, Hierarchy hier2) {
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        KDOLAP_QueryManager adapter = (KDOLAP_QueryManager)model.getQueryManager();
        QueryAxisManager qam1 = adapter.findQueryAxisManager(hier1.getDimension());
        QueryAxisManager qam2 = adapter.findQueryAxisManager(hier2.getDimension());
        if (qam1 == null && qam2 == null) {
            return;
        }
        if (qam1 == null) {
            ChangeSlicer changeSlicer = (ChangeSlicer)model.getExtension("changeSlicer");
            changeSlicer.removeHierarchy(hier1);
            this.innerReplaceHierarchy(hier1, hier2);
        } else if (qam2 == null) {
            ChangeSlicer changeSlicer = (ChangeSlicer)model.getExtension("changeSlicer");
            changeSlicer.removeHierarchy(hier2);
            this.innerReplaceHierarchy(hier2, hier1);
        } else {
            int idim1 = qam1.dimIdx(hier1.getDimension());
            int idim2 = qam2.dimIdx(hier2.getDimension());
            int ndim1 = qam1.getDimCount();
            int ndim2 = qam2.getDimCount();
            if (qam1 == qam2) {
                Exp[] expressions1 = new Exp[ndim1];
                for (int i = 0; i < ndim1; ++i) {
                    expressions1[i] = this.genExpForDim(qam1, i, qam1.getHierarchies()[i]);
                }
                Exp temp = expressions1[idim1];
                expressions1[idim1] = expressions1[idim2];
                expressions1[idim2] = temp;
                Hierarchy[] hiers1 = qam1.getHierarchies();
                Hierarchy[] hiers2 = new Hierarchy[hiers1.length];
                System.arraycopy(hiers1, 0, hiers2, 0, hiers1.length);
                hiers2[idim1] = hiers1[idim2];
                hiers2[idim2] = hiers1[idim1];
                this.changeQueryAxisManager(qam1, hiers2, expressions1);
            } else {
                int i;
                Exp[] expressions1 = new Exp[ndim1];
                Exp[] expressions2 = new Exp[ndim2];
                Hierarchy[] hiers1 = new Hierarchy[ndim1];
                Hierarchy[] hiers2 = new Hierarchy[ndim2];
                hiers1 = (Hierarchy[])qam1.getHierarchies().clone();
                hiers2 = (Hierarchy[])qam2.getHierarchies().clone();
                for (i = 0; i < ndim1; ++i) {
                    expressions1[i] = this.genExpForDim(qam1, i, hiers1[i]);
                }
                for (i = 0; i < ndim2; ++i) {
                    expressions2[i] = this.genExpForDim(qam2, i, hiers2[i]);
                }
                Exp temp = expressions1[idim1];
                expressions1[idim1] = expressions2[idim2];
                expressions2[idim2] = temp;
                Hierarchy temp2 = hiers1[idim1];
                hiers1[idim1] = hiers2[idim2];
                hiers2[idim2] = temp2;
                this.changeQueryAxisManager(qam1, hiers1, expressions1);
                this.changeQueryAxisManager(qam2, hiers2, expressions2);
            }
        }
        model.fireModelChanged();
    }

    public void innerReplaceHierarchy(Hierarchy fromHie, Hierarchy toHie) {
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        KDOLAP_QueryManager adapter = (KDOLAP_QueryManager)model.getQueryManager();
        QueryAxisManager qam = adapter.findQueryAxisManager(toHie.getDimension());
        int idim = qam.dimIdx(toHie.getDimension());
        int ndim = qam.getDimCount();
        Hierarchy[] hiers = qam.getHierarchies();
        Exp[] expressions = new Exp[ndim];
        for (int i = 0; i < ndim; ++i) {
            if (i == idim) continue;
            expressions[i] = this.genExpForDim(qam, i, hiers[i]);
        }
        expressions[idim] = this.createMemberExpression(fromHie);
        hiers[idim] = fromHie;
        this.changeQueryAxisManager(qam, hiers, expressions);
    }

    @Override
    public void addHierarchy(Axis target, Hierarchy hier, int index) {
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        KDOLAP_QueryManager adapter = (KDOLAP_QueryManager)model.getQueryManager();
        int iQueryAxisManager = ((KDOLAP_Axis)target).getOrdinal();
        if (adapter.isSwapAxes()) {
            iQueryAxisManager = (iQueryAxisManager + 1) % 2;
        }
        QueryAxisManager qam = adapter.getQueryAxisManageres()[iQueryAxisManager];
        int ndim = qam.getDimCount();
        Exp[] expressions = new Exp[ndim + 1];
        Hierarchy[] hiers = qam.getHierarchies();
        Hierarchy[] hiers2 = new Hierarchy[ndim + 1];
        for (int i = 0; i < ndim; ++i) {
            if (index > i) {
                expressions[i] = this.genExpForDim(qam, i, hiers[i]);
                hiers2[i] = hiers[i];
                continue;
            }
            expressions[i + 1] = this.genExpForDim(qam, i, hiers[i]);
            hiers2[i + 1] = hiers[i];
        }
        expressions[index] = this.createMemberExpression(hier);
        hiers2[index] = hier;
        this.changeQueryAxisManager(qam, hiers2, expressions);
        model.fireModelChanged();
    }

    @Override
    public void removeHierarchy(Axis target, Hierarchy hier) {
        int index = Arrays.asList(target.getHierarchies()).indexOf(hier);
        if (index < 0) {
            return;
        }
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        KDOLAP_QueryManager adapter = (KDOLAP_QueryManager)model.getQueryManager();
        int iQueryAxisManager = ((KDOLAP_Axis)target).getOrdinal();
        if (adapter.isSwapAxes()) {
            iQueryAxisManager = (iQueryAxisManager + 1) % 2;
        }
        QueryAxisManager qam = adapter.getQueryAxisManageres()[iQueryAxisManager];
        int ndim = qam.getDimCount();
        Exp[] expressions = new Exp[ndim - 1];
        Hierarchy[] hiers = qam.getHierarchies();
        Hierarchy[] hiers2 = new Hierarchy[ndim - 1];
        for (int i = 0; i < ndim; ++i) {
            if (index > i) {
                expressions[i] = this.genExpForDim(qam, i, hiers[i]);
                hiers2[i] = hiers[i];
                continue;
            }
            if (index >= i) continue;
            expressions[i - 1] = this.genExpForDim(qam, i, hiers[i]);
            hiers2[i - 1] = hiers[i];
        }
        this.changeQueryAxisManager(qam, hiers2, expressions);
        model.fireModelChanged();
    }

    @Override
    public Exp createMemberExpression(List members) {
        ArrayList<com.kingdee.bos.olap.Member> memberList = new ArrayList<com.kingdee.bos.olap.Member>();
        for (KDOLAP_Member mem : members) {
            memberList.add(mem.getKDMember());
        }
        if (memberList.size() == 1) {
            return ExprUtil.toExp((OLAPElement)((com.kingdee.bos.olap.Member)memberList.get(0)));
        }
        return new FunCall("{}", (Exp[])ExprUtil.toExp(memberList), Syntax.Braces);
    }

    @Override
    public Member findFirstVisibleMember(Hierarchy hier) {
        Axis axis;
        List positions;
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        KDOLAP_QueryManager queryManager = (KDOLAP_QueryManager)model.getQueryManager();
        QueryAxisManager qam = queryManager.findQueryAxisManager(hier.getDimension());
        if (qam == null) {
            return null;
        }
        int iDim = qam.dimIdx(hier.getDimension());
        Result res = null;
        try {
            res = model.getResult();
        }
        catch (OlapException e) {
            e.printStackTrace();
            return null;
        }
        int iAx = qam.getOrdinal();
        if (queryManager.isSwapAxes()) {
            iAx = (iAx + 1) % 2;
        }
        if ((positions = (axis = res.getOriginAxes()[iAx]).getPositions()).size() > 0) {
            Member[] ms = ((Position)positions.get(0)).getMembers();
            return ms[iDim];
        }
        return null;
    }

    @Override
    public List findVisibleMembers(Hierarchy hier) {
        ArrayList<KDOLAP_Member> memberList = null;
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        KDOLAP_QueryManager queryManager = (KDOLAP_QueryManager)model.getQueryManager();
        QueryAxisManager qam = queryManager.findQueryAxisManager(hier.getDimension());
        if (qam == null) {
            return Collections.EMPTY_LIST;
        }
        int iDim = qam.dimIdx(hier.getDimension());
        List kdMemberList = KDOLAP_Util.collectMembers(qam.getPosTreeRoot(), iDim, model.getConnection().getSchemaReader());
        if (kdMemberList == null) {
            Result res = null;
            memberList = new ArrayList();
            try {
                res = model.getResult();
            }
            catch (OlapException e) {
                e.printStackTrace();
                return Collections.EMPTY_LIST;
            }
            int iAx = qam.getOrdinal();
            if (queryManager.isSwapAxes()) {
                iAx = (iAx + 1) % 2;
            }
            Axis axis = res.getOriginAxes()[iAx];
            List positions = axis.getPositions();
            for (Position pos : positions) {
                Member[] members = pos.getMembers();
                KDOLAP_Member mem = (KDOLAP_Member)members[iDim];
                if (mem == null || memberList.contains(mem)) continue;
                memberList.add(mem);
            }
        } else {
            memberList = new ArrayList<KDOLAP_Member>();
            for (com.kingdee.bos.olap.Member kdMember : kdMemberList) {
                KDOLAP_Member m = (KDOLAP_Member)model.lookupMember(kdMember.getUniqueName());
                memberList.add(m);
            }
        }
        return memberList;
    }
}

