/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap;

import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Level;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryAxisManager;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryAxisUtil;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Dimension;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Hierarchy;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Level;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Member;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Model;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Util;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.Syntax;
import com.kingdee.bos.olap.mdx.elementexp.DimensionExpr;
import com.kingdee.bos.olap.mdx.elementexp.ExprUtil;
import com.kingdee.bos.olap.mdx.elementexp.HierarchyExpr;
import com.kingdee.bos.olap.mdx.elementexp.LevelExpr;
import com.kingdee.bos.olap.mdx.elementexp.MemberExpr;
import com.kingdee.bos.olap.util.IntHolder;
import com.kingdee.bos.olap.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class KDOLAP_QueryAxisUtil
implements QueryAxisUtil {
    static Logger logger = CommonLogger.getLogger(KDOLAP_QueryAxisUtil.class);
    private KDOLAP_Model model = null;
    private SchemaReader scr;

    KDOLAP_QueryAxisUtil(KDOLAP_Model model) {
        this.model = model;
        this.scr = model.getConnection().getSchemaReader();
    }

    @Override
    public boolean isFunCallNotTopLevel(Exp oFun) throws QueryAxisManager.CannotHandleException {
        FunCall f = (FunCall)oFun;
        if (f.isCallTo("Children")) {
            return true;
        }
        if (f.isCallTo("Descendants")) {
            return true;
        }
        if (f.isCallTo("Members")) {
            com.kingdee.bos.olap.Level lev = ExprUtil.toLevel((Exp)f.getArg(0));
            return lev.getDepth() > 0;
        }
        if (f.isCallTo("Union")) {
            if (this.isFunCallNotTopLevel(f.getArg(0))) {
                return true;
            }
            return this.isFunCallNotTopLevel(f.getArg(1));
        }
        if (f.isCallTo("{}")) {
            for (int i = 0; i < f.getArgs().length; ++i) {
                if (this.isMemberOnToplevel(ExprUtil.toMember((Exp)f.getArg(i)))) continue;
                return true;
            }
            return false;
        }
        throw new QueryAxisManager.CannotHandleException(f.getFunName());
    }

    @Override
    public boolean isMemberOnToplevel(Exp oMem) {
        com.kingdee.bos.olap.Member m = ((KDOLAP_Member)oMem).getKDMember();
        return this.isMemberOnToplevel(m);
    }

    private boolean isMemberOnToplevel(com.kingdee.bos.olap.Member m) {
        return m.getLevel().getDepth() <= 0;
    }

    @Override
    public boolean isMemberInFunCall(Exp oFun, Member member) throws QueryAxisManager.CannotHandleException {
        FunCall f = (FunCall)oFun;
        if (f.isCallTo("Hierarchize")) {
            f = (FunCall)f.getArgs()[0];
        }
        com.kingdee.bos.olap.Member m = ((KDOLAP_Member)member).getKDMember();
        return this.isMemberInFunCall(f, m);
    }

    private boolean isMemberInFunCall(FunCall f, com.kingdee.bos.olap.Member m) throws QueryAxisManager.CannotHandleException {
        if (f.isCallTo("Children")) {
            return this.isMemberInChildren(f, m);
        }
        if (f.isCallTo("Descendants")) {
            return this.isMemberInDescendants(f, m);
        }
        if (f.isCallTo("Members")) {
            return this.isMemberInLevel(f, m);
        }
        if (f.isCallTo("Union")) {
            return this.isMemberInUnion(f, m);
        }
        if (f.isCallTo("{}")) {
            return this.isMemberInSet(f, m);
        }
        throw new QueryAxisManager.CannotHandleException(f.getFunName());
    }

    private boolean isMemberInChildren(FunCall f, com.kingdee.bos.olap.Member mSearch) {
        if (mSearch.isCalculated()) {
            return false;
        }
        com.kingdee.bos.olap.Member parent = ExprUtil.toMember((Exp)f.getArg(0));
        return parent.equals(mSearch.getParentMember());
    }

    private boolean isMemberInDescendants(FunCall f, com.kingdee.bos.olap.Member mSearch) {
        if (mSearch.isCalculated()) {
            return false;
        }
        com.kingdee.bos.olap.Member ancestor = ExprUtil.toMember((Exp)f.getArg(0));
        com.kingdee.bos.olap.Level level = ExprUtil.toLevel((Exp)f.getArg(1));
        if (mSearch.equals(ancestor)) {
            return false;
        }
        if (!Util.isDescendentOrEqualTo((com.kingdee.bos.olap.Member)mSearch, (com.kingdee.bos.olap.Member)ancestor)) {
            return false;
        }
        return level.equals(mSearch.getLevel());
    }

    private boolean isMemberInLevel(FunCall f, com.kingdee.bos.olap.Member mSearch) {
        if (mSearch.isCalculated()) {
            return false;
        }
        com.kingdee.bos.olap.Level level = ExprUtil.toLevel((Exp)f.getArg(0));
        return level.equals(mSearch.getLevel());
    }

    private boolean isMemberInSet(FunCall f, com.kingdee.bos.olap.Member mSearch) {
        for (int i = 0; i < f.getArgs().length; ++i) {
            com.kingdee.bos.olap.Member m;
            if (!(f.getArg(i) instanceof FunCall ? this.isMemberInSet((FunCall)f.getArg(i), mSearch) : (m = ExprUtil.toMember((Exp)f.getArg(i))).equals(mSearch))) continue;
            return true;
        }
        return false;
    }

    private boolean isMemberInUnion(FunCall f, com.kingdee.bos.olap.Member mSearch) throws QueryAxisManager.CannotHandleException {
        for (int i = 0; i < 2; ++i) {
            FunCall fChild = (FunCall)f.getArg(i);
            if (!this.isMemberInFunCall(fChild, mSearch)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isChildOfMemberInFunCall(Exp oFun, Member member) throws QueryAxisManager.CannotHandleException {
        FunCall f = (FunCall)oFun;
        com.kingdee.bos.olap.Member m = ((KDOLAP_Member)member).getKDMember();
        if (f.isCallTo("Children")) {
            return KDOLAP_QueryAxisUtil.expEqualsMember(f.getArg(0), m);
        }
        if (f.isCallTo("Descendants")) {
            com.kingdee.bos.olap.Member ancestor = (com.kingdee.bos.olap.Member)f.getArg(0);
            com.kingdee.bos.olap.Level lev = (com.kingdee.bos.olap.Level)f.getArg(1);
            com.kingdee.bos.olap.Level parentLevel = lev.getParentLevel();
            if (parentLevel != null && m.getLevel().equals(parentLevel)) {
                return Util.isDescendentOrEqualTo((com.kingdee.bos.olap.Member)m, (com.kingdee.bos.olap.Member)ancestor);
            }
            return false;
        }
        if (f.isCallTo("Members")) {
            com.kingdee.bos.olap.Level lev = ExprUtil.toLevel((Exp)f.getArg(0));
            com.kingdee.bos.olap.Level parentLevel = lev.getParentLevel();
            return parentLevel != null && m.getLevel().equals(parentLevel);
        }
        if (f.isCallTo("Union")) {
            if (this.isChildOfMemberInFunCall(f.getArg(0), member)) {
                return true;
            }
            return this.isChildOfMemberInFunCall(f.getArg(1), member);
        }
        if (f.isCallTo("{}") || f.isCallTo("Hierarchize")) {
            for (int i = 0; i < f.getArgs().length; ++i) {
                com.kingdee.bos.olap.Member mmp;
                com.kingdee.bos.olap.Member mm;
                if (!(f.getArg(i) instanceof FunCall ? this.isChildOfMemberInFunCall((Exp)((FunCall)f.getArg(i)), member) : !(mm = ExprUtil.toMember((Exp)f.getArg(i))).isCalculated() && (mmp = mm.getParentMember()) != null && mmp.equals(m))) continue;
                return true;
            }
            return false;
        }
        throw new QueryAxisManager.CannotHandleException(f.getFunName());
    }

    @Override
    public boolean isDescendantOfMemberInFunCall(Exp oFun, Member member) throws QueryAxisManager.CannotHandleException {
        FunCall f = (FunCall)oFun;
        com.kingdee.bos.olap.Member m = ((KDOLAP_Member)member).getKDMember();
        if (f.isCallTo("Children")) {
            com.kingdee.bos.olap.Member mExp = ExprUtil.toMember((Exp)f.getArg(0));
            return Util.isDescendentOrEqualTo((com.kingdee.bos.olap.Member)mExp, (com.kingdee.bos.olap.Member)m);
        }
        if (f.isCallTo("Descendants")) {
            com.kingdee.bos.olap.Member mExp = ExprUtil.toMember((Exp)f.getArg(0));
            return Util.isDescendentOrEqualTo((com.kingdee.bos.olap.Member)mExp, (com.kingdee.bos.olap.Member)m);
        }
        if (f.isCallTo("Members")) {
            com.kingdee.bos.olap.Level levExp = ExprUtil.toLevel((Exp)f.getArg(0));
            return levExp.getDepth() > m.getLevel().getDepth();
        }
        if (f.isCallTo("Union")) {
            if (this.isDescendantOfMemberInFunCall(f.getArg(0), member)) {
                return true;
            }
            return this.isDescendantOfMemberInFunCall(f.getArg(1), member);
        }
        if (f.isCallTo("{}")) {
            for (int i = 0; i < f.getArgs().length; ++i) {
                com.kingdee.bos.olap.Member mExp = ExprUtil.toMember((Exp)f.getArg(i));
                if (mExp.isCalculated() || m.equals(mExp) || !Util.isDescendentOrEqualTo((com.kingdee.bos.olap.Member)mExp, (com.kingdee.bos.olap.Member)m)) continue;
                return true;
            }
            return false;
        }
        throw new QueryAxisManager.CannotHandleException(f.getFunName());
    }

    public Object removeDescendantsFromFunCall(Exp oFun, Member member) throws QueryAxisManager.CannotHandleException {
        FunCall f = (FunCall)oFun;
        com.kingdee.bos.olap.Member m = ((KDOLAP_Member)member).getKDMember();
        if (f.isCallTo("Children")) {
            return null;
        }
        if (f.isCallTo("Descendants")) {
            return null;
        }
        if (f.isCallTo("Members")) {
            com.kingdee.bos.olap.Level levExp = ExprUtil.toLevel((Exp)f.getArg(0));
            IMemberList members = null;
            try {
                members = this.scr.getLevelMembers(levExp);
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            ArrayList<com.kingdee.bos.olap.Member> remainder = new ArrayList<com.kingdee.bos.olap.Member>();
            for (com.kingdee.bos.olap.Member m2 : members) {
                if (Util.isDescendentOrEqualTo((com.kingdee.bos.olap.Member)m2, (com.kingdee.bos.olap.Member)m)) continue;
                remainder.add(m2);
            }
            return this.createMemberSet(remainder);
        }
        if (f.isCallTo("{}")) {
            ArrayList<com.kingdee.bos.olap.Member> remainder = new ArrayList<com.kingdee.bos.olap.Member>();
            for (int i = 0; i < f.getArgs().length; ++i) {
                com.kingdee.bos.olap.Member mExp = ExprUtil.toMember((Exp)f.getArg(i));
                if (mExp.isCalculated() || !mExp.equals(m) && Util.isDescendentOrEqualTo((com.kingdee.bos.olap.Member)mExp, (com.kingdee.bos.olap.Member)m)) continue;
                remainder.add(mExp);
            }
            return this.createMemberSet(remainder);
        }
        if (f.isCallTo("Union")) {
            Exp e;
            Exp[] uargs = new Exp[]{(Exp)this.removeDescendantsFromFunCall(f.getArg(0), member), (Exp)this.removeDescendantsFromFunCall(f.getArg(1), member)};
            if (uargs[0] == null && uargs[1] == null) {
                return null;
            }
            if (uargs[1] == null) {
                return uargs[0];
            }
            if (uargs[0] == null) {
                return uargs[1];
            }
            if (uargs[0] instanceof com.kingdee.bos.olap.Member) {
                e = uargs[0];
                uargs[0] = new FunCall("{}", new Exp[]{e}, Syntax.Braces);
            }
            if (uargs[1] instanceof com.kingdee.bos.olap.Member) {
                e = uargs[1];
                uargs[1] = new FunCall("{}", new Exp[]{e}, Syntax.Braces);
            }
            return new FunCall("Union", uargs, Syntax.Function);
        }
        throw new QueryAxisManager.CannotHandleException(f.getFunName());
    }

    @Override
    public Exp createMemberSet(List mList) {
        if (mList.size() == 0) {
            return null;
        }
        if (mList.size() == 1) {
            return new MemberExpr((com.kingdee.bos.olap.Member)mList.get(0));
        }
        com.kingdee.bos.olap.Member[] members = (com.kingdee.bos.olap.Member[])mList.toArray(new Member[0]);
        MemberExpr[] remExps = ExprUtil.toExp((com.kingdee.bos.olap.Member[])members);
        return new FunCall("{}", (Exp[])remExps, Syntax.Braces);
    }

    static FunCall removeChildrenFromUnion(FunCall f, com.kingdee.bos.olap.Member kdMember) {
        FunCall f1 = (FunCall)f.getArg(0);
        FunCall f2 = (FunCall)f.getArg(1);
        if (f1.isCallTo("Children") && KDOLAP_QueryAxisUtil.expEqualsMember(f1.getArg(0), kdMember)) {
            return f2;
        }
        if (f2.isCallTo("Children") && KDOLAP_QueryAxisUtil.expEqualsMember(f1.getArg(0), kdMember)) {
            return f1;
        }
        FunCall f1New = f1;
        if (f1.isCallTo("Union")) {
            f1New = KDOLAP_QueryAxisUtil.removeChildrenFromUnion(f1, kdMember);
        }
        FunCall f2New = f2;
        if (f2.isCallTo("Union")) {
            f2New = KDOLAP_QueryAxisUtil.removeChildrenFromUnion(f2, kdMember);
        }
        if (f1 == f1New && f2 == f2New) {
            return f;
        }
        return new FunCall("Union", new Exp[]{f1New, f2New});
    }

    @Override
    public Member memberForObj(Exp oExp) {
        com.kingdee.bos.olap.Member kdMember = ExprUtil.toMember((Exp)oExp);
        Member member = this.model.lookupMember(kdMember.getUniqueName());
        return member;
    }

    @Override
    public Exp objForMember(Member member) {
        return new MemberExpr(((KDOLAP_Member)member).getKDMember());
    }

    @Override
    public Exp objForLevel(Level level) {
        return new LevelExpr(((KDOLAP_Level)level).getKDLevel());
    }

    @Override
    public Exp objForDim(Dimension dim) {
        return new DimensionExpr(((KDOLAP_Dimension)dim).getKDDimension());
    }

    @Override
    public Dimension dimForMember(Member member) {
        return member.getDimension();
    }

    @Override
    public Hierarchy hierForMember(Member member) {
        return member.getHierarchy();
    }

    @Override
    public Level LevelForObj(Exp oLevel) {
        com.kingdee.bos.olap.Level kdLevel = ExprUtil.toLevel((Exp)oLevel);
        return this.model.lookupLevel(kdLevel.getUniqueName());
    }

    @Override
    public int funCallArgCount(Exp oFun) {
        FunCall f = (FunCall)oFun;
        return f.getArgs().length;
    }

    @Override
    public Exp funCallArg(Exp oExp, int index) {
        return ((FunCall)oExp).getArg(index);
    }

    @Override
    public String funCallName(Exp oFun) {
        return ((FunCall)oFun).getFunName();
    }

    @Override
    public void addMemberDescendants(List list, Member member, Level level, IntHolder maxLevel) {
        block4: {
            com.kingdee.bos.olap.Member m = ((KDOLAP_Member)member).getKDMember();
            com.kingdee.bos.olap.Level lev = ((KDOLAP_Level)level).getKDLevel();
            int parentLevel = lev.getDepth() + 1;
            if (parentLevel < maxLevel.value) {
                return;
            }
            if (parentLevel > maxLevel.value) {
                maxLevel.value = parentLevel;
                list.clear();
            }
            if (parentLevel > 0) {
                for (Exp exp : list) {
                    FunCall f;
                    if (!(exp instanceof FunCall) || !(f = (FunCall)exp).isCallTo("Descendants") || !KDOLAP_QueryAxisUtil.expEqualsMember(f.getArg(0), m)) continue;
                    break block4;
                }
                FunCall fChildren = new FunCall("Descendants", new Exp[]{new MemberExpr(m), new LevelExpr(lev)});
                list.add(fChildren);
            }
        }
    }

    @Override
    public Member getParentMember(Exp oExp) {
        com.kingdee.bos.olap.Member m = (com.kingdee.bos.olap.Member)oExp;
        com.kingdee.bos.olap.Member kdParent = m.getParentMember();
        if (kdParent == null) {
            return null;
        }
        Member parent = this.model.lookupMember(kdParent.getUniqueName());
        return parent;
    }

    @Override
    public Exp createFunCall(String function, Exp[] args, int funType) {
        Syntax syntax;
        Exp[] expArgs = new Exp[args.length];
        for (int i = 0; i < expArgs.length; ++i) {
            expArgs[i] = args[i];
        }
        switch (funType) {
            case 2: {
                syntax = Syntax.Braces;
                break;
            }
            case 1: {
                syntax = Syntax.Property;
                break;
            }
            case 3: {
                syntax = Syntax.Parentheses;
                break;
            }
            case 4: {
                syntax = Syntax.Infix;
                break;
            }
            default: {
                syntax = Syntax.Function;
            }
        }
        return new FunCall(function, expArgs, syntax);
    }

    @Override
    public boolean isFunCallTo(Exp oExp, String function) {
        return ((FunCall)oExp).isCallTo(function);
    }

    @Override
    public boolean checkParent(Member pMember, Exp cMemObj) {
        com.kingdee.bos.olap.Member mc = ExprUtil.toMember((Exp)cMemObj);
        if (mc.isCalculated()) {
            return false;
        }
        com.kingdee.bos.olap.Member mp = mc.getParentMember();
        if (mp == null) {
            return false;
        }
        return mp.equals(((KDOLAP_Member)pMember).getKDMember());
    }

    @Override
    public boolean checkChild(Member cMember, Exp pMemObj) {
        com.kingdee.bos.olap.Member mc = ((KDOLAP_Member)cMember).getKDMember();
        if (mc.isCalculated()) {
            return false;
        }
        com.kingdee.bos.olap.Member mp = mc.getParentMember();
        if (mp == null) {
            return false;
        }
        return mp.equals(ExprUtil.toMember((Exp)pMemObj));
    }

    @Override
    public boolean checkDescendantM(Member aMember, Member dMember) {
        com.kingdee.bos.olap.Member kdMember = ((KDOLAP_Member)aMember).getKDMember();
        com.kingdee.bos.olap.Member kdDesc = ((KDOLAP_Member)dMember).getKDMember();
        if (kdDesc.isCalculated() || kdDesc.equals(kdMember)) {
            return false;
        }
        return Util.isDescendentOrEqualTo((com.kingdee.bos.olap.Member)kdDesc, (com.kingdee.bos.olap.Member)kdMember);
    }

    @Override
    public boolean checkDescendantO(Member aMember, Exp oMember) {
        com.kingdee.bos.olap.Member kdMember = ((KDOLAP_Member)aMember).getKDMember();
        com.kingdee.bos.olap.Member kdDesc = ExprUtil.toMember((Exp)oMember);
        if (kdDesc.isCalculated() || kdDesc.equals(kdMember)) {
            return false;
        }
        return Util.isDescendentOrEqualTo((com.kingdee.bos.olap.Member)kdDesc, (com.kingdee.bos.olap.Member)kdMember);
    }

    @Override
    public void addLevelMembers(List list, Level level, IntHolder maxLevel) {
        block4: {
            com.kingdee.bos.olap.Level lev = ((KDOLAP_Level)level).getKDLevel();
            byte iLevel = lev.getDepth();
            if (iLevel < maxLevel.value) {
                return;
            }
            if (iLevel > maxLevel.value) {
                maxLevel.value = iLevel;
                list.clear();
            }
            if (iLevel > 0) {
                for (Exp exp : list) {
                    FunCall f;
                    if (!(exp instanceof FunCall) || !(f = (FunCall)exp).isCallTo("Members")) continue;
                    break block4;
                }
                FunCall fMembers = new FunCall("Members", new Exp[]{new LevelExpr(lev)}, Syntax.Property);
                list.add(fMembers);
            }
        }
    }

    @Override
    public Hierarchy hierForExp(Exp oExp) throws QueryAxisManager.CannotHandleException {
        if (this.isMember(oExp)) {
            return this.model.lookupHierarchy(((MemberExpr)oExp).getMember().getHierarchy().getUniqueName());
        }
        FunCall f = (FunCall)oExp;
        if (f.isCallTo("Children")) {
            com.kingdee.bos.olap.Member m = (com.kingdee.bos.olap.Member)f.getArg(0);
            return this.model.lookupHierarchy(m.getHierarchy().getUniqueName());
        }
        if (f.isCallTo("Descendants")) {
            com.kingdee.bos.olap.Member m = (com.kingdee.bos.olap.Member)f.getArg(0);
            return this.model.lookupHierarchy(m.getHierarchy().getUniqueName());
        }
        if (f.isCallTo("Members")) {
            com.kingdee.bos.olap.Level lev = (com.kingdee.bos.olap.Level)f.getArg(0);
            return this.model.lookupHierarchy(lev.getHierarchy().getUniqueName());
        }
        if (f.isCallTo("Union")) {
            return this.hierForExp(f.getArg(0));
        }
        if (f.isCallTo("{}")) {
            com.kingdee.bos.olap.Member m = (com.kingdee.bos.olap.Member)f.getArg(0);
            return this.model.lookupHierarchy(m.getHierarchy().getUniqueName());
        }
        if (f.isCallTo("TopCount") || f.isCallTo("BottomCount") || f.isCallTo("TopPercent") || f.isCallTo("BottomPercent") || f.isCallTo("Filter")) {
            return this.hierForExp(f.getArg(0));
        }
        throw new QueryAxisManager.CannotHandleException(f.getFunName());
    }

    @Override
    public int levelDepthForMember(Exp oExp) {
        com.kingdee.bos.olap.Member m = ExprUtil.toMember((Exp)oExp);
        com.kingdee.bos.olap.Level level = m.getLevel();
        return level.getDepth();
    }

    @Override
    public Exp topLevelMembers(Hierarchy hier, boolean expandAllMember) {
        return KDOLAP_Util.topLevelMembers(((KDOLAP_Hierarchy)hier).getKDHierarchy(), expandAllMember, this.scr);
    }

    @Override
    public Level getParentLevel(Level level) {
        com.kingdee.bos.olap.Level kdLevel = ((KDOLAP_Level)level).getKDLevel();
        com.kingdee.bos.olap.Level kdParentLevel = kdLevel.getParentLevel();
        return this.model.lookupLevel(kdParentLevel.getUniqueName());
    }

    @Override
    public boolean isMember(Exp oExp) {
        return oExp instanceof MemberExpr;
    }

    @Override
    public boolean isFunCall(Exp oExp) {
        return oExp instanceof FunCall;
    }

    @Override
    public void addMemberSiblings(List list, Member member, IntHolder maxLevel) {
        block4: {
            com.kingdee.bos.olap.Member m = ((KDOLAP_Member)member).getKDMember();
            byte level = m.getLevel().getDepth();
            if (level < maxLevel.value) {
                return;
            }
            if (level > maxLevel.value) {
                maxLevel.value = level;
                list.clear();
            }
            if (level > 0) {
                com.kingdee.bos.olap.Member parent = m.getParentMember();
                for (Exp exp : list) {
                    FunCall f;
                    if (!(exp instanceof FunCall) || !(f = (FunCall)exp).isCallTo("Children") || !KDOLAP_QueryAxisUtil.expEqualsMember(f.getArg(0), parent)) continue;
                    break block4;
                }
                FunCall fSiblings = new FunCall("Children", new Exp[]{new MemberExpr(parent)}, Syntax.Property);
                list.add(fSiblings);
            }
        }
    }

    @Override
    public void addMemberChildren(List list, Member member, IntHolder maxLevel) {
        block4: {
            com.kingdee.bos.olap.Member m = ((KDOLAP_Member)member).getKDMember();
            int childLevel = m.getLevel().getDepth() + 1;
            if (childLevel < maxLevel.value) {
                return;
            }
            if (childLevel > maxLevel.value) {
                maxLevel.value = childLevel;
                list.clear();
            }
            if (childLevel > 0) {
                for (Exp exp : list) {
                    FunCall f;
                    if (!(exp instanceof FunCall) || !(f = (FunCall)exp).isCallTo("Children") || !KDOLAP_QueryAxisUtil.expEqualsMember(f.getArg(0), m)) continue;
                    break block4;
                }
                FunCall fChildren = new FunCall("Children", new Exp[]{new MemberExpr(m)}, Syntax.Property);
                list.add(fChildren);
            }
        }
    }

    @Override
    public void addMemberUncles(List list, Member member, IntHolder maxLevel) {
        block4: {
            com.kingdee.bos.olap.Member m = ((KDOLAP_Member)member).getKDMember();
            int parentLevel = m.getLevel().getDepth() - 1;
            if (parentLevel < maxLevel.value) {
                return;
            }
            if (parentLevel > maxLevel.value) {
                maxLevel.value = parentLevel;
                list.clear();
            }
            if (parentLevel > 0) {
                com.kingdee.bos.olap.Member parent = m.getParentMember();
                com.kingdee.bos.olap.Member grandPa = parent.getParentMember();
                for (Exp exp : list) {
                    FunCall f;
                    if (!(exp instanceof FunCall) || !(f = (FunCall)exp).isCallTo("Children") || !KDOLAP_QueryAxisUtil.expEqualsMember(f.getArg(0), grandPa)) continue;
                    break block4;
                }
                FunCall fUncles = new FunCall("Children", new Exp[]{new MemberExpr(grandPa)}, Syntax.Property);
                list.add(fUncles);
            }
        }
    }

    @Override
    public String getMemberUniqueName(Exp oExp) {
        com.kingdee.bos.olap.Member m = (com.kingdee.bos.olap.Member)oExp;
        return m.getUniqueName();
    }

    @Override
    public StringBuffer funString(Exp oFun) {
        FunCall f = (FunCall)oFun;
        StringBuffer buf = new StringBuffer();
        if (f.isCallTo("Children")) {
            com.kingdee.bos.olap.Member m = ExprUtil.toMember((Exp)f.getArg(0));
            buf.append(m.getUniqueName());
            buf.append(".children");
        } else if (f.isCallTo("Descendants")) {
            com.kingdee.bos.olap.Member m = ExprUtil.toMember((Exp)f.getArg(0));
            com.kingdee.bos.olap.Level lev = ExprUtil.toLevel((Exp)f.getArg(1));
            buf.append("Descendants(");
            buf.append(m.getUniqueName());
            buf.append(",");
            buf.append(lev.getUniqueName());
            buf.append(")");
        } else if (f.isCallTo("members")) {
            com.kingdee.bos.olap.Level lev = ExprUtil.toLevel((Exp)f.getArg(0));
            buf.append(lev.getUniqueName());
            buf.append(".Members");
        } else if (f.isCallTo("Union")) {
            buf.append("Union(");
            FunCall f1 = (FunCall)f.getArg(0);
            buf.append(this.funString((Exp)f1));
            buf.append(",");
            FunCall f2 = (FunCall)f.getArg(1);
            buf.append(this.funString((Exp)f2));
            buf.append(")");
        } else if (f.isCallTo("{}")) {
            buf.append("{");
            for (int i = 0; i < f.getArgs().length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                com.kingdee.bos.olap.Member m = ExprUtil.toMember((Exp)f.getArg(i));
                buf.append(m.getUniqueName());
            }
            buf.append("}");
        } else if (f.isCallTo("TopCount") || f.isCallTo("BottomCount") || f.isCallTo("TopPercent") || f.isCallTo("BottomPercent")) {
            buf.append(f.getFunName());
            buf.append("(");
            FunCall f1 = (FunCall)f.getArg(0);
            buf.append(this.funString((Exp)f1));
            buf.append(")");
        }
        return buf;
    }

    @Override
    public String memberString(Member[] mPath) {
        if (mPath == null || mPath.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mPath.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            com.kingdee.bos.olap.Member m = ((KDOLAP_Member)mPath[i]).getKDMember();
            sb.append(m.getUniqueName());
        }
        return sb.toString();
    }

    @Override
    public boolean equalMember(Exp oExp, Member member) {
        com.kingdee.bos.olap.Member m = ((KDOLAP_Member)member).getKDMember();
        if (oExp instanceof MemberExpr) {
            return m.equals(((MemberExpr)oExp).getMember());
        }
        return false;
    }

    @Override
    public boolean canHandle(Exp oExp) {
        if (this.isMember(oExp)) {
            return true;
        }
        FunCall f = (FunCall)oExp;
        if (f.isCallTo("children")) {
            return true;
        }
        if (f.isCallTo("descendants")) {
            return true;
        }
        if (f.isCallTo("members")) {
            return true;
        }
        if (f.isCallTo("{}")) {
            return true;
        }
        if (f.isCallTo("union")) {
            for (int i = 0; i < f.getArgs().length; ++i) {
                if (this.canHandle(f.getArg(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Exp[] getChildren(Exp oMember) {
        IList members;
        try {
            members = this.scr.getMemberChildren(ExprUtil.toMember((Exp)oMember));
        }
        catch (OLAPException e) {
            members = IList.EMPTY;
        }
        return ExprUtil.toExp((IList)members);
    }

    @Override
    public Exp[] getMembers(Exp exp) {
        IList members;
        block5: {
            try {
                if (exp instanceof LevelExpr) {
                    members = this.scr.getLevelMembers(ExprUtil.toLevel((Exp)exp));
                    break block5;
                }
                if (exp instanceof HierarchyExpr) {
                    members = this.scr.getHierarchyMembers(ExprUtil.toHierarchy((Exp)exp), false);
                    break block5;
                }
                if (exp instanceof DimensionExpr) {
                    members = this.scr.getHierarchyMembers(ExprUtil.toDimension((Exp)exp).getDefaultHierarchy(), false);
                    break block5;
                }
                throw new OLAPException("Can't go here");
            }
            catch (OLAPException e) {
                members = IList.EMPTY;
            }
        }
        return ExprUtil.toExp((IList)members);
    }

    @Override
    public Exp[] getLevelMembers(Level level) {
        IList members;
        com.kingdee.bos.olap.Level kdLevel = ((KDOLAP_Level)level).getKDLevel();
        try {
            members = this.scr.getLevelMembers(kdLevel);
        }
        catch (OLAPException e) {
            members = IList.EMPTY;
        }
        return ExprUtil.toExp((IList)members);
    }

    private static boolean expEqualsMember(Exp exp, com.kingdee.bos.olap.Member member) {
        return exp != null && exp instanceof MemberExpr && ((MemberExpr)exp).getMember().equals(member);
    }
}

