/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.ui;

import com.kingdee.bos.ctrl.analysis.olap.Cell;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.Result;
import com.kingdee.bos.ctrl.analysis.report.ui.ColumnFilter;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.util.ArrayList;
import java.util.List;

class ValueColFilter
implements ColumnFilter {
    Position position = null;
    List cellList = null;
    String compare1 = null;
    String compare2 = null;
    boolean logicAnd = true;
    String value1 = null;
    String value2 = null;
    boolean showAll = true;
    KDPanel container = null;

    @Override
    public boolean checkSelectionNull() {
        return false;
    }

    @Override
    public KDPanel getContainer() {
        return this.container;
    }

    @Override
    public boolean sameCol(Object obj) {
        if (obj instanceof ValueColFilter) {
            String uniqueName = ((ValueColFilter)obj).getPostionsUniqueName();
            return this.getPostionsUniqueName().equals(uniqueName);
        }
        return false;
    }

    @Override
    public Object clone() {
        ValueColFilter o = new ValueColFilter();
        o.position = this.position;
        o.container = this.container;
        o.cellList = new ArrayList(this.cellList);
        o.compare1 = this.compare1;
        o.compare2 = this.compare2;
        o.value1 = this.value1;
        o.value2 = this.value2;
        o.logicAnd = this.logicAnd;
        o.showAll = this.showAll;
        return o;
    }

    @Override
    public boolean isShowAll() {
        return this.showAll;
    }

    @Override
    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    public String toString() {
        String filterPrompt = "   ";
        if (!this.isShowAll()) {
            filterPrompt = "!  ";
        }
        return filterPrompt + this.position.toString();
    }

    @Override
    public String getCondition() {
        String condition = "";
        String condition1 = "";
        if (!this.compare1.equals("") && !this.value1.equals("")) {
            condition1 = this.getPostionsUniqueName() + this.compare1 + this.value1;
        }
        String condition2 = "";
        if (!this.compare2.equals("") && !this.value2.equals("")) {
            condition2 = this.getPostionsUniqueName() + this.compare2 + this.value2;
        }
        if (!condition1.equals("")) {
            condition = !condition2.equals("") ? condition1 + (this.isLogicAnd() ? " AND " : " OR ") + condition2 : condition1;
        } else if (!condition2.equals("")) {
            condition = condition2;
        }
        return condition;
    }

    public ValueColFilter(Position position, int colIndex, int leftAxisCount, int topAxisCount, Result result, KDPanel container) {
        this.position = position;
        this.container = container;
        this.loadCellList(colIndex, leftAxisCount, topAxisCount, result);
    }

    public void loadCellList(int colIndex, int leftAxisCount, int topAxisCount, Result result) {
        this.cellList = new ArrayList();
        for (int i = 0; i < leftAxisCount; ++i) {
            Cell cell = result.getCell(colIndex, i);
            this.cellList.add(cell);
        }
    }

    public String getCompare1() {
        return this.compare1;
    }

    public void setCompare1(Object compare1) {
        this.compare1 = compare1 == null ? "" : compare1.toString();
    }

    public String getCompare2() {
        return this.compare2;
    }

    public void setCompare2(Object compare2) {
        this.compare2 = compare2 == null ? "" : compare2.toString();
    }

    public boolean isLogicAnd() {
        return this.logicAnd;
    }

    public void setLogicAnd(boolean logicAnd) {
        this.logicAnd = logicAnd;
    }

    public String getValue1() {
        return this.value1;
    }

    public void setValue1(Object value1) {
        this.value1 = value1 == null ? "" : value1.toString();
    }

    public String getValue2() {
        return this.value2;
    }

    public void setValue2(Object value2) {
        this.value2 = value2 == null ? "" : value2.toString();
    }

    public List getCellList() {
        return this.cellList;
    }

    private ValueColFilter() {
    }

    private String getPostionsUniqueName() {
        String uniqueName = "";
        if (this.position == null) {
            return uniqueName;
        }
        Member[] ms = this.position.getMembers();
        for (int i = 0; i < ms.length; ++i) {
            uniqueName = i == 0 ? "(" + ms[i].getUniqueName() : uniqueName + "," + ms[i].getUniqueName();
        }
        if (!uniqueName.equals("")) {
            uniqueName = uniqueName + ")";
        }
        return uniqueName;
    }
}

