/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.util;

import com.kingdee.bos.ctrl.analysis.util.MultiMap;
import java.io.UnsupportedEncodingException;

public class UrlEncoded
extends MultiMap {
    public static final String __ISO_8859_1 = "ISO-8859-1";

    public static String decodeString(String encoded) {
        return UrlEncoded.decodeString(encoded, 0, encoded.length(), __ISO_8859_1);
    }

    public static String decodeString(String encoded, String charset) {
        return UrlEncoded.decodeString(encoded, 0, encoded.length(), charset);
    }

    public static String decodeString(String encoded, int offset, int length, String charset) {
        if (charset == null) {
            charset = __ISO_8859_1;
        }
        byte[] bytes = null;
        int n = 0;
        for (int i = 0; i < length; ++i) {
            char c = encoded.charAt(offset + i);
            if (c < '\u0000' || c > '\u00ff') {
                throw new IllegalArgumentException("Not encoded");
            }
            if (c == '+') {
                if (bytes == null) {
                    bytes = new byte[length * 2];
                    encoded.getBytes(offset, offset + i, bytes, 0);
                    n = i;
                }
                bytes[n++] = 32;
                continue;
            }
            if (c == '%' && i + 2 < length) {
                char cn = encoded.charAt(offset + i + 1);
                byte b = cn >= 'a' && cn <= 'z' ? (byte)(10 + cn - 97) : (cn >= 'A' && cn <= 'Z' ? (byte)(10 + cn - 65) : (byte)(cn - 48));
                cn = encoded.charAt(offset + i + 2);
                b = cn >= 'a' && cn <= 'z' ? (byte)(b * 16 + 10 + cn - 97) : (cn >= 'A' && cn <= 'Z' ? (byte)(b * 16 + 10 + cn - 65) : (byte)(b * 16 + cn - 48));
                if (bytes == null) {
                    bytes = new byte[length * 2];
                    encoded.getBytes(offset, offset + i, bytes, 0);
                    n = i;
                }
                i += 2;
                bytes[n++] = b;
                continue;
            }
            if (n <= 0) continue;
            bytes[n++] = (byte)c;
        }
        if (bytes == null) {
            if (offset == 0 && encoded.length() == length) {
                return encoded;
            }
            return encoded.substring(offset, offset + length);
        }
        try {
            return new String(bytes, 0, n, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes, 0, n);
        }
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString(string, __ISO_8859_1);
    }

    public static String encodeString(String string, String charset) {
        if (charset == null) {
            charset = __ISO_8859_1;
        }
        byte[] bytes = null;
        try {
            bytes = string.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            bytes = string.getBytes();
        }
        int len = bytes.length;
        byte[] encoded = new byte[bytes.length * 3];
        int n = 0;
        boolean noEncode = true;
        for (int i = 0; i < len; ++i) {
            byte b = bytes[i];
            if (b == 32) {
                noEncode = false;
                encoded[n++] = 43;
                continue;
            }
            if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57) {
                encoded[n++] = b;
                continue;
            }
            noEncode = false;
            encoded[n++] = 37;
            byte nibble = (byte)((b & 0xF0) >> 4);
            encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
            nibble = (byte)(b & 0xF);
            encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
        }
        if (noEncode) {
            return string;
        }
        try {
            return new String(encoded, 0, n, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(encoded, 0, n);
        }
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

