/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.chart;

import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.web.chart.IMemberFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.olap.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MemberFilterFactory {
    public static IMemberFilter getMemberFilter(OlapModel olapModel, String expr) throws BIReportException {
        return MemberFilterFactory.parse(olapModel, expr);
    }

    private static IMemberFilter parse(OlapModel olapModel, String expr) throws BIReportException {
        IMemberFilter mf = IsLeaf.parse(olapModel, expr);
        if (mf != null) {
            return mf;
        }
        mf = InLevel.parse(olapModel, expr);
        if (mf != null) {
            return mf;
        }
        mf = InLowestLevel.parse(olapModel, expr);
        if (mf != null) {
            return mf;
        }
        return null;
    }

    static class IsLeaf
    implements IMemberFilter {
        Dimension dimension;

        IsLeaf(Dimension dimension) {
            this.dimension = dimension;
        }

        @Override
        public boolean filter(OlapModel olapModel, Member member) {
            return member.isLeaf();
        }

        @Override
        public Dimension getDimension() {
            return this.dimension;
        }

        public static IMemberFilter parse(OlapModel olapModel, String expr) throws BIReportException {
            expr = expr.replaceAll("\\s*|\t|\n", "");
            Matcher m = Pattern.compile("IsLeaf\\((.*)\\)", 2).matcher(expr);
            if (m.find()) {
                String dimName = m.group(1);
                String dimUName = Util.createUName((String)dimName);
                Dimension dim = olapModel.lookupDimension(dimUName);
                if (dim == null) {
                    throw new BIReportException("the arg " + dimName + " in IsLeaf not exist;");
                }
                return new IsLeaf(dim);
            }
            return null;
        }
    }

    static class InLowestLevel
    implements IMemberFilter {
        Dimension dimension;
        ArrayList lowerMembers;

        InLowestLevel(Dimension dimension) {
            this.dimension = dimension;
        }

        @Override
        public boolean filter(OlapModel olapModel, Member member) {
            List visibleMembers = OlapModelUtil.findVisibleMembers(olapModel, this.dimension.getHierarchies()[0]);
            ArrayList<Member> lowerMembers = new ArrayList<Member>();
            int lower = 0;
            for (Member m : visibleMembers) {
                if (m.getDepth() == lower) {
                    lowerMembers.add(m);
                    continue;
                }
                if (m.getDepth() <= lower) continue;
                lower = m.getDepth();
                lowerMembers.clear();
                lowerMembers.add(m);
            }
            return lowerMembers.contains(member);
        }

        @Override
        public Dimension getDimension() {
            return this.dimension;
        }

        public static IMemberFilter parse(OlapModel olapModel, String expr) throws BIReportException {
            expr = expr.replaceAll("\\s*|\t|\n", "");
            Matcher m = Pattern.compile("InLowestLevel\\((.*)\\)", 2).matcher(expr);
            if (m.find()) {
                String dimName = m.group(1);
                String dimUName = Util.createUName((String)dimName);
                Dimension dim = olapModel.lookupDimension(dimUName);
                if (dim == null) {
                    throw new BIReportException("the arg " + dimName + " in InLowestLevel not exist;");
                }
                InLowestLevel f = new InLowestLevel(dim);
                return f;
            }
            return null;
        }
    }

    static class InLevel
    implements IMemberFilter {
        Dimension dimension;
        int index;

        InLevel(Dimension dimension) {
            this.dimension = dimension;
        }

        @Override
        public boolean filter(OlapModel olapModel, Member member) {
            return member.getDepth() == this.index;
        }

        @Override
        public Dimension getDimension() {
            return this.dimension;
        }

        public static IMemberFilter parse(OlapModel olapModel, String expr) throws BIReportException {
            expr = expr.replaceAll("\\s*|\t|\n", "");
            Matcher m = Pattern.compile("InLevel\\((.*),(.*)\\)", 2).matcher(expr);
            if (m.find()) {
                String dimName = m.group(1);
                String i = m.group(2);
                String dimUName = Util.createUName((String)dimName);
                Dimension dim = olapModel.lookupDimension(dimUName);
                if (dim == null) {
                    throw new BIReportException("the arg " + dimName + " in InLevel not exist;");
                }
                int index = -1;
                try {
                    index = Integer.parseInt(i);
                }
                catch (NumberFormatException e) {
                    throw new BIReportException("the arg " + i + " in InLevel must be Integer.");
                }
                InLevel f = new InLevel(dim);
                f.index = index;
                return f;
            }
            return null;
        }
    }
}

