/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONString;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardException;
import com.kingdee.bos.ctrl.analysis.web.dashboard.SQLUtil;
import com.kingdee.bos.ctrl.analysis.web.dashboard.chart.ChartConfig;
import com.kingdee.bos.ctrl.analysis.web.dashboard.chart.ChartFactory;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.freechart.chart.ChartRenderingInfo;
import com.kingdee.bos.ctrl.freechart.chart.JFreeChart;
import com.kingdee.bos.ctrl.freechart.chart.entity.ChartEntity;
import com.kingdee.bos.ctrl.freechart.chart.entity.EntityCollection;
import com.kingdee.bos.ctrl.freechart.chart.entity.StandardEntityCollection;
import com.kingdee.bos.ctrl.freechart.chart.imagemap.StandardToolTipTagFragmentGenerator;
import com.kingdee.bos.ctrl.freechart.chart.imagemap.StandardURLTagFragmentGenerator;
import com.kingdee.bos.ctrl.freechart.chart.imagemap.ToolTipTagFragmentGenerator;
import com.kingdee.bos.ctrl.freechart.chart.imagemap.URLTagFragmentGenerator;
import com.kingdee.bos.ctrl.freechart.chart.servlet.ServletUtilities;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DataSource {
    private static final Logger logger = CommonLogger.getLogger(DataSource.class);
    private static final Map tempDSMap = Collections.synchronizedMap(new HashMap());
    private String[] fusionCharts = new String[]{"Bar", "BarH", "Bar3D", "Bar3DH", "StackedBar", "StackedBarH", "StackedBar3D", "StackedBar3DH", "Line", "Area", "StackedArea", "BarLine"};
    private static final String QUERY_SQL_ALIAS = "FSDCJBDJVCBV";
    private static final String SPLIT_KPI_1 = "@/";
    private static final String SPLIT_KPI_2 = "@//";
    private static final String SPLIT_KPI_3 = "@///";
    private static String goodColor = Constants.CONFIGURETYPE_KPICOLOR_GOOD;
    private static String warningColor = Constants.CONFIGURETYPE_KPICOLOR_WARNING;
    private static String dangerColor = Constants.CONFIGURETYPE_KPICOLOR_DANGER;
    private static String H_COLOR = "&colorI=0X" + dangerColor + "&colorII=0X" + warningColor + "&colorIII=0X" + goodColor;
    private static String L_COLOR = "&colorI=0X" + goodColor + "&colorII=0X" + warningColor + "&colorIII=0X" + dangerColor;
    private static String[] fusionChartColor = new String[]{"FF0000", "00CC00", "0066FF", "FFFF00", "00CCFF", "00FFFF", "FF00FF", "9900FF", "996633", "9999CC", "666600", "663366", "FFFF00", "FFCC66", "006666", "FF33FF", "CC00FF", "336699", "FF6666", "996666"};
    private String id;
    private String datacenter;
    private String sql;
    private int maxRowCount;
    private SortedMap outputMap;
    private String querySql;
    private List filterList = new ArrayList();

    public DataSource(String id, String datacenter, String sql, int maxRowCount, SortedMap outputMap) {
        this.id = id;
        this.datacenter = datacenter;
        this.sql = sql;
        this.maxRowCount = maxRowCount;
        this.outputMap = outputMap;
        this.makeQuerySql();
    }

    public String getId() {
        return this.id;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getQuerySQL() {
        return this.querySql;
    }

    public synchronized boolean isOverflow(HttpServletRequest req) throws BIReportException {
        return this.isOverflow(req, null);
    }

    public synchronized boolean isOverflow(HttpServletRequest req, List filterList) throws BIReportException {
        String testSql = this.querySql;
        String[] s = this.removeOrderbyClause(testSql);
        if (s != null) {
            testSql = s[0];
        }
        return this.maxRowCount < SQLUtil.getRowConut(req, this.datacenter, testSql.replaceFirst("top\\s\\d+\\s", ""), this.createWhereClause(filterList));
    }

    private HashMap getFieldTypeMap(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        HashMap<String, String> map = new HashMap<String, String>();
        int count = rsmd.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String name = rsmd.getColumnName(i + 1);
            int type = rsmd.getColumnType(i + 1);
            String jsType = this.sqlTypeToJsType(type);
            map.put(name.toLowerCase(), jsType);
        }
        return map;
    }

    private String sqlTypeToJsType(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 7: {
                return "float";
            }
            case 4: 
            case 5: {
                return "int";
            }
            case -5: {
                return "int";
            }
            case -7: 
            case 16: {
                return "int";
            }
            case 6: 
            case 8: {
                return "float";
            }
            case 1: 
            case 12: {
                return "string";
            }
            case 91: 
            case 92: 
            case 93: {
                return "date";
            }
        }
        return "string";
    }

    public String toTreePickerString(HttpServletRequest req, final List outputList, boolean includeHead, boolean includeFieldType, List filterList) throws BIReportException {
        String sql = this.querySql;
        String[] s = this.removeOrderbyClause(sql);
        String whereClause = this.createWhereClause(filterList);
        sql = s != null ? "select * from (" + s[0] + ") as WJNDFJBVUV " + whereClause + s[1] : "select * from (" + sql + ") as FNVJNBERUHW " + whereClause;
        return (String)SQLUtil.handleResultSet(req, this.datacenter, sql, new SQLUtil.ResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                StringBuffer sb = new StringBuffer();
                while (rs.next()) {
                    Iterator it = outputList.iterator();
                    while (it.hasNext()) {
                        Object v = rs.getObject(it.next() + "");
                        if (v instanceof Date) {
                            v = new SimpleDateFormat("MM/dd/yyyy").format((Date)v);
                        }
                        sb.append(v).append(",");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append(DataSource.SPLIT_KPI_3);
                }
                if (sb.length() > 0) {
                    return sb.toString().substring(0, sb.toString().length() - DataSource.SPLIT_KPI_3.length());
                }
                return sb.toString();
            }
        }, "\u65e0\u6cd5\u4ece\u6570\u636e\u6e90\u83b7\u5f97\u6570\u636e");
    }

    public String getTreePickerSql() throws BIReportException {
        return this.querySql;
    }

    public String toJSONString(HttpServletRequest req, final List outputList, final boolean includeHead, final boolean includeFieldType, List filterList) throws BIReportException {
        String sql = this.querySql;
        String[] s = this.removeOrderbyClause(sql);
        String whereClause = this.createWhereClause(filterList);
        sql = s != null ? "select * from (" + s[0] + ") as WJNDFJBVUV " + whereClause + s[1] : "select * from (" + sql + ") as FNVJNBERUHW " + whereClause;
        return (String)SQLUtil.handleResultSet(req, this.datacenter, sql, new SQLUtil.ResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                Iterator it;
                StringBuffer sb = new StringBuffer();
                if (includeHead) {
                    sb.append("[");
                    it = outputList.iterator();
                    while (it.hasNext()) {
                        sb.append(new JSONString(it.next() + "")).append(",");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append("],");
                }
                if (includeFieldType) {
                    HashMap map = DataSource.this.getFieldTypeMap(rs);
                    sb.append("[");
                    for (String name : outputList) {
                        String type = (String)map.get(name.toLowerCase());
                        sb.append(new JSONString(type)).append(",");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append("],");
                }
                while (rs.next()) {
                    sb.append("[");
                    it = outputList.iterator();
                    while (it.hasNext()) {
                        Object v = rs.getObject(it.next() + "");
                        if (v instanceof Date) {
                            v = new SimpleDateFormat("MM/dd/yyyy").format((Date)v);
                        }
                        sb.append(new JSONString(v + "")).append(",");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append("],");
                }
                if (sb.toString().trim().length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                return "[" + sb.toString() + "]";
            }
        }, "\u65e0\u6cd5\u4ece\u6570\u636e\u6e90\u83b7\u5f97\u6570\u636e");
    }

    public String getQuerySql(HttpServletRequest req, List outputList, boolean includeHead, boolean includeFieldType, List filterList) throws BIReportException {
        String sql = this.querySql;
        String[] s = this.removeOrderbyClause(sql);
        String whereClause = this.createWhereClause(filterList);
        sql = s != null ? "select * from (" + s[0] + ") as WJNDFJBVUV " + whereClause + s[1] : "select * from (" + sql + ") as FNVJNBERUHW " + whereClause;
        return sql;
    }

    public String getChartSrc(final HttpServletRequest req) throws BIReportException {
        return this.getChartSrc(new ChartConfig(){

            @Override
            public DataSource getDataSource() {
                return DataSource.this;
            }

            @Override
            public HttpServletRequest getRequest() {
                return req;
            }
        });
    }

    private boolean isExistInFusionCharts(String chartType) {
        boolean exist = false;
        for (int i = 0; i < this.fusionCharts.length; ++i) {
            String chart = this.fusionCharts[i].toString();
            if (!chartType.equalsIgnoreCase(chart)) continue;
            exist = true;
            break;
        }
        return exist;
    }

    public String getChartSrc(ChartConfig cc) throws BIReportException {
        HttpServletRequest req = cc.getRequest();
        String chartType = cc.getType();
        int width = cc.getWidth();
        int height = cc.getHeight();
        ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
        JFreeChart chart = ChartFactory.create(cc);
        try {
            String fileName = ServletUtilities.saveChartAsPNG((JFreeChart)chart, (int)width, (int)height, (ChartRenderingInfo)info, (HttpSession)req.getSession());
            StringBuffer sb = new StringBuffer();
            sb.append("<map name=\"" + fileName + "\">");
            if (info != null) {
                EntityCollection entities = info.getEntityCollection();
                for (ChartEntity entity : entities) {
                    String area = "";
                    area = entity.getImageMapAreaTag((ToolTipTagFragmentGenerator)new StandardToolTipTagFragmentGenerator(), (URLTagFragmentGenerator)new StandardURLTagFragmentGenerator());
                    if ((area = area.replaceAll("&", "&amp;")).length() <= 0) continue;
                    sb.append(area);
                }
            }
            sb.append("</map>");
            String graphURL = req.getContextPath() + "/BIReport?" + "servletType" + "=" + "GetChart" + "&filename=" + fileName;
            sb.append("<img src=\"" + graphURL).append("\" style=\"border:0;\" usemap=\"#").append(fileName).append("\"</img>");
            if (!this.isExistInFusionCharts(chartType)) {
                return "<div>" + sb.toString() + "</div>";
            }
            return this.buildFusionchartXML(sb.toString(), cc);
        }
        catch (IOException e) {
            logger.warn((Object)"\u670d\u52a1\u7aef\u51fa\u73b0IO\u9519\u8bef\uff0c\u751f\u6210\u56fe\u8868\u5931\u8d25\u3002", (Throwable)e);
            return "\u670d\u52a1\u7aef\u51fa\u73b0IO\u9519\u8bef\uff0c\u751f\u6210\u56fe\u8868\u5931\u8d25\u3002";
        }
    }

    private String buildFusionchartXML(String data, ChartConfig cc) {
        String value;
        String key;
        String setValue;
        String xml = "";
        List e = null;
        ArrayList<String> lst_category = new ArrayList<String>();
        ArrayList<String> lst_dataSet = new ArrayList<String>();
        HashMap<String, String> map_value = new HashMap<String, String>();
        String chartType = cc.getType();
        String[] xs = cc.getXColumns();
        try {
            String text = data.substring(0, data.indexOf("<img"));
            Document document = DocumentHelper.parseText((String)text);
            e = document.getRootElement().elements();
        }
        catch (DocumentException ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < e.size(); ++i) {
            String[] title = ((Element)e.get(i)).attributeValue("title").split("=");
            String[] info = title[0].trim().substring(1, title[0].trim().length() - 1).split(",");
            String category = this.getCategory(info, xs.length);
            String dataset = this.getDataSet(info, xs.length);
            String key2 = dataset + "," + category;
            map_value.put(key2, title[1]);
            if (!this.existList(lst_category, category)) {
                lst_category.add(category);
            }
            if (this.existList(lst_dataSet, dataset)) continue;
            lst_dataSet.add(dataset);
        }
        if (chartType.equalsIgnoreCase("Bar") || chartType.equalsIgnoreCase("BarH")) {
            String dataSet = "";
            for (int i = 0; i < lst_dataSet.size(); ++i) {
                setValue = "";
                dataSet = dataSet + "<dataset seriesname='" + lst_dataSet.get(i) + "' color='" + this.getCategorycColor(i) + "'  showValues='0' >";
                for (int y = 0; y < lst_category.size(); ++y) {
                    key = lst_dataSet.get(i) + "," + lst_category.get(y);
                    value = String.valueOf(map_value.get(key)).replaceAll(",", "").replaceAll("null", "");
                    setValue = setValue + "<set value='" + value + "' />";
                }
                dataSet = dataSet + setValue + "</dataset>";
            }
            xml = "<chart palette='2' caption='' formatNumberScale='0' baseFontSize='12'  shownames='1' showvalues='0' numberPrefix='' useRoundEdges='1' legendBorderAlpha='0'> <categories>" + this.listToString(lst_category) + " </categories>" + dataSet + "</chart>";
        } else if (chartType.equalsIgnoreCase("Bar3D") || chartType.equalsIgnoreCase("Bar3DH")) {
            String dataSet = "";
            for (int i = 0; i < lst_dataSet.size(); ++i) {
                setValue = "";
                dataSet = dataSet + "<dataset seriesname='" + lst_dataSet.get(i) + "' color='" + this.getCategorycColor(i) + "'  showValues='0' >";
                for (int y = 0; y < lst_category.size(); ++y) {
                    key = lst_dataSet.get(i) + "," + lst_category.get(y);
                    value = String.valueOf(map_value.get(key)).replaceAll(",", "").replaceAll("null", "");
                    setValue = setValue + "<set value='" + value + "' />";
                }
                dataSet = dataSet + setValue + "</dataset>";
            }
            xml = "<chart palette='2' caption='' formatNumberScale='0' baseFontSize='12'  shownames='1' showvalues='0' numberPrefix=''> <categories>" + this.listToString(lst_category) + " </categories>" + dataSet + "</chart>";
        } else if (chartType.equalsIgnoreCase("StackedBar") || chartType.equalsIgnoreCase("StackedBarH")) {
            String dataSet = "";
            for (int i = 0; i < lst_dataSet.size(); ++i) {
                setValue = "";
                dataSet = dataSet + "<dataset seriesname='" + lst_dataSet.get(i) + "' color='" + this.getCategorycColor(i) + "'  showValues='0' >";
                for (int y = 0; y < lst_category.size(); ++y) {
                    key = lst_dataSet.get(i) + "," + lst_category.get(y);
                    value = String.valueOf(map_value.get(key)).replaceAll(",", "").replaceAll("null", "");
                    setValue = setValue + "<set value='" + value + "'/>";
                }
                dataSet = dataSet + setValue + "</dataset>";
            }
            xml = "<chart palette='2' caption='' formatNumberScale='0' baseFontSize='12' shownames='1' showvalues='0'  numberPrefix='' showSum='1' useRoundEdges='1'> <categories>" + this.listToString(lst_category) + " </categories>" + dataSet + "</chart>";
        } else if (chartType.equalsIgnoreCase("StackedBar3D") || chartType.equalsIgnoreCase("StackedBar3DH")) {
            String dataSet = "";
            for (int i = 0; i < lst_dataSet.size(); ++i) {
                setValue = "";
                dataSet = dataSet + "<dataset seriesname='" + lst_dataSet.get(i) + "' color='" + this.getCategorycColor(i) + "'  showValues='0' >";
                for (int y = 0; y < lst_category.size(); ++y) {
                    key = lst_dataSet.get(i) + "," + lst_category.get(y);
                    value = String.valueOf(map_value.get(key)).replaceAll(",", "").replaceAll("null", "");
                    setValue = setValue + "<set value='" + value + "'/>";
                }
                dataSet = dataSet + setValue + "</dataset>";
            }
            xml = "<chart palette='1' caption='' formatNumberScale='0' baseFontSize='12' shownames='1' showvalues='0'  numberPrefix='' showSum='1' overlapBars='0' showShadow='1'> <categories>" + this.listToString(lst_category) + " </categories>" + dataSet + "</chart>";
        } else if (chartType.equalsIgnoreCase("Line")) {
            String dataSet = "";
            for (int i = 0; i < lst_dataSet.size(); ++i) {
                setValue = "";
                dataSet = dataSet + "<dataset seriesname='" + lst_dataSet.get(i) + "' color='" + this.getCategorycColor(i) + "' anchorBorderColor='" + this.getCategorycColor(i) + "' anchorBgColor='" + this.getCategorycColor(i) + "' showValues='0' >";
                for (int y = 0; y < lst_category.size(); ++y) {
                    key = lst_dataSet.get(i) + "," + lst_category.get(y);
                    value = String.valueOf(map_value.get(key)).replaceAll(",", "").replaceAll("null", "");
                    setValue = setValue + "<set value='" + value + "'/>";
                }
                dataSet = dataSet + setValue + "</dataset>";
            }
            xml = "<chart caption='' subcaption='' formatNumberScale='0' baseFontSize='12'  lineThickness='1' showValues='0' formatNumberScale='0' anchorRadius='2'   divLineAlpha='20' divLineColor='CC3300' divLineIsDashed='1' showAlternateHGridColor='1' alternateHGridAlpha='5' alternateHGridColor='CC3300' shadowAlpha='40' labelStep='2' numvdivlines='5' chartRightMargin='35' bgColor='FFFFFF,CC3300' bgAngle='270' bgAlpha='10,10'> <categories>" + this.listToString(lst_category) + " </categories>" + dataSet + "</chart>";
        } else if (chartType.equalsIgnoreCase("Area")) {
            String dataSet = "";
            for (int i = 0; i < lst_dataSet.size(); ++i) {
                setValue = "";
                dataSet = dataSet + "<dataset seriesname='" + lst_dataSet.get(i) + "' color='" + this.getCategorycColor(i) + "' showValues='0' areaAlpha='70' formatNumberScale='0'  showAreaBorder='0' areaBorderThickness='2' areaBorderColor='FF0000'>";
                for (int y = 0; y < lst_category.size(); ++y) {
                    key = lst_dataSet.get(i) + "," + lst_category.get(y);
                    value = String.valueOf(map_value.get(key)).replaceAll(",", "").replaceAll("null", "");
                    setValue = setValue + "<set value='" + value + "'/>";
                }
                dataSet = dataSet + setValue + "</dataset>";
            }
            xml = "<chart bgColor='E9E9E9' baseFontSize='12' formatNumberScale='0' outCnvBaseFontColor='666666' caption=''  xAxisName='' yAxisName='' numberPrefix='' showNames='1' showValues='0'  plotFillAlpha='50' numVDivLines='10' showAlternateVGridColor='1' AlternateVGridColor='e1f5ff' divLineColor='e1f5ff' vdivLineColor='e1f5ff'  baseFontColor='666666'canvasBorderThickness='1' showPlotBorder='1' plotBorderThickness='0'> <categories>" + this.listToString(lst_category) + " </categories>" + dataSet + "</chart>";
        } else if (chartType.equalsIgnoreCase("StackedArea")) {
            String dataSet = "";
            for (int i = 0; i < lst_dataSet.size(); ++i) {
                setValue = "";
                dataSet = dataSet + "<dataset seriesname='" + lst_dataSet.get(i) + "' color='" + this.getCategorycColor(i) + "' areaAlpha='70' baseFontSize='12' formatNumberScale='0'  showAreaborder='0' areaBorderThickness='1' areaBorderColor='7B9D9D'>";
                for (int y = 0; y < lst_category.size(); ++y) {
                    key = lst_dataSet.get(i) + "," + lst_category.get(y);
                    value = String.valueOf(map_value.get(key)).replaceAll(",", "").replaceAll("null", "");
                    setValue = setValue + "<set value='" + value + "'/>";
                }
                dataSet = dataSet + setValue + "</dataset>";
            }
            xml = "<chart bgColor='E9E9E9' formatNumberScale='0' baseFontSize='12' outCnvBaseFontColor='666666' caption=''  xAxisName='' yAxisName='' numberPrefix='' showValues='0'  numVDivLines='10' showAlternateVGridColor='1' AlternateVGridColor='e1f5ff' divLineColor='e1f5ff' vdivLineColor='e1f5ff'  baseFontColor='666666' toolTipBgColor='F3F3F3' toolTipBorderColor='666666' canvasBorderColor='666666' canvasBorderThickness='1' showPlotBorder='1' plotFillAlpha='80'> <categories>" + this.listToString(lst_category) + " </categories>" + dataSet + "</chart>";
        } else if (chartType.equalsIgnoreCase("BarLine")) {
            String dataSet = "";
            for (int i = 0; i < lst_dataSet.size(); ++i) {
                setValue = "";
                dataSet = i == lst_dataSet.size() - 1 ? dataSet + "<dataset seriesname='" + lst_dataSet.get(i) + "' color='" + this.getCategorycColor(i) + "' showValues='0' parentYAxis='S'>" : dataSet + "<dataset seriesname='" + lst_dataSet.get(i) + "' color='" + this.getCategorycColor(i) + "' showValues='0'>";
                for (int y = 0; y < lst_category.size(); ++y) {
                    key = lst_dataSet.get(i) + "," + lst_category.get(y);
                    value = String.valueOf(map_value.get(key)).replaceAll(",", "").replaceAll("null", "");
                    setValue = setValue + "<set value='" + value + "'/>";
                }
                dataSet = dataSet + setValue + "</dataset>";
            }
            xml = "<chart palette='1' caption='' formatNumberScale='0'  baseFontSize='12' shownames='1' showvalues='0' numberPrefix=''  connectNullData='0' PYAxisName='' SYAxisName=''  numDivLines='4' formatNumberScale='0'><categories>" + this.listToString(lst_category) + " </categories>" + dataSet + "</chart>";
        }
        return xml;
    }

    private String getCategorycColor(int i) {
        if (i < fusionChartColor.length) {
            return fusionChartColor[i];
        }
        Random ran = new Random();
        return String.valueOf(ran.nextInt(9)) + String.valueOf(ran.nextInt(9)) + String.valueOf(ran.nextInt(9)) + String.valueOf(ran.nextInt(9)) + String.valueOf(ran.nextInt(9)) + String.valueOf(ran.nextInt(9));
    }

    private String getCategory(String[] info, int length) {
        String value = "";
        int num = info.length - length;
        for (int i = 0; i < length; ++i) {
            value = value + info[num] + ",";
            ++num;
        }
        return value.substring(0, value.length() - ",".length());
    }

    private String getDataSet(String[] info, int length) {
        String value = "";
        int num = info.length - length;
        for (int i = 0; i < num; ++i) {
            value = value + info[i] + ",";
        }
        return value.substring(0, value.length() - ",".length());
    }

    private boolean existList(List lst, String comp) {
        boolean exist = false;
        for (int y = 0; y < lst.size(); ++y) {
            String temp = String.valueOf(lst.get(y));
            if (!comp.equals(temp)) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private String listToString(List list) {
        String value = "";
        for (int i = 0; i < list.size(); ++i) {
            String element = String.valueOf(list.get(i));
            value = value + "<category name='" + element + " '/>";
        }
        return value;
    }

    public static void putTempDataSource(DataSource ds) {
        tempDSMap.put(ds.id, ds);
    }

    public static DataSource removeTempDataSource(String id) {
        return (DataSource)tempDSMap.remove(id);
    }

    private void makeQuerySql() {
        if (this.outputMap.size() > 0) {
            Matcher m = Pattern.compile("(.*)(\\sorder\\sby.*)", 2).matcher(this.sql);
            String orderbyClause = "";
            if (m.find()) {
                this.sql = m.group(1);
                orderbyClause = m.group(2);
            }
            StringBuffer sb = new StringBuffer("select top ");
            sb.append(this.maxRowCount).append(" ");
            for (Object column : this.outputMap.keySet()) {
                String alias = (String)this.outputMap.get(column);
                sb.append(column).append(" as ").append(alias).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(" from ( ").append(this.sql).append(" ) as ").append(QUERY_SQL_ALIAS).append(this.createWhereClause(this.filterList)).append(orderbyClause);
            this.querySql = sb.toString();
        } else {
            this.querySql = this.sql;
        }
    }

    private String[] removeOrderbyClause(String sql) {
        Matcher m = Pattern.compile("(.*QUERY_SQL_ALIAS.*?)(\\sorder\\sby.*)", 2).matcher(sql);
        if (m.find()) {
            return new String[]{m.group(1), m.group(2)};
        }
        return null;
    }

    private String createWhereClause(List filterList) {
        if (filterList == null) {
            return "";
        }
        StringBuffer whereClause = new StringBuffer();
        Iterator it = filterList.iterator();
        while (it.hasNext()) {
            whereClause.append(it.next()).append(" AND ");
        }
        int whereLength = whereClause.length();
        if (whereClause.length() > 0) {
            whereClause.delete(whereLength - 4, whereLength - 1);
            if (filterList == this.filterList || this.filterList.size() == 0) {
                whereClause.insert(0, " WHERE ");
            } else {
                whereClause.insert(0, " AND ");
            }
        }
        return whereClause.toString();
    }

    public JSON addFilter(HttpServletRequest request) throws DashBoardException {
        String[] filter = request.getParameterValues("filter");
        this.filterList.addAll(Arrays.asList(filter));
        this.makeQuerySql();
        return null;
    }

    public String onKPIChange(HttpServletRequest req, List lst) throws BIReportException {
        String json = "";
        String[] Jsons = null;
        json = this.getKPIInfo(req, lst, null);
        Jsons = json.substring(0, json.length() - SPLIT_KPI_2.length()).split(SPLIT_KPI_2);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < Jsons.length; ++i) {
            set.add(Jsons[i]);
        }
        json = "";
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String element = String.valueOf(it.next());
            json = json + element + SPLIT_KPI_1;
        }
        return json.substring(0, json.length() - SPLIT_KPI_1.length());
    }

    private void getKPIColor(HttpServletRequest req) {
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        String sql = "SELECT FParamvalue FROM T_BI_SystemConfigure WHERE FConfigureType='" + Constants.CONFIGURETYPE_KPICOLOR + "'";
        try {
            con = BISystem.getJdbcConnection(req);
            st = con.createStatement();
            rs = st.executeQuery(sql);
            while (rs.next()) {
                String paramvalue = rs.getString("fparamvalue");
                String goodColor = paramvalue.split(SPLIT_KPI_2)[0];
                String warningColor = paramvalue.split(SPLIT_KPI_2)[1];
                String dangerColor = paramvalue.split(SPLIT_KPI_2)[2];
                L_COLOR = "&colorI=0X" + goodColor.substring(1, goodColor.length()) + "&colorII=0X" + warningColor.substring(1, warningColor.length()) + "&colorIII=0X" + dangerColor.substring(1, dangerColor.length());
                H_COLOR = "&colorI=0X" + dangerColor.substring(1, dangerColor.length()) + "&colorII=0X" + warningColor.substring(1, warningColor.length()) + "&colorIII=0X" + goodColor.substring(1, goodColor.length());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public JSON getSliderDate(HttpServletRequest req, List outputList) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("data", this.toJSONString(req, outputList, true, false, null));
        }
        catch (BIReportException e) {
            e.printStackTrace();
        }
        return new JSONMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getGridPanelData(HttpServletRequest req) {
        ResultSet rs;
        PreparedStatement pst;
        Connection con;
        StringBuffer sb;
        block9: {
            sb = new StringBuffer();
            String sql = req.getParameter("sql");
            String dataCenter = req.getParameter("datacenter");
            int start = Integer.parseInt(req.getParameter("start"));
            int limit = Integer.parseInt(req.getParameter("limit"));
            int cn = 0;
            String[] outputList = req.getParameter("outputList").split(",");
            con = null;
            pst = null;
            rs = null;
            try {
                Context ctx = BISystem.getContext(req);
                con = BISystem.getJdbcConnection(ctx, dataCenter);
                sql = SQLUtil.transSystemVar(req, sql);
                pst = con.prepareStatement(sql);
                rs = pst.executeQuery();
                sb.append("{totalProperty:" + SQLUtil.getRowConut(req, dataCenter, sql, "") + ",root:[");
                while (rs.next()) {
                    if (cn >= start && cn < start + limit) {
                        sb.append("{");
                        for (int y = 0; y < outputList.length; ++y) {
                            sb.append("'" + outputList[y] + "':'");
                            sb.append(rs.getObject(outputList[y].toLowerCase()));
                            sb.append("',");
                        }
                        sb.deleteCharAt(sb.length() - 1);
                        sb.append("},");
                    }
                    ++cn;
                }
                if (cn <= 0) break block9;
                sb.deleteCharAt(sb.length() - 1);
            }
            catch (SQLException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
                SQLUtils.cleanup(rs, pst, (Connection)con);
            }
            catch (BIReportException e2) {
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, pst, con);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup(rs, pst, (Connection)con);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pst, (Connection)con);
        sb.append("]}");
        return sb.toString();
    }

    public JSON getProgressData(HttpServletRequest req, List outputList) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("data", this.toJSONString(req, outputList, true, false, null));
        }
        catch (BIReportException e) {
            e.printStackTrace();
        }
        return new JSONMap(map);
    }

    public String getBingdingDataType(Repository rep, String bindingColumn) throws BIReportException {
        String sql = this.querySql;
        String[] s = this.removeOrderbyClause(sql);
        String whereClause = this.createWhereClause(this.filterList);
        sql = s != null ? s[0] + whereClause + s[1] : sql + whereClause;
        String dataType = "String";
        try {
            dataType = this.getColumnType(DataType.fromJdbcType((int)rep.getColumnType(sql, bindingColumn)));
        }
        catch (RepositoryException e1) {
            e1.printStackTrace();
        }
        return dataType;
    }

    public String getColumnType(DataType type) {
        String dataType = "";
        if (DataType.INTEGER.equals(type) || DataType.LONG.equals(type) || DataType.SHORT.equals(type) || DataType.DECIMAL.equals(type) || DataType.FLOAT.equals(type) || DataType.DOUBLE.equals(type)) {
            dataType = "Number";
        } else if (DataType.BOOLEAN.equals(type)) {
            dataType = "Boolean";
        } else if (DataType.STRING.equals(type)) {
            dataType = "String";
        } else if (DataType.DATETIME.equals(type)) {
            dataType = "date";
        }
        return dataType;
    }

    public String getPreviewKPI(HttpServletRequest req, HashMap map, List filterList) throws BIReportException {
        this.getKPIColor(req);
        String json = "";
        String kpis = "";
        String massage = "";
        String maindimensionv = String.valueOf(map.get("maindimensionv"));
        String kpiprojectv = String.valueOf(map.get("kpiprojectv"));
        String intemsInfov = String.valueOf(map.get("intemsInfov"));
        DecimalFormat df = new DecimalFormat("######0.00");
        String[] items = intemsInfov.split(SPLIT_KPI_2);
        try {
            for (int x = 0; x < items.length; ++x) {
                double point;
                String[] temp;
                int i;
                String[] Jsons;
                ArrayList<String> filter;
                String rs = "";
                String[] item = items[x].split(SPLIT_KPI_1);
                String itemName = item[0];
                String kpilabel = item[1];
                String dispalyType = item[2];
                String chartType = item[3];
                String pointv = item[4].replaceAll("undefind", "");
                String minv = item[5].replaceAll("undefind", "");
                String alertv = item[6].replaceAll("undefind", "");
                String goodv = item[7].replaceAll("undefind", "");
                String maxv = item[8].replaceAll("undefind", "");
                ArrayList<String> output = new ArrayList<String>();
                if (!minv.equals("null") && minv.trim().length() > 0 && !maxv.equals("null") && maxv.trim().length() > 0) {
                    output.add(maindimensionv);
                    output.add(pointv);
                    output.add(minv);
                    output.add(alertv);
                    output.add(goodv);
                    output.add(maxv);
                    filter = new ArrayList();
                    filter.add(kpiprojectv + "='" + itemName + "'");
                    if (filterList != null) {
                        for (int z = 0; z < filterList.size(); ++z) {
                            filter.add((String)filterList.get(z));
                        }
                    }
                    json = this.getKPIInfo(req, output, filter).toString();
                    Jsons = json.split(SPLIT_KPI_2);
                    if (json.trim().length() > 0) {
                        for (i = 0; i < Jsons.length; ++i) {
                            temp = Jsons[i].split(SPLIT_KPI_1);
                            point = Double.parseDouble(temp[1]);
                            double min = Double.parseDouble(temp[2]);
                            double alert = Double.parseDouble(temp[3]);
                            double good = Double.parseDouble(temp[4]);
                            double max = Double.parseDouble(temp[5]);
                            if (min < alert && alert < good && good < max) {
                                if (chartType.equals("KPIL")) {
                                    if (Math.abs(point / max) > 0.95) {
                                        max = Math.round(point + Math.abs(point * 0.07));
                                    } else if (Math.abs(point / min) < 1.05) {
                                        min = Math.round(point - Math.abs(point * 0.07));
                                    }
                                    rs = rs + temp[0] + SPLIT_KPI_1 + df.format(min) + "," + df.format(alert) + "," + df.format(good) + "," + df.format(point) + "," + df.format(max) + SPLIT_KPI_1 + "ok";
                                    rs = rs + SPLIT_KPI_1 + L_COLOR + SPLIT_KPI_1 + itemName + SPLIT_KPI_1 + kpilabel + SPLIT_KPI_1 + dispalyType + SPLIT_KPI_1 + chartType + SPLIT_KPI_2;
                                    continue;
                                }
                                if (chartType.equals("KPIH")) {
                                    if (Math.abs(point / max) > 0.95) {
                                        max = Math.round(point + Math.abs(point * 0.07));
                                    } else if (Math.abs(point / min) < 1.2) {
                                        min = Math.round(point - Math.abs(point * 0.07));
                                    }
                                    rs = rs + temp[0] + SPLIT_KPI_1 + df.format(min) + "," + df.format(alert) + "," + df.format(good) + "," + df.format(point) + "," + df.format(max) + SPLIT_KPI_1 + "ok";
                                    rs = rs + SPLIT_KPI_1 + H_COLOR + SPLIT_KPI_1 + itemName + SPLIT_KPI_1 + kpilabel + SPLIT_KPI_1 + dispalyType + SPLIT_KPI_1 + chartType + SPLIT_KPI_2;
                                    continue;
                                }
                                if (!chartType.equals("KPILH")) continue;
                                double middle = (alert + good) / 2.0;
                                double lack = middle - alert;
                                if (point < middle) {
                                    double minimum = min - lack;
                                    if (minimum > point) {
                                        minimum = point;
                                    }
                                    rs = rs + temp[0] + SPLIT_KPI_1 + df.format(minimum) + "," + df.format(min) + "," + df.format(alert) + "," + df.format(point) + "," + df.format(middle) + SPLIT_KPI_1 + "ok";
                                    rs = rs + SPLIT_KPI_1 + L_COLOR + SPLIT_KPI_1 + itemName + SPLIT_KPI_1 + kpilabel + SPLIT_KPI_1 + dispalyType + SPLIT_KPI_1 + chartType + SPLIT_KPI_1 + "KPIL" + SPLIT_KPI_2;
                                    continue;
                                }
                                double maxmum = max + lack;
                                if (point > maxmum) {
                                    maxmum = point;
                                }
                                rs = rs + temp[0] + SPLIT_KPI_1 + df.format(middle) + "," + df.format(good) + "," + df.format(max) + "," + df.format(point) + "," + df.format(maxmum) + SPLIT_KPI_1 + "ok";
                                rs = rs + SPLIT_KPI_1 + H_COLOR + SPLIT_KPI_1 + itemName + SPLIT_KPI_1 + kpilabel + SPLIT_KPI_1 + dispalyType + SPLIT_KPI_1 + chartType + SPLIT_KPI_1 + "KPIH" + SPLIT_KPI_2;
                                continue;
                            }
                            if (chartType.equals("KPILH")) {
                                if (min >= alert) {
                                    massage = "[\u9884\u8b66\u4e0b\u9650]\u5fc5\u987b\u5c0f\u4e8e[\u5173\u6ce8\u4e0b\u9650]\uff01";
                                } else if (alert >= good) {
                                    massage = "[\u5173\u6ce8\u4e0b\u9650]\u5fc5\u987b\u5c0f\u4e8e[\u5173\u6ce8\u4e0a\u9650]\uff01";
                                } else if (good >= max) {
                                    massage = "[\u5173\u6ce8\u4e0a\u9650]\u5fc5\u987b\u5c0f\u4e8e[\u9884\u8b66\u4e0a\u9650]\uff01";
                                }
                            } else if (min >= alert) {
                                massage = "[\u6700\u5dee\u503c]\u5fc5\u987b\u5c0f\u4e8e[\u9884\u8b66\u503c]\uff01";
                            } else if (alert >= good) {
                                massage = chartType.equals("KPIL") ? "[\u9884\u8b66\u503c]\u5fc5\u987b\u5c0f\u4e8e[\u826f\u597d\u503c]\uff01" : "[\u826f\u597d\u503c]\u5fc5\u987b\u5c0f\u4e8e[\u9884\u8b66\u503c]\uff01";
                            } else if (good >= max) {
                                massage = "[\u826f\u597d\u503c]\u5fc5\u987b\u5c0f\u4e8e[\u6700\u5927\u503c]\uff01";
                            }
                            rs = rs + temp[0] + SPLIT_KPI_1 + "0,0,0,0,0" + SPLIT_KPI_1 + "error" + SPLIT_KPI_1 + massage + SPLIT_KPI_1 + item[0] + SPLIT_KPI_2;
                        }
                    }
                } else {
                    output.add(maindimensionv);
                    output.add(pointv);
                    output.add(alertv);
                    output.add(goodv);
                    filter = new ArrayList<String>();
                    filter.add(kpiprojectv + "='" + itemName + "'");
                    if (filterList != null) {
                        for (int z = 0; z < filterList.size(); ++z) {
                            filter.add((String)filterList.get(z));
                        }
                    }
                    json = this.getKPIInfo(req, output, filter).toString();
                    Jsons = json.split(SPLIT_KPI_2);
                    if (json.trim().length() > 0) {
                        for (i = 0; i < Jsons.length; ++i) {
                            temp = Jsons[i].split(SPLIT_KPI_1);
                            point = Double.parseDouble(temp[1]);
                            double alert = Double.parseDouble(temp[2]);
                            double good = Double.parseDouble(temp[3]);
                            if (good > alert) {
                                double low;
                                double high;
                                if (chartType.equals("KPIL")) {
                                    high = good + (good - alert);
                                    low = alert - (good - alert);
                                    if (point < low) {
                                        low = point;
                                    } else if (point > high) {
                                        high = point;
                                    }
                                    rs = rs + temp[0] + SPLIT_KPI_1 + df.format(low) + "," + df.format(alert) + "," + df.format(good) + "," + df.format(point) + "," + df.format(high) + SPLIT_KPI_1 + "ok";
                                    rs = rs + SPLIT_KPI_1 + L_COLOR + SPLIT_KPI_1 + itemName + SPLIT_KPI_1 + kpilabel + SPLIT_KPI_1 + dispalyType + SPLIT_KPI_1 + chartType + SPLIT_KPI_2;
                                    continue;
                                }
                                if (!chartType.equals("KPIH")) continue;
                                high = good + (good - alert);
                                low = alert - (good - alert);
                                if (point > high) {
                                    high = point;
                                } else if (point < low) {
                                    low = point;
                                }
                                rs = rs + temp[0] + SPLIT_KPI_1 + df.format(low) + "," + df.format(alert) + "," + df.format(good) + "," + df.format(point) + "," + df.format(high) + SPLIT_KPI_1 + "ok";
                                rs = rs + SPLIT_KPI_1 + H_COLOR + SPLIT_KPI_1 + itemName + SPLIT_KPI_1 + kpilabel + SPLIT_KPI_1 + dispalyType + SPLIT_KPI_1 + chartType + SPLIT_KPI_2;
                                continue;
                            }
                            if (alert > good) {
                                massage = chartType.equals("KPIL") ? "[\u9884\u8b66\u503c]\u5fc5\u987b\u5c0f\u4e8e[\u826f\u597d\u503c]\uff01" : "[\u826f\u597d\u503c]\u5fc5\u987b\u5c0f\u4e8e[\u9884\u8b66\u503c]\uff01";
                            }
                            rs = rs + temp[0] + SPLIT_KPI_1 + "0,0,0,0,0" + SPLIT_KPI_1 + "error" + SPLIT_KPI_1 + massage + SPLIT_KPI_1 + item[0] + SPLIT_KPI_2;
                        }
                    }
                }
                if (rs.trim().length() <= 0) continue;
                kpis = kpis + rs.substring(0, rs.length() - SPLIT_KPI_2.length()) + SPLIT_KPI_3;
            }
        }
        catch (Exception e) {
            return "error";
        }
        if (kpis.length() > 0) {
            kpis = kpis.substring(0, kpis.length() - SPLIT_KPI_3.length());
        }
        return kpis;
    }

    private String getKPIInfo(HttpServletRequest req, final List outputList, List filterList) throws BIReportException {
        String sql = this.querySql;
        String[] s = this.removeOrderbyClause(sql);
        String whereClause = this.createWhereClause(filterList);
        sql = s != null ? s[0] + whereClause + s[1] : sql + whereClause;
        return (String)SQLUtil.handleResultSet(req, this.datacenter, sql, new SQLUtil.ResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                String sb = "";
                while (rs.next()) {
                    Iterator it = outputList.iterator();
                    while (it.hasNext()) {
                        String val = String.valueOf(rs.getObject(String.valueOf(it.next())));
                        if (DataSource.this.isDate(val)) {
                            sb = sb + val.split(" ")[0] + DataSource.SPLIT_KPI_1;
                            continue;
                        }
                        sb = sb + val + DataSource.SPLIT_KPI_1;
                    }
                    sb = sb.substring(0, sb.length() - 2) + DataSource.SPLIT_KPI_2;
                }
                return sb.toString();
            }
        }, "\u65e0\u6cd5\u4ece\u6570\u636e\u6e90\u83b7\u5f97\u6570\u636e");
    }

    private boolean isDate(String args) {
        String temp = args.split(" ")[0];
        String DatePattern = "^(?:([0-9]{4}-(?:(?:0?[1,3-9]|1[0-2])-(?:29|30)|((?:0?[13578]|1[02])-31)))|([0-9]{4}-(?:0?[1-9]|1[0-2])-(?:0?[1-9]|1\\d|2[0-8]))|(((?:(\\d\\d(?:0[48]|[2468][048]|[13579][26]))|(?:0[48]00|[2468][048]00|[13579][26]00))-0?2-29)))$";
        Pattern p = Pattern.compile(DatePattern);
        Matcher m = p.matcher(temp);
        boolean b = m.matches();
        return b;
    }

    public static class OutputColumnEntry
    implements Comparable {
        String entry;
        int order;

        public OutputColumnEntry(String entry, int order) {
            this.entry = entry;
            this.order = order;
        }

        public int compareTo(Object o) {
            return this.order - ((OutputColumnEntry)o).order;
        }

        public boolean equals(Object obj) {
            return this.order == ((OutputColumnEntry)obj).order;
        }

        public String toString() {
            return this.entry;
        }
    }
}

