/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.export;

import com.kingdee.bos.ctrl.analysis.web.ajax.BIReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.ajax.ReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.UIO;
import com.kingdee.bos.ctrl.analysis.web.export.ExportType;
import com.kingdee.bos.ctrl.analysis.web.export.ExportTypeNotFoundException;
import com.kingdee.bos.ctrl.analysis.web.export.ZipUtil;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtReportPage;
import com.kingdee.bos.ctrl.analysis.web.pagesetup.PageSetup;
import com.kingdee.bos.ctrl.analysis.web.pagesetup.PageSetupFactory;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.export.XlsExporterParameter;
import com.kingdee.bos.ctrl.kdf.kdprint.KDPrintbase;
import com.kingdee.bos.ctrl.kdf.kdprint.PrintPage;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFont;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class ExportUtil {
    private static Pattern filePattern = Pattern.compile("[\\\\/:*?\"<>|]");
    private static final String PROPERTY_JAVA_IO_TMPDIR = "java.io.tmpdir";

    public static String export(HttpServletRequest request, ReportPage page) throws BIReportException {
        PageSetup pageSetup = PageSetupFactory.buildPageSetup(request);
        String exportType = request.getParameter("exportType");
        String fileName = null;
        if (page instanceof BIReportPage) {
            KDSBook book = null;
            try {
                String uiids = request.getParameter("exportUIList");
                String[] uiid = uiids.split(",");
                book = ExportUtil.createBook(uiid, (BIReportPage)page, pageSetup, exportType, request);
            }
            catch (Exception e) {
                throw new BIReportException("\u521b\u5efa\u4e2d\u95f4\u683c\u5f0f(KDSBook) \u5931\u8d25! \u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
            }
            if (book.getSheetCount() == 0 && book.getImages() == null) {
                throw new BIReportException("\u65e0\u53ef\u5bfc\u51fa\u7684\u5185\u5bb9!");
            }
            fileName = ExportUtil.exportFile(book, exportType, pageSetup);
        } else if (page instanceof ExtReportPage) {
            String action = "";
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (ExportType.TYPE_PDF.equalsIgnoreCase(exportType)) {
                action = "exportToPDF";
                params.put("pageSetup", pageSetup);
            } else {
                boolean isMegerExport = true;
                String megerExport = request.getParameter("isMegerExport");
                if (!StringUtil.isEmptyString((String)megerExport)) {
                    isMegerExport = Boolean.valueOf(megerExport);
                }
                params.put("isMegerExport", isMegerExport);
                if (ExportType.TYPE_EXCEL.equalsIgnoreCase(exportType)) {
                    action = "exportToExcel";
                } else if (ExportType.TYPE_EXCEL2007.equalsIgnoreCase(exportType)) {
                    action = "exportToExcel2007";
                } else {
                    throw new BIReportException("\u4e0d\u652f\u6301\u7684\u62a5\u8868\u5bfc\u51fa\u683c\u5f0f\uff1a" + exportType);
                }
            }
            fileName = ((ExtReportPage)page).getExtReport().service(request, action, params);
            try {
                fileName = URLEncoder.encode(fileName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                fileName = "EXTREPORT";
            }
        } else {
            throw new BIReportException("\u4e0d\u652f\u6301\u7684\u62a5\u8868\u6837\u5f0f\uff1a" + page.getType());
        }
        return request.getContextPath() + "/" + Constants.SERVLET_URL + "?" + "servletType" + "=" + "export" + "&" + "exportType" + "=" + exportType + "&" + "filename" + "=" + fileName;
    }

    public static String exportFile(KDSBook book, String exportType, PageSetup pageSetup) throws BIReportException {
        PrintableBook prtbook = new PrintableBook(book);
        if (ExportType.TYPE_PDF.equalsIgnoreCase(exportType)) {
            try {
                ExportUtil.setPrintPage(prtbook, pageSetup);
            }
            catch (IllegalArgumentException e) {
                throw new BIReportException("\u7eb8\u5f20\u5927\u5c0f\u6216\u8fb9\u77e9\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u8003\u8651\u6253\u5370\u7eb8\u7684\u4e0d\u53ef\u6253\u5370\u533a\u57df\uff01");
            }
        }
        File tempFile = null;
        try {
            tempFile = ExportUtil.createTempFile(exportType);
        }
        catch (IOException e) {
            throw new BIReportException("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff01\u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
        }
        ExportManager exportManager = new ExportManager();
        if (ExportType.TYPE_PDF.equalsIgnoreCase(exportType)) {
            exportManager.exportToPdfFile(prtbook, tempFile.getAbsolutePath());
        } else if (ExportType.TYPE_EXCEL.equalsIgnoreCase(exportType)) {
            exportManager.setExporterParmeter((ExporterParameter)XlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)new Boolean(false));
            exportManager.exportToExcel(prtbook, tempFile.getAbsolutePath());
        }
        return tempFile.getName();
    }

    private static void setPrintPage(PrintableBook prtbook, PageSetup pageSetup) {
        KDPrintbase printBase = prtbook.getPrintBase();
        PrintPage printPage = printBase.getPrintPage();
        printPage.setPrintPageH((float)pageSetup.getPaperSizeHeight());
        printPage.setPrintPageW((float)pageSetup.getPaperSizeWidth());
        printPage.setLeftEdge((float)pageSetup.getPaperMaginLeft());
        printPage.setTopEdge((float)pageSetup.getPaperMaginTop());
        printPage.setRightEdge((float)pageSetup.getPaperMaginRight());
        printPage.setBottomEdge((float)pageSetup.getPaperMaginBottom());
    }

    private static KDSBook createBook(String[] uiid, BIReportPage page, PageSetup pageSetup, String exportType, HttpServletRequest request) throws Exception {
        KDSBook book = new KDSBook("bi_book");
        KDSSheet sheetAfter = null;
        for (int ii = 0; ii < uiid.length; ++ii) {
            UIO uio = page.getUIO(uiid[ii]);
            KDSSheet sheet = uio.getComponent().export(book, pageSetup, exportType, ii + 1, request);
            if (sheet == null) continue;
            sheetAfter = book.addSheet(sheetAfter, sheet);
        }
        return book;
    }

    public static File createTempFile(String exportType) throws IOException, ExportTypeNotFoundException {
        String tempDirName = System.getProperty(PROPERTY_JAVA_IO_TMPDIR);
        if (tempDirName == null) {
            throw new RuntimeException("Temporary directory system property (java.io.tmpdir) is null.");
        }
        File tempDir = new File(tempDirName);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        String prefix = "temp-" + exportType + "-";
        File tempFile = null;
        tempFile = File.createTempFile(prefix, "." + ExportType.findFileSuffix(exportType), new File(System.getProperty(PROPERTY_JAVA_IO_TMPDIR)));
        return tempFile;
    }

    public static File createTempDashboardFile() throws IOException, ExportTypeNotFoundException {
        String exportType = "zip";
        String tempDirName = System.getProperty(PROPERTY_JAVA_IO_TMPDIR);
        if (tempDirName == null) {
            throw new RuntimeException("Temporary directory system property (java.io.tmpdir) is null.");
        }
        File tempDir = new File(tempDirName);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        String prefix = "Dashboard";
        File tempFile = null;
        tempFile = File.createTempFile(prefix, "." + ExportType.findFileSuffix(exportType), new File(System.getProperty(PROPERTY_JAVA_IO_TMPDIR)));
        return tempFile;
    }

    public static int calcWidth(KDSSheet sheet, String strCellValue) {
        int ret = 0;
        if (strCellValue == null || strCellValue.equals("")) {
            return ret + 10;
        }
        StyleAttributes sa = sheet.getSheetStyleAttributes();
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics((Font)new KDFont(sa.getFontName(), 0, sa.getFontSize()));
        try {
            ret = fm.stringWidth(strCellValue) + 10;
        }
        catch (Exception e) {
            try {
                Font font = Font.createFont(0, new File(System.getProperty("eas.properties.dir") + "/simsun.ttc"));
                font = font.deriveFont(sa.getFontSize());
                if (font == null) {
                    throw new RuntimeException("\u672a\u627e\u5230\u6307\u5b9a\u5b57\u4f53!");
                }
                ret = (int)font.getStringBounds(strCellValue, new FontRenderContext(new AffineTransform(), false, false)).getWidth();
                System.out.println("Target String: " + strCellValue + " String Width: " + ret);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (FontFormatException e2) {
                e2.printStackTrace();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        return ret;
    }

    public static int calcWidth(KDSCell cell, String strCellValue) {
        Style sa = cell.getStyle();
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics((Font)new KDFont(sa.getFontName(), 0, sa.getFontSize()));
        return fm.stringWidth(strCellValue) + 10;
    }

    public static void setSheetCellBorder(KDSSheet sheet, int row, int col) {
        sheet.getCellStyleAttributes(row, col).setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        sheet.getCellStyleAttributes(row, col).setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        sheet.getCellStyleAttributes(row, col).setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        sheet.getCellStyleAttributes(row, col).setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
    }

    public static File getTempFile(String filename) {
        File file = new File(System.getProperty(PROPERTY_JAVA_IO_TMPDIR), filename);
        if (!file.exists()) {
            throw new RuntimeException("File '" + file.getAbsolutePath() + "' does not exist");
        }
        return file;
    }

    public static String getTempDir() {
        String tempDirName = System.getProperty(PROPERTY_JAVA_IO_TMPDIR);
        if (tempDirName == null) {
            throw new RuntimeException("Temporary directory system property (java.io.tmpdir) is null.");
        }
        if (!tempDirName.endsWith("/") && !tempDirName.endsWith("\\")) {
            tempDirName = tempDirName + "/";
        }
        return tempDirName;
    }

    public static void addMergeWithBorder(KDSSheet sheet, int row, int col, int rowspan, int colspan) {
        if (rowspan > 1 || colspan > 1) {
            sheet.getMerges().addMerge(row, col, row + rowspan - 1, col + colspan - 1);
            for (int i = 0; i < rowspan; ++i) {
                for (int j = 0; j < colspan; ++j) {
                    ExportUtil.setSheetCellBorder(sheet, row + i, col + j);
                }
            }
        } else {
            ExportUtil.setSheetCellBorder(sheet, row, col);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String exportDashboard(Repository rep, HttpServletRequest request, String paths) throws RepositoryException {
        String string;
        System.out.println(Locale.getDefault().toString());
        ZipUtil.zip("f:/\u5ba1\u8ba1\u90e8\u8bfe\u9898/", "f:/aaa.zip");
        String[] fullpaths = paths.split("\\|");
        File exportFile = null;
        ZipOutputStream out = null;
        try {
            exportFile = ExportUtil.createTempDashboardFile();
            out = new ZipOutputStream((OutputStream)new FileOutputStream(exportFile));
            ExportUtil.zip(out, null, fullpaths, rep);
            out.flush();
            string = request.getContextPath() + "/" + Constants.SERVLET_URL + "?" + "servletType" + "=" + "export" + "&" + "exportType" + "=zip&" + "filename" + "=" + exportFile.getName();
        }
        catch (ExportTypeNotFoundException e) {
            try {
                throw new RepositoryException(e);
                catch (IOException e2) {
                    throw new RepositoryException(e2);
                }
                catch (Exception e3) {
                    throw new RepositoryException(e3);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{out});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{out});
        return string;
    }

    private static void zip(ZipOutputStream out, String baseName, String[] fullpaths, Repository rep) throws Exception {
        String prix = "/dashboard_tree";
        int len = fullpaths.length;
        for (int i = 0; i < len; ++i) {
            String caption;
            String baseName2;
            if (!fullpaths[i].startsWith(prix)) {
                fullpaths[i] = prix + fullpaths[i];
            }
            boolean isFolder = rep.isFolder("DBD", fullpaths[i]);
            String string = baseName2 = baseName == null ? "" : baseName + "/";
            if (!isFolder) {
                caption = rep.getDashboardCaption(fullpaths[i]);
                byte[] content = rep.getNodeBinaryData("DBD", fullpaths[i]);
                ExportUtil.zip(out, baseName2 + caption, content);
                continue;
            }
            System.out.println(baseName2);
            out.putNextEntry(new ZipEntry(baseName2));
            caption = rep.getNodePropertyByPath("DBD", fullpaths[i], "caption");
            List listFullpaths2 = rep.getNodeChildrenPaths("DBD", fullpaths[i]);
            String[] fullpaths2 = new String[listFullpaths2.size()];
            listFullpaths2.toArray(fullpaths2);
            ExportUtil.zip(out, baseName2 + caption, fullpaths2, rep);
        }
    }

    private static void zip(ZipOutputStream out, String baseName, byte[] content) throws Exception {
        System.out.println(baseName);
        out.putNextEntry(new ZipEntry(baseName));
        out.write(content);
        out.closeEntry();
    }
}

