/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ext.mp.service;

import com.kingdee.bos.ctrl.analysis.web.ext.mp.dao.MyFolderTreeDAO;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.dao.ReportOfMyFolderDAO;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.vo.MyFolderNodeVO;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.vo.ReportOfMyFolderVO;
import com.kingdee.bos.ctrl.analysis.web.ext.util.IDMaker;
import com.kingdee.bos.ctrl.analysis.web.ext.util.JDBCUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.UID;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class MyFolderService {
    private static final Logger logger = CommonLogger.getLogger(MyFolderService.class);
    private static MyFolderTreeDAO myFolderDAO = new MyFolderTreeDAO();
    private static ReportOfMyFolderDAO reportOfMyFolderDAO = new ReportOfMyFolderDAO();

    public void leavingMyFolder(HttpServletRequest request) throws BIReportException {
        Connection conn = null;
        try {
            conn = BISystem.getJdbcConnection(request);
            conn.setAutoCommit(true);
            String folderId = request.getParameter("folderId");
            MyFolderNodeVO folderNodeVO = new MyFolderNodeVO();
            folderNodeVO.setId(folderId);
            folderNodeVO.setCreatorId(BISystem.getCurrentUser(request));
            folderNodeVO.setOrgId(BISystem.getCurrentOrgUnitID(request));
            myFolderDAO.deleteFolderNode(conn, folderNodeVO);
            ReportOfMyFolderVO dVO = new ReportOfMyFolderVO();
            dVO.setFolderNodeId(folderId);
            dVO.setCreatorId(BISystem.getCurrentUser(request));
            dVO.setOrgId(BISystem.getCurrentOrgUnitID(request));
            reportOfMyFolderDAO.deleteFromMyFolder(conn, dVO);
        }
        catch (SQLException e) {
            if (null != conn) {
                try {
                    conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            logger.warn((Object)"\u5220\u9664\u6587\u4ef6\u5939\u5931\u8d25", (Throwable)e);
            throw new BIReportException(e);
        }
        finally {
            if (null != conn) {
                JDBCUtil.close(conn);
            }
        }
    }

    public void join2MyFolderBatch(HttpServletRequest request) throws BIReportException {
        Connection conn = null;
        try {
            conn = BISystem.getJdbcConnection(request);
            String reportArrStr = request.getParameter("reportId");
            String folderId = request.getParameter("folderId");
            String reportType = request.getParameter("reportType");
            String longNumber = request.getParameter("longNumber");
            String[] reportArr = reportArrStr.split(",");
            conn.setAutoCommit(false);
            for (int i = 0; i < reportArr.length; ++i) {
                ReportOfMyFolderVO vo = new ReportOfMyFolderVO();
                vo.setId(UID.create((int)44));
                vo.setReportId(reportArr[i]);
                vo.setFolderNodeId(folderId);
                vo.setReportType(Integer.parseInt(reportType));
                vo.setCreateTime(new Date(System.currentTimeMillis()));
                vo.setCreatorId(BISystem.getCurrentUser(request));
                vo.setOrgId(BISystem.getCurrentOrgUnitID(request));
                vo.setLongNumber(longNumber);
                boolean isExisted = reportOfMyFolderDAO.isReportAlreadyIn(conn, vo);
                if (isExisted) continue;
                reportOfMyFolderDAO.addToMyFolder(conn, vo);
            }
            conn.commit();
        }
        catch (SQLException e) {
            if (null != conn) {
                try {
                    conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            logger.warn((Object)"\u6279\u91cf\u62a5\u8868\u6dfb\u52a0\u5230\u6587\u4ef6\u5939\u5931\u8d25", (Throwable)e);
            throw new BIReportException(e);
        }
        finally {
            if (null != conn) {
                JDBCUtil.close(conn);
            }
        }
    }

    public void join2MyFolder(HttpServletRequest request) throws BIReportException {
        Connection conn = null;
        try {
            conn = BISystem.getJdbcConnection(request);
            String reportId = request.getParameter("reportId");
            String folderId = request.getParameter("folderId");
            String reportType = request.getParameter("reportType");
            String longNumber = request.getParameter("longNumber");
            ReportOfMyFolderVO vo = new ReportOfMyFolderVO();
            vo.setId(UID.create((int)44));
            vo.setReportId(reportId);
            vo.setFolderNodeId(folderId);
            vo.setReportType(Integer.parseInt(reportType));
            vo.setCreateTime(new Date(System.currentTimeMillis()));
            vo.setCreatorId(BISystem.getCurrentUser(request));
            vo.setOrgId(BISystem.getCurrentOrgUnitID(request));
            vo.setLongNumber(longNumber);
            conn.setAutoCommit(false);
            boolean isExisted = reportOfMyFolderDAO.isReportAlreadyIn(conn, vo);
            if (isExisted) {
                throw new BIReportException("\u62a5\u8868\u5df2\u88ab\u6dfb\u52a0\u5230\u8be5\u6587\u4ef6\u5939\u4e2d");
            }
            reportOfMyFolderDAO.addToMyFolder(conn, vo);
            conn.commit();
        }
        catch (SQLException e) {
            if (null != conn) {
                try {
                    conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            logger.warn((Object)"\u62a5\u8868\u6dfb\u52a0\u5230\u6587\u4ef6\u5939\u5931\u8d25", (Throwable)e);
            throw new BIReportException(e);
        }
        finally {
            if (null != conn) {
                JDBCUtil.close(conn);
            }
        }
    }

    public void move2MyFolderBatch(HttpServletRequest request) throws BIReportException {
        Connection conn = null;
        try {
            conn = BISystem.getJdbcConnection(request);
            String reportArrStr = request.getParameter("reportId");
            String folderId = request.getParameter("folderId");
            String[] reportArr = reportArrStr.split(",");
            conn.setAutoCommit(false);
            for (int i = 0; i < reportArr.length; ++i) {
                ReportOfMyFolderVO vo = new ReportOfMyFolderVO();
                vo.setReportId(reportArr[i]);
                vo.setFolderNodeId(folderId);
                vo.setCreateTime(new Date(System.currentTimeMillis()));
                vo.setCreatorId(BISystem.getCurrentUser(request));
                vo.setOrgId(BISystem.getCurrentOrgUnitID(request));
                boolean isExisted = reportOfMyFolderDAO.isReportAlreadyIn(conn, vo);
                if (isExisted) continue;
                reportOfMyFolderDAO.changeFolder(conn, vo);
            }
            conn.commit();
        }
        catch (SQLException e) {
            if (null != conn) {
                try {
                    conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            logger.warn((Object)"\u6279\u91cf\u62a5\u8868\u79fb\u52a8\u5230\u6587\u4ef6\u5939\u5931\u8d25", (Throwable)e);
            throw new BIReportException(e);
        }
        finally {
            if (null != conn) {
                JDBCUtil.close(conn);
            }
        }
    }

    public void move2MyFolder(HttpServletRequest request) throws BIReportException {
        Connection conn = null;
        try {
            conn = BISystem.getJdbcConnection(request);
            String reportId = request.getParameter("reportId");
            String folderId = request.getParameter("folderId");
            ReportOfMyFolderVO vo = new ReportOfMyFolderVO();
            vo.setReportId(reportId);
            vo.setFolderNodeId(folderId);
            vo.setCreateTime(new Date(System.currentTimeMillis()));
            vo.setCreatorId(BISystem.getCurrentUser(request));
            vo.setOrgId(BISystem.getCurrentOrgUnitID(request));
            conn.setAutoCommit(false);
            boolean isExisted = reportOfMyFolderDAO.isReportAlreadyIn(conn, vo);
            if (isExisted) {
                throw new BIReportException("\u62a5\u8868\u5df2\u88ab\u6dfb\u52a0\u5230\u8be5\u6587\u4ef6\u5939\u4e2d");
            }
            reportOfMyFolderDAO.changeFolder(conn, vo);
            conn.commit();
        }
        catch (SQLException e) {
            if (null != conn) {
                try {
                    conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            logger.warn((Object)"\u62a5\u8868\u79fb\u52a8\u5230\u6587\u4ef6\u5939\u5931\u8d25", (Throwable)e);
            throw new BIReportException(e);
        }
        finally {
            if (null != conn) {
                JDBCUtil.close(conn);
            }
        }
    }

    public MyFolderNodeVO renameMyFolderNode(HttpServletRequest request) throws BIReportException {
        Connection conn = null;
        try {
            conn = BISystem.getJdbcConnection(request);
            String id = request.getParameter("id");
            String name = request.getParameter("dirName");
            MyFolderNodeVO node = new MyFolderNodeVO();
            node.setId(id);
            node.setName(name);
            node.setModifiedTime(new Date(System.currentTimeMillis()));
            node.setCreatorId(BISystem.getCurrentUser(request));
            node.setOrgId(BISystem.getCurrentOrgUnitID(request));
            conn.setAutoCommit(false);
            boolean isExist = myFolderDAO.isNameExist(conn, node);
            if (isExist) {
                throw new BIReportException("\u5df2\u6709\u540c\u540d\u7684\u6587\u4ef6\u5939");
            }
            node = myFolderDAO.updateFolderName(conn, node);
            conn.commit();
            MyFolderNodeVO myFolderNodeVO = node;
            return myFolderNodeVO;
        }
        catch (SQLException e) {
            logger.warn((Object)"\u66f4\u65b0\u6587\u4ef6\u5939\u540d\u79f0\u5931\u8d25", (Throwable)e);
            throw new BIReportException(e);
        }
        finally {
            if (null != conn) {
                JDBCUtil.close(conn);
            }
        }
    }

    public MyFolderNodeVO addMyFolderNode(HttpServletRequest request) throws BIReportException {
        Connection conn = null;
        try {
            conn = BISystem.getJdbcConnection(request);
            String pid = request.getParameter("pid");
            int level = Integer.parseInt(request.getParameter("level"));
            String name = request.getParameter("name");
            String longNumber = request.getParameter("longNumber");
            MyFolderNodeVO node = new MyFolderNodeVO();
            String id = UID.create((int)44);
            node.setId(id);
            node.setPid(pid);
            node.setLeaf(false);
            node.setLevel(level + 1);
            node.setName(name);
            node.setLongNumber(longNumber + '/' + id);
            node.setNodeType(3);
            node.setCreatorId(BISystem.getCurrentUser(request));
            node.setOrgId(BISystem.getCurrentOrgUnitID(request));
            node.setCreateTime(new Date(System.currentTimeMillis()));
            conn.setAutoCommit(false);
            boolean isExist = myFolderDAO.isNameExist(conn, node);
            if (isExist) {
                throw new BIReportException("\u5df2\u6709\u540c\u540d\u7684\u6587\u4ef6\u5939");
            }
            myFolderDAO.insertMyFolderNode(conn, node);
            conn.commit();
            MyFolderNodeVO myFolderNodeVO = node;
            return myFolderNodeVO;
        }
        catch (SQLException e) {
            if (null != conn) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    logger.warn((Object)"\u589e\u52a0\u6211\u7684\u6587\u4ef6\u5939\u8282\u70b9 rollback\u64cd\u4f5c\u5931\u8d25", (Throwable)e1);
                }
            }
            logger.warn((Object)"\u83b7\u5f97JDBC\u8fde\u63a5\u5931\u8d25");
            throw new BIReportException(e);
        }
        finally {
            if (null != conn) {
                JDBCUtil.close(conn);
            }
        }
    }

    public MyFolderNodeVO buildMyFolderTree(HttpServletRequest request, boolean forExtReport) throws BIReportException {
        Connection conn = null;
        try {
            conn = BISystem.getJdbcConnection(request);
            MyFolderNodeVO params = new MyFolderNodeVO();
            params.setCreatorId(BISystem.getCurrentUser(request));
            params.setOrgId(BISystem.getCurrentOrgUnitID(request));
            if (forExtReport) {
                MyFolderNodeVO myFolderNodeVO = this.addExtReportNode(myFolderDAO.buildMyFolderTree(conn, params));
                return myFolderNodeVO;
            }
            MyFolderNodeVO myFolderNodeVO = myFolderDAO.buildMyFolderTree(conn, params);
            return myFolderNodeVO;
        }
        catch (SQLException e) {
            logger.warn((Object)"\u83b7\u5f97JDBC\u8fde\u63a5\u5931\u8d25");
            throw new BIReportException(e);
        }
        finally {
            if (null != conn) {
                JDBCUtil.close(conn);
            }
        }
    }

    public MyFolderNodeVO addExtReportNode(MyFolderNodeVO pNode) {
        MyFolderNodeVO node = new MyFolderNodeVO();
        node.setName("\u6a21\u677f");
        node.setId(IDMaker.getUUID());
        node.setPid(pNode.getId());
        node.setLeaf(true);
        node.setNodeType(2);
        node.setLongNumber(pNode.getLongNumber());
        ArrayList children = pNode.getChildren();
        if (null != children) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                this.addExtReportNode((MyFolderNodeVO)children.get(i));
            }
        }
        pNode.addChild(node);
        return pNode;
    }
}

