/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.repository;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.piece.Piece;
import com.kingdee.bos.ctrl.analysis.web.repository.IORMRPCBIJCRService;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryImpl;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterScheme;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeModel;

public class RepositoryRPCService
extends ORMObject
implements IORMRPCBIJCRService {
    Repository repository;
    static Map mapRepository = new HashMap();

    public RepositoryRPCService(String dataCenter, String user, String cu, String password, String userNumber) throws BIReportException {
        this(dataCenter, user, cu, false, password, userNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryRPCService(String dataCenter, String user, String cu, boolean isWeb, String password, String userNumber) throws BIReportException {
        if (!this.verifyToken(password, userNumber)) {
            throw new IllegalStateException("Illegal rpc call.");
        }
        Map map = mapRepository;
        synchronized (map) {
            if (!mapRepository.containsKey(dataCenter)) {
                try {
                    this.repository = new RepositoryImpl(dataCenter, user, cu, isWeb);
                }
                catch (RepositoryException e) {
                    throw new BIReportException("\u672a\u627e\u5230\u8d26\u5957" + dataCenter + "\u7684\u5b58\u50a8\u670d\u52a1\uff01", e);
                }
                mapRepository.put(dataCenter, this.repository);
            }
            this.repository = (RepositoryImpl)mapRepository.get(dataCenter);
        }
    }

    private boolean verifyToken(String password, String userNumber) {
        boolean result = false;
        LtpaTokenManager.loadDefaultConfig();
        if (StringUtil.isEmptyString((String)password)) {
            return false;
        }
        String token = password;
        if (LtpaTokenManager.isValid((String)token)) {
            result = LtpaTokenManager.compare((String)token, (String)userNumber);
        }
        return result;
    }

    @Override
    public String addNewDirectory(String parent, String caption, String dirName, int treeType, String user, String cu) throws RepositoryException {
        return this.repository.addNewDirectory(parent, caption, dirName, treeType, user, cu);
    }

    @Override
    public void close() {
        this.repository.close();
    }

    @Override
    public void delNode(String path, int treeType, Context ctx) throws RepositoryException {
        this.repository.delNode(path, treeType, ctx);
    }

    @Override
    public List executeQuery(String ksql) throws RepositoryException {
        return this.repository.executeQuery(ksql);
    }

    @Override
    public String executeQuery2(String sql) throws RepositoryException {
        return this.repository.executeQuery2(sql);
    }

    @Override
    public int executeUpdate(String ksql) throws RepositoryException {
        return this.repository.executeUpdate(ksql);
    }

    @Override
    public String getDashboardCaptionByID(String id) {
        return this.repository.getDashboardCaptionByID(id);
    }

    @Override
    public String getDashboardPathByID(String id) {
        return this.repository.getDashboardPathByID(id);
    }

    @Override
    public String getDashboardXML(String path) throws RepositoryException {
        return this.repository.getDashboardXML(path);
    }

    @Override
    public String getHomePage(String userId, String orgID) throws RepositoryException {
        return this.repository.getHomePage(userId, orgID);
    }

    @Override
    public byte[] getNodeBinaryData(String ws, String path) throws RepositoryException {
        return this.repository.getNodeBinaryData(ws, path);
    }

    @Override
    public int getNodeChildCount(String ws, String path) throws RepositoryException {
        return this.repository.getNodeChildCount(ws, path);
    }

    @Override
    public List getNodeChildrenPaths(String ws, String path) throws RepositoryException {
        return this.repository.getNodeChildrenPaths(ws, path);
    }

    @Override
    public Calendar getNodeLastModified(String ws, String path) throws RepositoryException {
        return this.repository.getNodeLastModified(ws, path);
    }

    @Override
    public String getNodeNameByPath(String ws, String path) throws RepositoryException {
        return this.repository.getNodeNameByPath(ws, path);
    }

    @Override
    public String getNodePropertyByPath(String ws, String path, String property) throws RepositoryException {
        return this.repository.getNodePropertyByPath(ws, path, property);
    }

    @Override
    public String getNodePropertyByPath2(String ws, String path, String propertyName) throws RepositoryException {
        return this.repository.getNodePropertyByPath2(ws, path, propertyName);
    }

    @Override
    public String getRelationPath(String wsName, String path, String basePath) throws RepositoryException {
        return this.repository.getRelationPath(wsName, path, basePath);
    }

    @Override
    public String getReportURLFromPiece(String pieceRepPath, String contextPath) throws RepositoryException {
        return this.repository.getReportURLFromPiece(pieceRepPath, contextPath);
    }

    @Override
    public boolean isDynamicPiece(String piecePath) throws RepositoryException {
        return this.repository.isDynamicPiece(piecePath);
    }

    @Override
    public boolean isSnapshotPiece(String piecePath) throws RepositoryException {
        return this.repository.isSnapshotPiece(piecePath);
    }

    @Override
    public boolean nodeExist(String wsName, String path) {
        return this.repository.nodeExist(wsName, path);
    }

    @Override
    public boolean nodeIsFile(String wsName, String path) {
        return this.repository.nodeIsFile(wsName, path);
    }

    @Override
    public void renameDirectory(String parent, String oldName, String newName, int treeType, String user, String cu) throws RepositoryException {
        this.repository.renameDirectory(parent, oldName, newName, treeType, user, cu);
    }

    @Override
    public String saveDashboard(String parentPath, String caption, String name, String content, String user, String cu) throws RepositoryException {
        return this.repository.saveDashboard(parentPath, caption, name, content, user, cu);
    }

    @Override
    public void saveFilterScheme(FilterScheme fs, String currentUser, boolean isSuperUser) throws RepositoryException {
        this.repository.saveFilterScheme(fs, currentUser, isSuperUser);
    }

    @Override
    public String savePiece(Piece piece, String user) throws RepositoryException {
        return this.repository.savePiece(piece, user);
    }

    @Override
    public String saveResource(boolean overwrite, String parent, String caption, String resName, byte[] data, String imageType) throws RepositoryException {
        return this.repository.saveResource(overwrite, parent, caption, resName, data, imageType);
    }

    @Override
    public void testDashboardCall(String user, String cu, Context ctx) {
        this.repository.testDashboardCall(user, cu, ctx);
    }

    @Override
    public void testCall(String user, String cu, Context ctx) {
        this.repository.testCall(user, cu, ctx);
    }

    @Override
    public String getThemeReportFlag(String wsName, String path) throws RepositoryException {
        return this.repository.getThemeReportFlag(wsName, path);
    }

    @Override
    public void delFilterScheme(String caption, String reportPath, String currentUser, boolean isSuperUser) throws RepositoryException {
        this.repository.delFilterScheme(caption, reportPath, currentUser, isSuperUser);
    }

    @Override
    public FilterScheme[] loadFilterSchemesSharedByOrgUnit(String reportPath, BIReportFilter filter, OrgUnitInfo info) throws RepositoryException {
        return this.repository.loadFilterSchemesSharedByOrgUnit(reportPath, filter, info);
    }

    @Override
    public FilterScheme[] loadFilterSchemesSharedByUser(String reportPath, BIReportFilter filter, String user, boolean isSuperUser) throws RepositoryException {
        return this.repository.loadFilterSchemesSharedByUser(reportPath, filter, user, isSuperUser);
    }

    @Override
    public FilterScheme[] loadFilterSchemesSharedByUserAndOrgUnit(String reportPath, BIReportFilter filter) throws RepositoryException {
        return this.repository.loadFilterSchemesSharedByUserAndOrgUnit(reportPath, filter);
    }

    @Override
    public TreeModel getBITree(int treeType) throws RepositoryException {
        return this.repository.getBITree(treeType);
    }

    @Override
    public String saveThemeReport(String parentNodePath, String parentNodeDisplayPath, String oldDisplayName, String displayName, String reportURL, String themeReportType, String user, String cu) throws RepositoryException {
        return this.repository.saveThemeReport(parentNodePath, parentNodeDisplayPath, oldDisplayName, displayName, reportURL, themeReportType, user, cu);
    }

    @Override
    public String saveThemeReport(String parentNodePath, String parentNodeDisplayPath, String oldDisplayName, String displayName, String reportURL, String themeReportType, String user, String cu, String datacenter) throws RepositoryException {
        return this.repository.saveThemeReport(parentNodePath, parentNodeDisplayPath, oldDisplayName, displayName, reportURL, themeReportType, user, cu, datacenter);
    }

    @Override
    public boolean isFolder(String wsName, String path) throws RepositoryException {
        return this.repository.isFolder(wsName, path);
    }

    @Override
    public boolean isThemeReport(String path) throws RepositoryException {
        return this.repository.isThemeReport(path);
    }

    @Override
    public String getThemeReportType(String path) throws RepositoryException {
        return this.repository.getThemeReportType(path);
    }

    @Override
    public void removeExtReport(String path, Context ctx) throws RepositoryException {
        this.repository.removeExtReport(path, ctx);
    }

    @Override
    public List execQueryStmt(String sql, Object[] params) throws RepositoryException {
        return this.repository.execQueryStmt(sql, params);
    }

    @Override
    public void renameDashboard(String dashboardpath, String newcaption, String user, String cu) throws RepositoryException {
        this.repository.renameDashboard(dashboardpath, newcaption, user, cu);
    }

    @Override
    public String getDashboardCaption(String path) throws RepositoryException {
        return this.repository.getDashboardCaption(path);
    }

    @Override
    public String[][] findDashboardPaths(String parentPath, String[] captions) throws RepositoryException {
        return this.repository.findDashboardPaths(parentPath, captions);
    }

    @Override
    public void removeDupontReport(String path, Context ctx) throws RepositoryException {
        this.repository.removeDupontReport(path, ctx);
    }

    @Override
    public Object call(String methodname, Map parameters) throws RepositoryException {
        return this.repository.call(methodname, parameters);
    }

    @Override
    public void saveNodeProperty(String workspace, String nodePath, String propName, String propValue) throws RepositoryException {
        this.repository.saveNodeProperty(workspace, nodePath, propName, propValue);
    }

    @Override
    public String getThemeReportPropertyByPath(String path, String property) throws RepositoryException {
        return this.repository.getThemeReportPropertyByPath(path, property);
    }

    @Override
    public String getNodeCaptionByPath(String ws, String path) throws RepositoryException {
        return this.getNodePropertyByPath2(ws, path, "caption");
    }

    @Override
    public int getColumnType(String sql, String columnName) throws RepositoryException {
        return this.repository.getColumnType(sql, columnName);
    }

    @Override
    public String getReportPathCaption(String resourePath) throws RepositoryException {
        return this.repository.getReportPathCaption(resourePath);
    }
}

