/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.config;

import com.kingdee.bos.ctrl.analysis.web.solution.BISubject;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.BISubjectImpl;
import com.kingdee.bos.ctrl.analysis.web.solution.util.BISolutionCaptionUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.util.FolderUtil;
import java.io.File;
import java.util.Arrays;

public class BISubjectConfig {
    private String subjectsPath = "";

    public BISubjectConfig(String subjectsPath) {
        this.subjectsPath = subjectsPath;
    }

    public String[] getAllSubjectName() {
        return FolderUtil.getChildrenFolderName(this.subjectsPath, Arrays.asList("cvs", ".svn"));
    }

    public BISubject lookupSubject(String name) throws BIReportException {
        BISubject subject = null;
        String[] subjectNames = this.getAllSubjectName();
        if (subjectNames != null && subjectNames.length > 0) {
            for (int index = 0; index < subjectNames.length; ++index) {
                if (!subjectNames[index].equalsIgnoreCase(name)) continue;
                subject = this.createSubject(subjectNames[index]);
                break;
            }
        }
        return subject;
    }

    private BISubject createSubject(String path) throws BIReportException {
        File folder = new File(this.subjectsPath + File.separator + path);
        String metaFilename = folder.getPath() + File.separator + ".meta";
        String runtimeVarFilename = folder.getPath() + File.separator + "runtime.var";
        String name = folder.getName();
        String foldername = folder.getName();
        String caption = BISolutionCaptionUtil.getCaption(metaFilename, ".", name);
        return new BISubjectImpl(name, caption, foldername, runtimeVarFilename);
    }
}

