/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.util;

import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BISolutionCaptionUtil {
    public static String getCaption(String xmlFilename, String elementName, String defaultValue) throws BIReportException {
        String caption = "";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            File fileXML = new File(xmlFilename);
            if (fileXML.exists() && fileXML.length() > 0L) {
                Document doc = builder.parse(new File(xmlFilename));
                Element rootXML = doc.getDocumentElement();
                caption = XmlUtil.getNodeAttributeByName(rootXML, "Element", elementName, "caption");
            }
        }
        catch (Exception e) {
            throw new BIReportException("\u89e3\u6790XML\u6587\u4ef6" + xmlFilename + "\u51fa\u9519!", e);
        }
        if (caption == null || caption.equalsIgnoreCase("")) {
            caption = defaultValue;
        }
        return caption;
    }

    public static String[] getCaptions(String[] paths, String[] names, boolean[] isFiles) throws BIReportException {
        if (paths == null || paths.length <= 0) {
            return null;
        }
        String[] captions = new String[paths.length];
        for (int index = 0; index < paths.length; ++index) {
            if (!isFiles[index]) {
                String metaFilename = paths[index] + File.separator + ".meta";
                captions[index] = BISolutionCaptionUtil.getCaption(metaFilename, ".", names[index]);
                continue;
            }
            File f = new File(paths[index]);
            String metaFilename = f.getParent() + File.separator + ".meta";
            captions[index] = BISolutionCaptionUtil.getCaption(metaFilename, names[index], names[index]);
        }
        return captions;
    }

    public static String[] getCaptions(String[] paths, String[] names) throws BIReportException {
        boolean[] isFiles = new boolean[paths.length];
        return BISolutionCaptionUtil.getCaptions(paths, names, isFiles);
    }
}

