/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.sql;

import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.sql.SQLMeta;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SQLProvider {
    private List sqlMetas;
    private Map mapSQLFirstRow = new HashMap();

    public SQLProvider(List sqlMetas) {
        this.sqlMetas = sqlMetas;
    }

    public void clear() {
        this.mapSQLFirstRow.clear();
    }

    private String findSql(String name) {
        if (this.sqlMetas == null) {
            return null;
        }
        for (SQLMeta m : this.sqlMetas) {
            if (!name.equalsIgnoreCase(m.getName())) continue;
            return m.getSql();
        }
        return null;
    }

    public Map getFirstRow(String sqlName, HttpServletRequest req) throws BIReportException {
        if (this.mapSQLFirstRow.containsKey(sqlName)) {
            return (Map)this.mapSQLFirstRow.get(sqlName);
        }
        HashMap<String, Object> mapRow = new HashMap<String, Object>();
        String sql = this.findSql(sqlName);
        if (sql == null) {
            throw new BIReportException("sql " + sqlName + " \u672a\u627e\u5230!");
        }
        String topSql = sql.toLowerCase();
        topSql = topSql.indexOf("order by") != -1 ? sql.substring(0, topSql.indexOf("order by")) : sql;
        if (topSql.indexOf("top 1") == -1) {
            topSql = "select top 1 * from (" + topSql + ") as A";
        }
        Connection con = null;
        PreparedStatement pst = null;
        ResultSet result = null;
        try {
            con = BISystem.getJdbcConnection(req);
            pst = con.prepareStatement(topSql);
            result = pst.executeQuery();
            if (result.next()) {
                int columnCount = result.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    mapRow.put(result.getMetaData().getColumnName(i).toLowerCase(), result.getObject(i));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BIReportException("\u6267\u884csql\u5931\u8d25!\u539f\u56e0:" + e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(result, pst, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)result, (Statement)pst, (Connection)con);
        this.mapSQLFirstRow.put(sqlName, mapRow);
        return mapRow;
    }
}

